/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.configuration;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="piglinproliferation", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PPConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        Pair specPair1 = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)specPair1.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair1.getRight();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue healingArrowDamage;
        public final ForgeConfigSpec.BooleanValue BruteBuckler;
        public final ForgeConfigSpec.BooleanValue BangBlockDestruction;
        public final ForgeConfigSpec.IntValue alchemistWeightInBastions;
        public final ForgeConfigSpec.DoubleValue healingArrowChances;
        public final ForgeConfigSpec.DoubleValue piglinVariantChances;
        public final ForgeConfigSpec.DoubleValue zombifiedPiglinDefaultChance;
        public final ForgeConfigSpec.DoubleValue zombifiedBruteChance;
        public final ForgeConfigSpec.DoubleValue zombifiedAlchemistChance;
        public final ForgeConfigSpec.DoubleValue alchemistPotionChance;
        public final ForgeConfigSpec.DoubleValue bucklerChance;
        public final ForgeConfigSpec.IntValue healingArrowMinStackSize;
        public final ForgeConfigSpec.IntValue healingArrowMaxStackSize;
        public final ForgeConfigSpec.IntValue BucklerCooldown;
        public final ForgeConfigSpec.IntValue BucklerRunTime;
        public final ForgeConfigSpec.IntValue BucklerTurningRunTime;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> zombifiedPiglinTypeList;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Vanilla Changes");
            this.healingArrowDamage = builder.define("Allow healing and Regeneration arrows to not do damage?", true);
            this.alchemistWeightInBastions = builder.comment(new String[]{"Weight is calculated by dividing the current value by the sum of all weights combined.", "Use https://minecraft.fandom.com/wiki/Bastion_Remnant?so=search#cite_ref-piglin_group_1-39 as a guide.", "The default weight for alchemists spawning is 4, giving them a 28% chance of spawning in bastions", "(Due to this, regular piglins have a spawn rate of 28% aswell, and brutes have a spawn rate of 7% spawn rate, changed values will have to account for this).", "To change the natural spawn rates, use a datapack that overrides add_alchemist.json file, located in data/piglinproliferation/data/forge/biome_modifier"}).defineInRange("Alchemist spawnrate weight in bastions", 4, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.zombifiedPiglinDefaultChance = builder.defineInRange("Chance of zombified piglins spawning with regular piglin clothing", (double)0.9f, 0.0, 9000.0);
            this.zombifiedBruteChance = builder.defineInRange("Chance of zombified piglins spawning with brute clothing (including items)", (double)0.015f, 0.0, 9000.0);
            this.zombifiedAlchemistChance = builder.defineInRange("Chance of zombified piglins spawning with alchemist clothing (including items", (double)0.1f, 0.0, 9000.0);
            this.piglinVariantChances = builder.defineInRange("Chance of zombified piglin variants spawning from the list below", 0.5, 0.0, 9000.0);
            this.zombifiedPiglinTypeList = builder.comment(new String[]{"List of variants a zombified piglin has a 50% of turning into when spawning.", "Keep in mind they will still spawn with golden swords, this will be changed in the future."}).defineList("List of piglin variants to use", (List)ImmutableList.of(), obj -> true);
            builder.pop();
            builder.push("Piglin Alchemist");
            this.alchemistPotionChance = builder.defineInRange("Chance of alchemist potions not getting broken when killed", (double)0.2f, 0.0, 9000.0);
            builder.push("Healing Arrow Chances");
            this.healingArrowChances = builder.defineInRange("Chances of an alchemist getting healing arrows", (double)0.3f, 0.0, 100.0);
            this.healingArrowMinStackSize = builder.defineInRange("Minmium healing arrow stack size", 1, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.healingArrowMaxStackSize = builder.defineInRange("Maximium healing arrow stack size", 6, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
            builder.push("buckler");
            this.BangBlockDestruction = builder.define("Have the explosion spawned while using the Bang! enchant destroy blocks?", false);
            this.BruteBuckler = builder.define("Have brutes spawn with bucklers?", true);
            this.BucklerCooldown = builder.defineInRange("How long should the buckler's cooldown be in ticks?", 240, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.BucklerRunTime = builder.defineInRange("How long should the buckler's charge move be in ticks?", 15, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.BucklerTurningRunTime = builder.defineInRange("How long should the buckler's charge move if you have the turning enchant be in ticks?", 30, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.bucklerChance = builder.defineInRange("Chance of buckler appearing in bastion loot", 0.25, 0.0, 9999999.0);
            builder.pop();
            builder.pop();
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue ziglinTextures;
        public final ForgeConfigSpec.BooleanValue RenderAfterImage;
        public final ForgeConfigSpec.BooleanValue RenderEntityLayersDuringAfterImage;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("vanilla changes");
            this.ziglinTextures = builder.define("Allow Zombified Piglins to render consistent clothing?", true);
            builder.pop();
            builder.push("after image");
            this.RenderAfterImage = builder.define("Render an after image while an entity is charging with a buckler?", true);
            this.RenderEntityLayersDuringAfterImage = builder.comment("Keep in mind this won't affect their opacity due to technical reasons.").define("Render entity layers while rendering the after image?", false);
            builder.pop();
        }
    }
}

