/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.items;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import tallestred.piglinproliferation.capablities.CriticalAfterCharge;
import tallestred.piglinproliferation.capablities.PPCapablities;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.client.renderers.BucklerRenderer;
import tallestred.piglinproliferation.common.enchantments.PPEnchantments;
import tallestred.piglinproliferation.configuration.PPConfig;

public class BucklerItem
extends ShieldItem {
    private static final UUID CHARGE_SPEED_UUID = UUID.fromString("A2F995E8-B25A-4883-B9D0-93A676DC4045");
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("93E74BB2-05A5-4AC0-8DF5-A55768208A95");
    private static final AttributeModifier CHARGE_SPEED_BOOST = new AttributeModifier(CHARGE_SPEED_UUID, "Charge speed boost", 9.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier KNOCKBACK_RESISTANCE = new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback reduction", 1.0, AttributeModifier.Operation.ADDITION);

    public BucklerItem(Item.Properties p_i48470_1_) {
        super(p_i48470_1_);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    public static void moveFowards(LivingEntity entity) {
        if (entity.m_6084_()) {
            Vec3 look = entity.m_20252_(1.0f);
            Vec3 motion = entity.m_20184_();
            if (entity instanceof Player) {
                entity.m_20334_(look.f_82479_ * entity.m_21133_(Attributes.f_22279_), motion.f_82480_, look.f_82481_ * entity.m_21133_(Attributes.f_22279_));
            } else {
                entity.m_20334_(look.f_82479_ * 1.0, motion.f_82480_, look.f_82481_ * 1.0);
            }
        }
    }

    public static boolean isReady(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt != null && compoundnbt.m_128471_("Ready");
    }

    public static int getChargeTicks(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        if (compoundnbt != null) {
            return compoundnbt.m_128451_("ChargeTicks");
        }
        return 0;
    }

    public static void setChargeTicks(ItemStack stack, int chargeTicks) {
        CompoundTag compoundnbt = stack.m_41784_();
        compoundnbt.m_128405_("ChargeTicks", chargeTicks);
    }

    public static void setReady(ItemStack stack, boolean ready) {
        CompoundTag compoundnbt = stack.m_41784_();
        compoundnbt.m_128379_("Ready", ready);
    }

    public static void bucklerBash(LivingEntity entity) {
        List list = entity.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), entity, entity.m_20191_().m_82400_(1.5));
        if (!list.isEmpty()) {
            LivingEntity entityHit = (LivingEntity)list.get(0);
            entityHit.m_7334_((Entity)entity);
            int bangLevel = PPEnchantments.getBucklerEnchantsOnHands((Enchantment)PPEnchantments.BANG.get(), entity);
            float damage = 6.0f + (float)entity.m_217043_().m_188503_(3);
            float knockbackStrength = 3.0f;
            for (int duration = 0; duration < 10; ++duration) {
                double d0 = entity.m_217043_().m_188583_() * 0.02;
                double d1 = entity.m_217043_().m_188583_() * 0.02;
                double d2 = entity.m_217043_().m_188583_() * 0.02;
                SimpleParticleType type = entityHit instanceof WitherBoss || entityHit instanceof WitherSkeleton ? ParticleTypes.f_123762_ : ParticleTypes.f_123796_;
                ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)type, entity.m_20208_(1.0), entity.m_20187_() + 1.0, entity.m_20262_(1.0), 1, d0, d1, d2, 1.0);
            }
            if (bangLevel == 0) {
                if (entityHit.m_6469_(entity.m_269291_().m_269333_(entity), damage)) {
                    entityHit.m_147240_((double)knockbackStrength, (double)Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180)))));
                    entity.m_20256_(entity.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                if (!entity.m_20067_()) {
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)PPSounds.SHIELD_BASH.get(), entity.m_5720_(), 0.5f, 0.8f + entity.m_217043_().m_188501_() * 0.4f);
                }
                if (entityHit instanceof Player && entityHit.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
                    ((Player)entityHit).m_36384_(true);
                }
            } else {
                InteractionHand hand = entity.m_21205_().m_41720_() instanceof BucklerItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                ItemStack stack = entity.m_21120_(hand);
                stack.m_41622_(5 * bangLevel, entity, player1 -> {
                    player1.m_21190_(hand);
                    if (entity instanceof Player) {
                        ForgeEventFactory.onPlayerDestroyItem((Player)((Player)entity), (ItemStack)entity.m_21211_(), (InteractionHand)hand);
                    }
                });
                Level.ExplosionInteraction mode = (Boolean)PPConfig.COMMON.BangBlockDestruction.get() != false ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE;
                entity.m_9236_().m_254849_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (float)bangLevel * 1.0f, mode);
                BucklerItem.setChargeTicks(stack, 0);
            }
            entity.m_21335_((Entity)entityHit);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (PPEnchantments.getBucklerEnchantsOnHands((Enchantment)PPEnchantments.BANG.get(), (LivingEntity)player) == 0) {
                    CriticalAfterCharge criticalAfterCharge = PPCapablities.getGuaranteedCritical((LivingEntity)player);
                    player.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)PPSounds.CRITICAL_ACTIVATE.get(), entity.m_5720_(), 1.0f, 1.0f);
                    criticalAfterCharge.setCritical(true);
                }
            }
        }
    }

    public static void spawnRunningEffectsWhileCharging(LivingEntity entity) {
        int i = Mth.m_14107_((double)entity.m_20185_());
        int j = Mth.m_14107_((double)(entity.m_20186_() - (double)0.2f));
        int k = Mth.m_14107_((double)entity.m_20189_());
        BlockPos blockpos = new BlockPos(i, j, k);
        BlockState blockstate = entity.m_9236_().m_8055_(blockpos);
        if (!blockstate.addRunningEffects(entity.m_9236_(), blockpos, (Entity)entity) && blockstate.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 vec3 = entity.m_20184_();
            entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_6972_((Pose)entity.m_20089_()).f_20378_, entity.m_20186_() + 0.1, entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_6972_((Pose)entity.m_20089_()).f_20377_, vec3.f_82479_ * -4.0, 1.5, vec3.f_82481_ * -4.0);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag tooltip) {
        list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.charge").m_130940_(ChatFormatting.BLUE));
        list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.while").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.forward").m_130940_(ChatFormatting.BLUE));
        list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.speed").m_130940_(ChatFormatting.BLUE));
        if (stack.getEnchantmentLevel((Enchantment)PPEnchantments.BANG.get()) == 0 && stack.getEnchantmentLevel((Enchantment)PPEnchantments.TURNING.get()) == 0) {
            list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.bash").m_130940_(ChatFormatting.BLUE));
        }
        if (stack.getEnchantmentLevel((Enchantment)PPEnchantments.BANG.get()) > 0) {
            list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.explosion").m_130940_(ChatFormatting.BLUE));
        }
        list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.knockback").m_130940_(ChatFormatting.BLUE));
        if (stack.getEnchantmentLevel((Enchantment)PPEnchantments.BANG.get()) == 0 && stack.getEnchantmentLevel((Enchantment)PPEnchantments.TURNING.get()) == 0) {
            list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.critical").m_130940_(ChatFormatting.BLUE));
            list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.critSwing").m_130940_(ChatFormatting.RED));
            list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.turnSpeed").m_130940_(ChatFormatting.RED));
        }
        list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.noJumping").m_130940_(ChatFormatting.RED));
        list.add((Component)Component.m_237115_((String)"item.piglinproliferation.buckler.desc.water").m_130940_(ChatFormatting.RED));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new BucklerRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
            }
        });
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        ItemStack itemstack = super.m_5922_(stack, worldIn, entityLiving);
        int turningLevel = PPEnchantments.getBucklerEnchantsOnHands((Enchantment)PPEnchantments.TURNING.get(), entityLiving);
        int configValue = turningLevel == 0 ? (Integer)PPConfig.COMMON.BucklerRunTime.get() : (Integer)PPConfig.COMMON.BucklerTurningRunTime.get();
        BucklerItem.setReady(stack, true);
        BucklerItem.setChargeTicks(stack, configValue);
        AttributeInstance speed = entityLiving.m_21051_(Attributes.f_22279_);
        AttributeInstance knockback = entityLiving.m_21051_(Attributes.f_22278_);
        knockback.m_22130_(KNOCKBACK_RESISTANCE);
        knockback.m_22118_(KNOCKBACK_RESISTANCE);
        speed.m_22130_(CHARGE_SPEED_BOOST);
        speed.m_22118_(CHARGE_SPEED_BOOST);
        stack.m_41622_(1, entityLiving, entityLiving1 -> entityLiving1.m_21166_(EquipmentSlot.OFFHAND));
        if (entityLiving instanceof Player) {
            ((Player)entityLiving).m_36335_().m_41524_((Item)this, ((Integer)PPConfig.COMMON.BucklerCooldown.get()).intValue());
        }
        entityLiving.m_5810_();
        if (entityLiving instanceof AbstractPiglin) {
            entityLiving.m_5496_((SoundEvent)PPSounds.PIGLIN_BRUTE_CHARGE.get(), 2.0f, entityLiving.m_6162_() ? (entityLiving.m_217043_().m_188501_() - entityLiving.m_217043_().m_188501_()) * 0.2f + 1.5f : (entityLiving.m_217043_().m_188501_() - entityLiving.m_217043_().m_188501_()) * 0.2f + 1.0f);
        }
        return itemstack;
    }

    public int m_8105_(ItemStack stack) {
        return 10;
    }

    public int m_6473_() {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        return !playerIn.m_20071_() ? super.m_7203_(worldIn, playerIn, handIn) : InteractionResultHolder.m_19098_((Object)playerIn.m_21120_(handIn));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(Tags.Items.INGOTS_GOLD);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
    }
}

