/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.goals;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.enchantment.Enchantment;
import tallestred.piglinproliferation.common.enchantments.PPEnchantments;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.configuration.PPConfig;

public class UseBucklerGoal<T extends PathfinderMob>
extends Goal {
    private final T owner;
    private int strafeTicks;
    private long nextOkStartTime;
    private ChargePhases chargePhase = ChargePhases.NONE;

    public UseBucklerGoal(T owner) {
        this.owner = owner;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.owner.m_9236_().m_46467_() - this.nextOkStartTime > (long)((Integer)PPConfig.COMMON.BucklerCooldown.get()).intValue() && this.owner.m_21206_().m_41720_() instanceof BucklerItem && this.owner.m_5448_() != null && this.owner.m_142582_((Entity)this.owner.m_5448_()) && (double)this.owner.m_5448_().m_20270_(this.owner) >= 4.0 && !this.owner.m_20071_();
    }

    public boolean m_8045_() {
        return this.owner.m_21206_().m_41720_() instanceof BucklerItem && this.owner.m_5448_() != null && this.owner.m_142582_((Entity)this.owner.m_5448_()) && !this.owner.m_20071_() && this.chargePhase != ChargePhases.FINISH;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.owner.m_5448_();
        if (livingEntity == null) {
            return;
        }
        if (BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(this.owner)) > 0 && PPEnchantments.getBucklerEnchantsOnHands((Enchantment)PPEnchantments.TURNING.get(), this.owner) > 0 || BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(this.owner)) <= 0) {
            this.owner.m_21391_((Entity)livingEntity, 30.0f, 30.0f);
        }
        if ((double)this.owner.m_20270_((Entity)livingEntity) >= 10.0) {
            this.owner.m_21573_().m_5624_((Entity)livingEntity, 1.0);
        } else {
            this.owner.m_21573_().m_26573_();
        }
        if (this.chargePhase == ChargePhases.STRAFE && this.strafeTicks > 0 && (double)this.owner.m_20270_((Entity)livingEntity) >= 4.0 && (double)this.owner.m_20270_((Entity)livingEntity) <= 10.0) {
            this.owner.m_21566_().m_24988_(-2.0f, 0.0f);
            --this.strafeTicks;
            if (this.strafeTicks == 0) {
                this.chargePhase = ChargePhases.CHARGE;
            }
        } else if (this.chargePhase == ChargePhases.CHARGE) {
            if (!this.owner.m_6117_()) {
                this.owner.m_6672_(InteractionHand.OFF_HAND);
                this.chargePhase = ChargePhases.CHARGING;
            }
        } else if (this.chargePhase == ChargePhases.CHARGING && this.owner.m_21252_() >= this.owner.m_21211_().m_41779_()) {
            this.chargePhase = ChargePhases.FINISH;
        }
    }

    public void m_8056_() {
        this.owner.m_21561_(true);
        this.chargePhase = ChargePhases.STRAFE;
        this.strafeTicks = 20;
    }

    public void m_8041_() {
        this.owner.m_5810_();
        this.owner.m_21561_(false);
        this.owner.m_6710_(null);
        this.nextOkStartTime = this.owner.m_9236_().m_46467_();
    }

    public static enum ChargePhases {
        NONE,
        STRAFE,
        CHARGE,
        CHARGING,
        FINISH;

    }
}

