/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.common.entities.ai.behaviors.BowAttack;

public class ShootTippedArrow
extends BowAttack<PiglinAlchemist, LivingEntity> {
    protected final Predicate<? super AbstractPiglin> nearbyPiglinPredicate;
    private final ItemStack itemToUse;
    private AbstractPiglin piglinToTarget;

    public ShootTippedArrow(double speedModifier, float attackRadius, int attackIntervalMin, ItemStack item, Predicate<? super AbstractPiglin> nearbyPiglinPredicate) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26347_, (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()), (Object)MemoryStatus.VALUE_ABSENT), speedModifier, attackRadius, attackIntervalMin);
        this.nearbyPiglinPredicate = nearbyPiglinPredicate;
        this.itemToUse = item;
    }

    @Override
    protected LivingEntity getTargetToShootAt(PiglinAlchemist alchemist) {
        List list = (List)alchemist.m_6274_().m_21952_(MemoryModuleType.f_26347_).orElse(ImmutableList.of());
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AbstractPiglin piglin;
                this.piglinToTarget = piglin = (AbstractPiglin)iterator.next();
                for (MobEffectInstance mobeffectinstance : PotionUtils.m_43547_((ItemStack)this.itemToUse)) {
                    List<ItemStack> filteredList = alchemist.beltInventory.stream().filter(itemStack -> itemStack.m_150930_(this.itemToUse.m_41720_())).toList();
                    for (ItemStack item : filteredList) {
                        if (PotionUtils.m_43579_((ItemStack)item) != PotionUtils.m_43579_((ItemStack)this.itemToUse)) continue;
                        boolean hasArrow = alchemist.getItemShownOnOffhand().m_150930_(this.itemToUse.m_41720_()) || alchemist.beltInventory.stream().filter(itemStack -> itemStack.m_150930_(this.itemToUse.m_41720_())).toList() != null;
                        return hasArrow && this.nearbyPiglinPredicate.test((AbstractPiglin)this.piglinToTarget) && !this.piglinToTarget.m_21023_(mobeffectinstance.m_19544_()) ? this.piglinToTarget : null;
                    }
                }
            }
        }
        return null;
    }

    protected void start(ServerLevel level, PiglinAlchemist alchemist, long gameTime) {
        alchemist.m_6274_().m_21879_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get(), (Object)this.piglinToTarget);
        alchemist.m_6274_().m_21889_((Activity)PPActivities.THROW_POTION_ACTIVITY.get());
    }

    @Override
    protected void stop(ServerLevel level, PiglinAlchemist alchemist, long gameTime) {
        super.stop(level, alchemist, gameTime);
        if (alchemist.getItemShownOnOffhand().m_41720_() instanceof ArrowItem) {
            for (int slot = 0; slot < alchemist.beltInventory.size(); ++slot) {
                ItemStack stackInSlot = (ItemStack)alchemist.beltInventory.get(slot);
                if (!stackInSlot.m_41619_()) continue;
                alchemist.beltInventory.set(slot, (Object)alchemist.getItemShownOnOffhand().m_41777_());
                alchemist.setItemShownOnOffhand(ItemStack.f_41583_);
            }
        }
        alchemist.m_6274_().m_21936_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
    }
}

