/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;

public class BaseThrowPotion<E extends PiglinAlchemist>
extends Behavior<E> {
    protected final ItemStack itemToUse;
    protected final Predicate<PiglinAlchemist> canUseSelector;
    protected ItemStack potionToThrow;
    protected int ticksUntilThrow;
    protected int panicTicks;

    public BaseThrowPotion(ItemStack stack, Predicate<PiglinAlchemist> pCanUseSelector) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.REGISTERED));
        this.itemToUse = stack;
        this.canUseSelector = pCanUseSelector;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E alchemist) {
        for (int slot = 0; slot < ((PiglinAlchemist)((Object)alchemist)).beltInventory.size(); ++slot) {
            ItemStack stackInSlot = (ItemStack)((PiglinAlchemist)((Object)alchemist)).beltInventory.get(slot);
            if (!stackInSlot.m_150930_(this.itemToUse.m_41720_()) || PotionUtils.m_43579_((ItemStack)this.itemToUse) != PotionUtils.m_43579_((ItemStack)stackInSlot)) continue;
            this.potionToThrow = stackInSlot;
            return this.canUseSelector.test((PiglinAlchemist)((Object)alchemist));
        }
        return false;
    }

    protected void start(ServerLevel level, E alchemist, long gameTime) {
        for (int slot = 0; slot < ((PiglinAlchemist)((Object)alchemist)).beltInventory.size(); ++slot) {
            ItemStack stackInSlot = (ItemStack)((PiglinAlchemist)((Object)alchemist)).beltInventory.get(slot);
            if (((PiglinAlchemist)((Object)alchemist)).isGonnaThrowPotion() || !stackInSlot.m_150930_(this.itemToUse.m_41720_()) || PotionUtils.m_43579_((ItemStack)this.itemToUse) != PotionUtils.m_43579_((ItemStack)stackInSlot) || !this.canUseSelector.test((PiglinAlchemist)((Object)alchemist))) continue;
            this.potionToThrow = stackInSlot;
            ((PiglinAlchemist)((Object)alchemist)).setBeltInventorySlot(slot, ItemStack.f_41583_);
            alchemist.m_6674_(InteractionHand.OFF_HAND);
            ((PiglinAlchemist)((Object)alchemist)).setItemShownOnOffhand(stackInSlot.m_41777_());
            PotionUtils.m_43549_((ItemStack)((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand(), (Potion)PotionUtils.m_43579_((ItemStack)stackInSlot));
            ((PiglinAlchemist)((Object)alchemist)).willThrowPotion(true);
        }
    }

    protected void throwPotion(E alchemist) {
        if (!((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand().m_41619_()) {
            alchemist.m_6674_(InteractionHand.OFF_HAND);
            ((PiglinAlchemist)((Object)alchemist)).throwPotion(((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand(), alchemist.m_146909_(), alchemist.m_146908_());
        }
    }

    protected void stop(ServerLevel level, E alchemist, long gameTime) {
        if (((PiglinAlchemist)((Object)alchemist)).isGonnaThrowPotion() && ((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand() != null) {
            ((PiglinAlchemist)((Object)alchemist)).willThrowPotion(false);
            for (int slot = 0; slot < ((PiglinAlchemist)((Object)alchemist)).beltInventory.size(); ++slot) {
                ItemStack stackInSlot = (ItemStack)((PiglinAlchemist)((Object)alchemist)).beltInventory.get(slot);
                if (!stackInSlot.m_41619_()) continue;
                ((PiglinAlchemist)((Object)alchemist)).beltInventory.set(slot, (Object)((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand().m_41777_());
                ((PiglinAlchemist)((Object)alchemist)).setItemShownOnOffhand(ItemStack.f_41583_);
            }
        }
    }
}

