/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.entities.ai.PiglinAlchemistAi;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.configuration.PPConfig;
import tallestred.piglinproliferation.networking.AlchemistBeltSyncPacket;
import tallestred.piglinproliferation.networking.PPNetworking;

public class PiglinAlchemist
extends Piglin {
    protected static final EntityDataAccessor<Boolean> IS_ABOUT_TO_THROW_POTION = SynchedEntityData.m_135353_(PiglinAlchemist.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<ItemStack> ITEM_SHOWN_ON_OFFHAND = SynchedEntityData.m_135353_(PiglinAlchemist.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public final NonNullList<ItemStack> beltInventory = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    protected int arrowsShot;

    public PiglinAlchemist(EntityType<? extends PiglinAlchemist> type, Level level) {
        super(type, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Piglin.m_34770_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    public static boolean checkChemistSpawnRules(EntityType<PiglinAlchemist> p_219198_, LevelAccessor p_219199_, MobSpawnType p_219200_, BlockPos p_219201_, RandomSource p_219202_) {
        return !p_219199_.m_8055_(p_219201_.m_7495_()).m_60713_(Blocks.f_50451_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)PPSounds.ALCHEMIST_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)PPSounds.ALCHEMIST_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PPSounds.ALCHEMIST_DEATH.get();
    }

    protected void m_213945_(RandomSource source, DifficultyInstance pDifficulty) {
        super.m_213945_(source, pDifficulty);
        if (this.m_34667_()) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
            if (source.m_188501_() < ((Double)PPConfig.COMMON.healingArrowChances.get()).floatValue()) {
                ItemStack tippedArrow = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_, source.m_216339_(((Integer)PPConfig.COMMON.healingArrowMinStackSize.get()).intValue(), ((Integer)PPConfig.COMMON.healingArrowMaxStackSize.get()).intValue())), (Potion)Potions.f_43581_);
                this.setBeltInventorySlot(source.m_188503_(6), tippedArrow);
            }
            for (int slot = 0; slot < this.beltInventory.size(); ++slot) {
                if (!((ItemStack)this.beltInventory.get(slot)).m_41619_()) continue;
                Potion effect = source.m_188501_() < 0.35f ? Potions.f_43610_ : (source.m_188501_() < 0.3f ? Potions.f_43589_ : (source.m_188501_() < 0.25f ? Potions.f_43581_ : Potions.f_43592_));
                ItemStack potion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)effect);
                this.setBeltInventorySlot(slot, potion);
            }
        }
    }

    protected void m_7355_(BlockPos p_32159_, BlockState p_32160_) {
        if (this.m_217043_().m_188503_(20) == 0 && this.beltInventory.stream().filter(itemStack -> itemStack.m_41720_() instanceof PotionItem).findAny().isPresent()) {
            this.m_5496_((SoundEvent)PPSounds.ALCHEMIST_WALK.get(), 0.5f * ((float)this.beltInventory.stream().filter(itemStack -> itemStack.m_41720_() instanceof PotionItem).count() * 0.5f), 1.0f);
        }
        this.m_5496_((SoundEvent)PPSounds.ALCHEMIST_STEP.get(), 0.15f, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ABOUT_TO_THROW_POTION, (Object)false);
        this.f_19804_.m_135372_(ITEM_SHOWN_ON_OFFHAND, (Object)ItemStack.f_41583_);
    }

    protected void m_142540_(MobEffectInstance mobEffect, @Nullable Entity entity) {
        if (mobEffect.m_19544_() == MobEffects.f_19607_) {
            this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
            this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
            this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        }
        super.m_142540_(mobEffect, entity);
    }

    protected void m_7285_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19607_) {
            this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
            this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
            this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        }
        super.m_7285_(mobEffectInstance);
    }

    public boolean isGonnaThrowPotion() {
        return (Boolean)this.f_19804_.m_135370_(IS_ABOUT_TO_THROW_POTION);
    }

    protected void m_8024_() {
        this.f_34649_ = this.m_34666_() ? ++this.f_34649_ : 0;
        if (this.f_34649_ > 300 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20531_, timer -> {
            this.f_34649_ = timer;
        })) {
            this.m_7580_();
            this.m_8063_((ServerLevel)this.m_9236_());
        }
        this.m_9236_().m_46473_().m_6180_("piglinBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        PiglinAlchemistAi.updateActivity(this);
    }

    protected void m_7580_() {
        this.m_5496_((SoundEvent)PPSounds.ALCHEMIST_CONVERTED.get(), this.m_6121_(), this.m_6100_() / 0.1f);
    }

    public void m_219195_(SoundEvent sound) {
        this.m_5496_(sound, this.m_6121_(), this.m_6100_());
    }

    public boolean m_7121_() {
        return super.m_7121_();
    }

    public void willThrowPotion(boolean throwPotion) {
        this.f_19804_.m_135381_(IS_ABOUT_TO_THROW_POTION, (Object)throwPotion);
    }

    public ItemStack getItemShownOnOffhand() {
        return (ItemStack)this.f_19804_.m_135370_(ITEM_SHOWN_ON_OFFHAND);
    }

    public void setItemShownOnOffhand(ItemStack itemShownOnOffhand) {
        this.f_19804_.m_135381_(ITEM_SHOWN_ON_OFFHAND, (Object)itemShownOnOffhand);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        Fireball fireball;
        Entity entity;
        Creeper creeper;
        for (ItemStack itemStack : this.beltInventory) {
            if (itemStack.m_41619_()) continue;
            if (!EnchantmentHelper.m_44924_((ItemStack)itemStack) && (double)this.m_217043_().m_188501_() < (Double)PPConfig.COMMON.alchemistPotionChance.get()) {
                this.m_19983_(itemStack);
                continue;
            }
            if (!(itemStack.m_41720_() instanceof PotionItem)) continue;
            for (int i = 0; i < 5; ++i) {
                BlockPos blockpos = this.m_20183_();
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), (double)blockpos.m_123341_() + this.m_9236_().f_46441_.m_188500_(), (double)(blockpos.m_123342_() + 1), (double)blockpos.m_123343_() + this.m_9236_().f_46441_.m_188500_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            this.m_5496_(SoundEvents.f_12436_, 0.5f, 1.0f);
        }
        Entity entity2 = pSource.m_7639_();
        if (entity2 instanceof Creeper && (creeper = (Creeper)entity2).m_32313_()) {
            creeper.m_32314_();
            this.m_19998_((ItemLike)PPItems.PIGLIN_ALCHEMIST_HEAD_ITEM.get());
        }
        if ((entity = pSource.m_7640_()) instanceof Fireball && (fireball = (Fireball)entity).m_19749_() instanceof Ghast) {
            this.m_19998_((ItemLike)PPItems.PIGLIN_ALCHEMIST_HEAD_ITEM.get());
        }
        this.beltInventory.clear();
        super.m_7472_(pSource, pLooting, pRecentlyHit);
    }

    public void throwPotion(ItemStack thrownPotion, float xRot, float yRot) {
        ThrownPotion thrownpotion = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
        thrownpotion.m_37446_(thrownPotion);
        thrownpotion.m_37251_((Entity)this, xRot, yRot, -20.0f, 0.5f, 1.0f);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12437_, this.m_5720_(), 1.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
        }
        this.m_9236_().m_7967_((Entity)thrownpotion);
        this.willThrowPotion(false);
        thrownPotion.m_41774_(1);
    }

    protected Brain.Provider<PiglinAlchemist> alchemistBrainProvider() {
        ArrayList<MemoryModuleType> ALCHEMIST_MEMORY_TYPES = new ArrayList<MemoryModuleType>((Collection<MemoryModuleType>)Piglin.f_34672_);
        ALCHEMIST_MEMORY_TYPES.add((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
        return Brain.m_21923_((Collection)ImmutableList.copyOf(ALCHEMIST_MEMORY_TYPES), (Collection)f_34680_);
    }

    protected Brain<?> m_8075_(Dynamic<?> p_34723_) {
        return PiglinAlchemistAi.makeBrain(this, (Brain<PiglinAlchemist>)this.alchemistBrainProvider().m_22073_(p_34723_));
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.m_21205_().m_41720_() instanceof CrossbowItem) {
            super.m_6504_(target, distanceFactor);
        }
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            int punchLevel;
            ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
            for (int slot = 0; slot < this.beltInventory.size() && !(this.getItemShownOnOffhand().m_41720_() instanceof TippedArrowItem); ++slot) {
                if (!(((ItemStack)this.beltInventory.get(slot)).m_41720_() instanceof TippedArrowItem)) continue;
                List effectInstanceList = PotionUtils.m_43579_((ItemStack)((ItemStack)this.beltInventory.get(slot))).m_43488_();
                if ((this.m_5448_() == null || target != this.m_5448_() || !effectInstanceList.stream().filter(mobEffectInstance -> !mobEffectInstance.m_19544_().m_19486_()).findAny().isPresent()) && target == this.m_5448_() && (this.m_5448_() == null || !this.m_5448_().m_21222_() || !effectInstanceList.stream().filter(mobEffectInstance -> mobEffectInstance.m_19544_() == MobEffects.f_19601_).findAny().isPresent())) continue;
                this.setItemShownOnOffhand(((ItemStack)this.beltInventory.get(slot)).m_41777_());
                this.beltInventory.set(slot, (Object)ItemStack.f_41583_);
            }
            if (this.getItemShownOnOffhand().m_41720_() instanceof TippedArrowItem) {
                itemstack = this.getItemShownOnOffhand();
            }
            AbstractArrow abstractarrowentity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
            int powerLevel = itemstack.getEnchantmentLevel(Enchantments.f_44988_);
            if (powerLevel > 0) {
                abstractarrowentity.m_36781_(abstractarrowentity.m_36789_() + (double)powerLevel * 0.5 + 0.5);
            }
            if ((punchLevel = itemstack.getEnchantmentLevel(Enchantments.f_44989_)) > 0) {
                abstractarrowentity.m_36735_(punchLevel);
            }
            if (itemstack.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
                abstractarrowentity.m_20254_(100);
            }
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_9236_().m_7967_((Entity)abstractarrowentity);
            this.setArrowsShot(this.getArrowsShot() + 1);
            itemstack.m_41774_(1);
            if (itemstack.m_41619_() && this.getItemShownOnOffhand().m_150930_(itemstack.m_41720_())) {
                this.setItemShownOnOffhand(ItemStack.f_41583_);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ListTag listnbt = new ListTag();
        for (ItemStack itemstack : this.beltInventory) {
            CompoundTag compoundtag = new CompoundTag();
            if (!itemstack.m_41619_()) {
                itemstack.m_41739_(compoundtag);
            }
            listnbt.add((Object)compoundtag);
        }
        compound.m_128365_("BeltInventory", (Tag)listnbt);
        compound.m_128405_("ArrowsShot", this.getArrowsShot());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("BeltInventory", 9)) {
            ListTag listtag = compound.m_128437_("BeltInventory", 10);
            for (int i = 0; i < this.beltInventory.size(); ++i) {
                this.beltInventory.set(i, (Object)ItemStack.m_41712_((CompoundTag)listtag.m_128728_(i)));
            }
        }
        this.setArrowsShot(compound.m_128451_("ArrowsShot"));
    }

    public int getArrowsShot() {
        return this.arrowsShot;
    }

    public void setArrowsShot(int arrowsShot) {
        this.arrowsShot = arrowsShot;
    }

    public void m_8119_() {
        super.m_8119_();
        this.syncBeltToClient();
    }

    public void setBeltInventorySlot(int index, ItemStack stack) {
        this.beltInventory.set(index, (Object)stack);
        this.syncBeltToClient();
    }

    public void syncBeltToClient() {
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < this.beltInventory.size(); ++i) {
                PPNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new AlchemistBeltSyncPacket(this.m_19879_(), i, (ItemStack)this.beltInventory.get(i)));
            }
        }
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item instanceof BowItem || super.m_5886_(item);
    }
}

