/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.client;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import tallestred.piglinproliferation.client.models.ModelGoldenBuckler;
import tallestred.piglinproliferation.client.models.PiglinAlchemistModel;
import tallestred.piglinproliferation.client.models.PiglinHeadEntityModel;
import tallestred.piglinproliferation.client.models.PiglinTravellerModel;
import tallestred.piglinproliferation.client.renderers.PiglinAlchemistRenderer;
import tallestred.piglinproliferation.client.renderers.PiglinTravellerRenderer;
import tallestred.piglinproliferation.client.renderers.layers.PiglinClothingRenderLayer;
import tallestred.piglinproliferation.common.blockentities.PPBlockEntities;
import tallestred.piglinproliferation.common.blocks.PiglinSkullBlock;
import tallestred.piglinproliferation.common.entities.PPEntityTypes;

@Mod.EventBusSubscriber(modid="piglinproliferation", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class PPClientEvents {
    public static final ModelLayerLocation ZIGLIN_CLOTHING = new ModelLayerLocation(new ResourceLocation("piglinproliferationziglin_clothing"), "ziglin_clothing");
    public static final ModelLayerLocation PIGLIN_SKULL = new ModelLayerLocation(new ResourceLocation("piglinproliferationpiglin_skull"), "piglin_skull");
    public static final ModelLayerLocation PIGLIN_ALCHEMIST_SKULL = new ModelLayerLocation(new ResourceLocation("piglinproliferationpiglin_alchemist_skull"), "piglin_alchemist_skull");
    public static final ModelLayerLocation PIGLIN_ALCHEMIST = new ModelLayerLocation(new ResourceLocation("piglinproliferationpiglin_alchemist"), "piglin_alchemist");
    public static final ModelLayerLocation PIGLIN_TRAVELLER = new ModelLayerLocation(new ResourceLocation("piglinproliferationpiglin_traveller"), "piglin_traveller");
    public static final ModelLayerLocation PIGLIN_ALCHEMIST_BELT_SLOTS = new ModelLayerLocation(new ResourceLocation("piglinproliferationpiglin_alchemist_belt"), "piglin_alchemist_belt");
    public static final ModelLayerLocation BUCKLER = new ModelLayerLocation(new ResourceLocation("piglinproliferationbuckler"), "buckler");
    public static final Material BUCKLER_TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("piglinproliferation", "entity/buckler/golden_buckler"));

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PIGLIN_SKULL, (Supplier)Lazy.of(PiglinHeadEntityModel::createMesh));
        event.registerLayerDefinition(PIGLIN_ALCHEMIST_SKULL, (Supplier)Lazy.of(PiglinHeadEntityModel::createAlchemistMesh));
        event.registerLayerDefinition(ZIGLIN_CLOTHING, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinModel.m_170811_((CubeDeformation)new CubeDeformation(0.25f)), (int)64, (int)64));
        event.registerLayerDefinition(PIGLIN_ALCHEMIST, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinAlchemistModel.createBodyLayer(new CubeDeformation(0.25f), new CubeDeformation(0.7f), new CubeDeformation(1.05f)), (int)120, (int)64));
        event.registerLayerDefinition(PIGLIN_TRAVELLER, PiglinTravellerModel::createBodyLayer);
        event.registerLayerDefinition(PIGLIN_ALCHEMIST_BELT_SLOTS, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinAlchemistModel.createBodyLayer(new CubeDeformation(0.4f), new CubeDeformation(1.0f), new CubeDeformation(1.2f)), (int)120, (int)64));
        event.registerLayerDefinition(BUCKLER, ModelGoldenBuckler::createLayer);
    }

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)PPBlockEntities.PIGLIN_SKULL.get(), SkullBlockRenderer::new);
        event.registerEntityRenderer((EntityType)PPEntityTypes.PIGLIN_ALCHEMIST.get(), PiglinAlchemistRenderer::new);
        event.registerEntityRenderer((EntityType)PPEntityTypes.PIGLIN_TRAVELLER.get(), PiglinTravellerRenderer::new);
    }

    @SubscribeEvent
    public static void layer(EntityRenderersEvent.AddLayers event) {
        PPClientEvents.addLayerToRenderer(event, EntityType.f_20531_, PiglinClothingRenderLayer::new);
    }

    @SubscribeEvent
    public static void berRenderers(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel((SkullBlock.Type)PiglinSkullBlock.Types.PIGLIN, (SkullModelBase)new PiglinHeadEntityModel(event.getEntityModelSet().m_171103_(PIGLIN_SKULL)));
        event.registerSkullModel((SkullBlock.Type)PiglinSkullBlock.Types.PIGLIN_BRUTE, (SkullModelBase)new PiglinHeadEntityModel(event.getEntityModelSet().m_171103_(PIGLIN_SKULL)));
        event.registerSkullModel((SkullBlock.Type)PiglinSkullBlock.Types.ZOMBIFIED_PIGLIN, (SkullModelBase)new PiglinHeadEntityModel(event.getEntityModelSet().m_171103_(PIGLIN_SKULL)));
        event.registerSkullModel((SkullBlock.Type)PiglinSkullBlock.Types.PIGLIN_ALCHEMIST, (SkullModelBase)new PiglinHeadEntityModel(event.getEntityModelSet().m_171103_(PIGLIN_ALCHEMIST_SKULL)));
    }

    @SubscribeEvent
    public static void clientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> SkullBlockRenderer.f_112519_.put(PiglinSkullBlock.Types.PIGLIN, new ResourceLocation("textures/entity/piglin/piglin.png")));
        event.enqueueWork(() -> SkullBlockRenderer.f_112519_.put(PiglinSkullBlock.Types.PIGLIN_BRUTE, new ResourceLocation("textures/entity/piglin/piglin_brute.png")));
        event.enqueueWork(() -> SkullBlockRenderer.f_112519_.put(PiglinSkullBlock.Types.ZOMBIFIED_PIGLIN, new ResourceLocation("textures/entity/piglin/zombified_piglin.png")));
        event.enqueueWork(() -> SkullBlockRenderer.f_112519_.put(PiglinSkullBlock.Types.PIGLIN_ALCHEMIST, new ResourceLocation("piglinproliferation", "textures/entity/piglin/alchemist/alchemist.png")));
    }

    private static <T extends Mob, R extends LivingEntityRenderer<T, M>, M extends PiglinModel<T>> void addLayerToRenderer(EntityRenderersEvent.AddLayers event, EntityType<T> entityType, Function<R, ? extends RenderLayer<T, M>> factory) {
        LivingEntityRenderer renderer = event.getRenderer(entityType);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }
}

