/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import tallestred.piglinproliferation.capablities.CriticalAfterCharge;
import tallestred.piglinproliferation.capablities.GuranteedCritProvider;
import tallestred.piglinproliferation.capablities.PPCapablities;
import tallestred.piglinproliferation.capablities.TransformationSourceListener;
import tallestred.piglinproliferation.capablities.TransformationSourceProvider;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.blocks.PPBlocks;
import tallestred.piglinproliferation.common.enchantments.PPEnchantments;
import tallestred.piglinproliferation.common.entities.ai.goals.PiglinCallForHelpGoal;
import tallestred.piglinproliferation.common.entities.ai.goals.PiglinSwimInLavaGoal;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.configuration.PPConfig;
import tallestred.piglinproliferation.networking.CriticalCapabilityPacket;
import tallestred.piglinproliferation.networking.PPNetworking;
import tallestred.piglinproliferation.networking.ZiglinCapablitySyncPacket;

@Mod.EventBusSubscriber(modid="piglinproliferation")
public class PPEvents {
    private static final UUID CHARGE_SPEED_UUID = UUID.fromString("A2F995E8-B25A-4883-B9D0-93A676DC4045");
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("93E74BB2-05A5-4AC0-8DF5-A55768208A95");
    private static final AttributeModifier CHARGE_SPEED_BOOST = new AttributeModifier(CHARGE_SPEED_UUID, "Charge speed boost", 9.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier KNOCKBACK_RESISTANCE = new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback reduction", 1.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        GuranteedCritProvider critProvider = new GuranteedCritProvider();
        TransformationSourceProvider provider = new TransformationSourceProvider();
        if (event.getObject() instanceof ZombifiedPiglin) {
            event.addCapability(TransformationSourceProvider.IDENTIFIER, (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(GuranteedCritProvider.IDENTIFIER, (ICapabilityProvider)critProvider);
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(event.getEntity())) > 0) {
            event.getEntity().m_20334_(event.getEntity().m_20184_().m_7096_(), 0.0, event.getEntity().m_20184_().m_7094_());
        }
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ZombifiedPiglin) {
            TransformationSourceListener transformationSource;
            ZombifiedPiglin ziglin = (ZombifiedPiglin)entity;
            if (!event.getEntity().m_9236_().f_46443_ && (transformationSource = PPEvents.getTransformationSourceListener((LivingEntity)ziglin)) != null) {
                PPNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ziglin), (Object)new ZiglinCapablitySyncPacket(ziglin.m_19879_(), transformationSource.getTransformationSource()));
            }
        }
        if ((entity = event.getEntity()) instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)entity;
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_6060_() && !piglin1.m_21023_(MobEffects.f_19607_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43610_));
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_21223_() < piglin1.m_21233_() && !piglin1.m_21023_(MobEffects.f_19605_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43589_));
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_21223_() < piglin1.m_21233_() && !piglin1.m_21023_(MobEffects.f_19601_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43581_));
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_21223_() < piglin1.m_21233_() / 2.0f && piglin1.m_5448_() != null && !piglin1.m_21023_(MobEffects.f_19600_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43592_));
            piglin.f_21345_.m_25352_(1, (Goal)new PiglinSwimInLavaGoal((Mob)piglin));
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ZombifiedPiglin) {
            TransformationSourceListener transformationSource;
            ZombifiedPiglin ziglin = (ZombifiedPiglin)entity;
            if (!event.getTarget().m_9236_().f_46443_ && (transformationSource = PPEvents.getTransformationSourceListener((LivingEntity)ziglin)) != null) {
                PPNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ziglin), (Object)new ZiglinCapablitySyncPacket(ziglin.m_19879_(), transformationSource.getTransformationSource()));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        CriticalAfterCharge criticalAfterCharge;
        LivingEntity entity = event.getEntity();
        int turningLevel = PPEnchantments.getBucklerEnchantsOnHands((Enchantment)PPEnchantments.TURNING.get(), entity);
        ItemStack bucklerItemStack = PPItems.checkEachHandForBuckler(entity);
        boolean bucklerReadyToCharge = BucklerItem.isReady(bucklerItemStack);
        int bucklerChargeTicks = BucklerItem.getChargeTicks(bucklerItemStack);
        if (bucklerReadyToCharge) {
            BucklerItem.setChargeTicks(bucklerItemStack, bucklerChargeTicks - 1);
            if (bucklerChargeTicks > 0) {
                BucklerItem.moveFowards(entity);
                BucklerItem.spawnRunningEffectsWhileCharging(entity);
                if (turningLevel == 0 && !entity.m_9236_().m_5776_()) {
                    BucklerItem.bucklerBash(entity);
                }
            }
            if (bucklerChargeTicks <= 0) {
                AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
                AttributeInstance knockback = entity.m_21051_(Attributes.f_22278_);
                if (speed == null || knockback == null) {
                    return;
                }
                knockback.m_22130_(KNOCKBACK_RESISTANCE);
                speed.m_22130_(CHARGE_SPEED_BOOST);
                entity.m_5810_();
                BucklerItem.setChargeTicks(bucklerItemStack, 0);
                BucklerItem.setReady(bucklerItemStack, false);
            }
        }
        if ((criticalAfterCharge = PPCapablities.getGuaranteedCritical(entity)) != null) {
            LivingEntity livingEntity;
            if (criticalAfterCharge.isCritical()) {
                if (entity.f_20913_ > 0) {
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)PPSounds.CRITICAL_DEACTIVATE.get(), entity.m_5720_(), 1.0f, 0.8f + entity.m_217043_().m_188501_() * 0.4f);
                    criticalAfterCharge.setCritical(false);
                }
                for (int i = 0; i < 2; ++i) {
                    entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
            }
            if ((livingEntity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                PPNetworking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CriticalCapabilityPacket(player.m_19879_(), criticalAfterCharge.isCritical()));
            }
        }
    }

    @SubscribeEvent
    public static void onEffectApplied(MobEffectEvent.Added event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (mobEffect == MobEffects.f_19607_) {
                piglin.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
                piglin.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
                piglin.m_21441_(BlockPathTypes.LAVA, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (mobEffect == MobEffects.f_19607_) {
                piglin.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
                piglin.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
                piglin.m_21441_(BlockPathTypes.LAVA, -1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void hurtEntity(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            if (((Boolean)PPConfig.COMMON.healingArrowDamage.get()).booleanValue()) {
                for (MobEffectInstance mobeffectinstance : arrow.f_36855_.m_43488_()) {
                    if (mobeffectinstance.m_19544_() != MobEffects.f_19605_ && mobeffectinstance.m_19544_() != MobEffects.f_19601_) continue;
                    if (event.getEntity() instanceof Mob && event.getEntity().m_21222_()) {
                        return;
                    }
                    event.setAmount(0.0f);
                    arrow.m_9236_().m_5594_(null, arrow.m_20183_(), (SoundEvent)PPSounds.REGEN_HEALING_ARROW_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    event.getEntity().m_20256_(event.getEntity().m_20184_().m_82542_(-1.0, -1.0, -1.0));
                    event.getEntity().f_19802_ = 0;
                    event.getEntity().f_20916_ = 0;
                }
            }
        }
    }

    @SubscribeEvent
    public static void attackEntity(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            for (Entity rider : mob.m_20197_()) {
                if (!mob.m_21222_() || !(event.getSource().m_7639_() instanceof AbstractPiglin) || !(rider instanceof AbstractPiglin)) continue;
                AbstractPiglin piglin = (AbstractPiglin)rider;
                if (!event.getSource().m_276093_(DamageTypes.f_268515_)) continue;
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                piglin.m_6274_().m_21936_(MemoryModuleType.f_26334_);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void targetMob(LivingChangeTargetEvent event) {
        if (event.getEntity() instanceof AbstractPiglin && event.getOriginalTarget() instanceof AbstractPiglin) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        Player player = event.getEntity();
        CriticalAfterCharge criticalAfterCharge = PPCapablities.getGuaranteedCritical((LivingEntity)player);
        if (criticalAfterCharge.isCritical()) {
            event.setResult(Event.Result.ALLOW);
            event.setDamageModifier(1.5f);
            event.getEntity().m_9236_().m_6263_(null, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), SoundEvents.f_12313_, event.getEntity().m_5720_(), 1.0f, 1.0f);
            criticalAfterCharge.setCritical(false);
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        if (event.getEntity().m_21211_().m_41720_() instanceof BucklerItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void finalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        MobSpawnType spawnType = event.getSpawnType();
        RandomSource rSource = event.getLevel().m_213780_();
        Mob mob = event.getEntity();
        if (mob instanceof PiglinBrute) {
            PiglinBrute piglinBrute = (PiglinBrute)mob;
            if (!((Boolean)PPConfig.COMMON.BruteBuckler.get()).booleanValue()) {
                return;
            }
            piglinBrute.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)PPItems.BUCKLER.get()));
            ItemStack itemstack = piglinBrute.m_21206_();
            if (itemstack.m_41720_() instanceof BucklerItem) {
                Map map;
                if (rSource.m_188503_(300) == 0) {
                    map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
                    map.putIfAbsent((Enchantment)PPEnchantments.TURNING.get(), 1);
                    EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
                    piglinBrute.m_8061_(EquipmentSlot.OFFHAND, itemstack);
                }
                if (rSource.m_188503_(500) == 0) {
                    map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
                    map.putIfAbsent((Enchantment)PPEnchantments.BANG.get(), 1);
                    EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
                    piglinBrute.m_8061_(EquipmentSlot.OFFHAND, itemstack);
                }
            }
        }
        if (event.getEntity().m_6095_() == EntityType.f_20531_) {
            ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)event.getEntity();
            TransformationSourceListener tSource = PPEvents.getTransformationSourceListener((LivingEntity)zombifiedPiglin);
            if (spawnType != MobSpawnType.CONVERSION) {
                List piglinTypes;
                if (rSource.m_188501_() < ((Double)PPConfig.COMMON.zombifiedPiglinDefaultChance.get()).floatValue()) {
                    tSource.setTransformationSource("piglin");
                }
                if (rSource.m_188501_() < ((Double)PPConfig.COMMON.piglinVariantChances.get()).floatValue() && !(piglinTypes = (List)PPConfig.COMMON.zombifiedPiglinTypeList.get()).isEmpty()) {
                    tSource.setTransformationSource((String)piglinTypes.get(rSource.m_188503_(piglinTypes.size())));
                }
                float bruteChance = ((Double)PPConfig.COMMON.zombifiedBruteChance.get()).floatValue();
                if (tSource.getTransformationSource().equals("piglin")) {
                    if (rSource.m_188501_() < bruteChance) {
                        zombifiedPiglin.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42433_));
                        tSource.setTransformationSource("piglin_brute");
                        zombifiedPiglin.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)PPItems.BUCKLER.get()));
                    }
                    if (rSource.m_188501_() < ((Double)PPConfig.COMMON.zombifiedAlchemistChance.get()).floatValue()) {
                        zombifiedPiglin.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                        tSource.setTransformationSource("piglin_alchemist");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void visionPercent(LivingEvent.LivingVisibilityEvent event) {
        if (event.getLookingEntity() != null) {
            ItemStack itemstack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
            EntityType entitytype = event.getLookingEntity().m_6095_();
            if (event.getLookingEntity() instanceof AbstractPiglin && (itemstack.m_150930_((Item)PPItems.PIGLIN_ALCHEMIST_HEAD_ITEM.get()) || itemstack.m_150930_((Item)PPItems.PIGLIN_BRUTE_HEAD_ITEM.get())) || entitytype == EntityType.f_20531_ && itemstack.m_150930_((Item)PPItems.ZOMBIFIED_PIGLIN_HEAD_ITEM.get())) {
                event.modifyVisibility(0.5);
            }
        }
    }

    @SubscribeEvent
    public static void onConvert(LivingConversionEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (event.getOutcome().m_6095_() == EntityType.f_20531_) {
                if (piglin.m_9236_().f_46443_) {
                    return;
                }
                ZombifiedPiglin ziglin = (ZombifiedPiglin)event.getOutcome();
                TransformationSourceListener transformationSource = PPEvents.getTransformationSourceListener((LivingEntity)ziglin);
                String piglinName = ForgeRegistries.ENTITY_TYPES.getKey((Object)piglin.m_6095_()).m_135815_();
                transformationSource.setTransformationSource(piglinName);
                PPNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ziglin), (Object)new ZiglinCapablitySyncPacket(ziglin.m_19879_(), piglinName));
            }
        }
    }

    @SubscribeEvent
    public static void onLootDropEntity(LivingDropsEvent event) {
        PiglinBrute brute;
        ItemStack itemstack;
        Fireball fireBall;
        Creeper creeper;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            if (event.getEntity().m_6095_() == EntityType.f_20531_) {
                event.getEntity().m_19998_((ItemLike)PPItems.ZOMBIFIED_PIGLIN_HEAD_ITEM.get());
            } else if (event.getEntity().m_6095_() == EntityType.f_20512_) {
                event.getEntity().m_19998_((ItemLike)PPItems.PIGLIN_BRUTE_HEAD_ITEM.get());
            }
            creeper.m_32314_();
        }
        if ((entity = event.getSource().m_7640_()) instanceof Fireball && (fireBall = (Fireball)entity).m_19749_() instanceof Ghast) {
            if (event.getEntity().m_6095_() == EntityType.f_20511_) {
                event.getEntity().m_19998_((ItemLike)Items.f_260451_);
            } else if (event.getEntity().m_6095_() == EntityType.f_20512_) {
                event.getEntity().m_19998_((ItemLike)PPItems.PIGLIN_BRUTE_HEAD_ITEM.get());
            }
        }
        if ((entity = event.getEntity()) instanceof PiglinBrute && (itemstack = (brute = (PiglinBrute)entity).m_21206_()).m_41720_() instanceof BucklerItem) {
            boolean flag;
            float f = 0.1f;
            boolean bl = flag = f > 1.0f;
            if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack) && (event.isRecentlyHit() || flag) && Math.max(brute.m_217043_().m_188501_() - (float)event.getLootingLevel() * 0.01f, 0.0f) < f) {
                if (itemstack.m_41763_()) {
                    itemstack.m_41721_(brute.m_217043_().m_188503_(brute.m_217043_().m_188503_(itemstack.m_41776_() / 2)));
                }
                brute.m_19983_(itemstack);
                brute.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
        }
    }

    @SubscribeEvent
    public static void noteBlockPlay(NoteBlockEvent.Play event) {
        BlockState stateAbove = event.getLevel().m_8055_(event.getPos().m_7494_());
        if (stateAbove.m_60713_((Block)PPBlocks.PIGLIN_ALCHEMIST_HEAD.get())) {
            event.setCanceled(true);
            event.getLevel().m_247517_(null, event.getPos(), (SoundEvent)PPSounds.ALCHEMIST_ANGRY.get(), SoundSource.RECORDS);
        }
        if (stateAbove.m_60713_((Block)PPBlocks.ZOMBIFIED_PIGLIN_HEAD.get())) {
            event.setCanceled(true);
            event.getLevel().m_247517_(null, event.getPos(), SoundEvents.f_12611_, SoundSource.RECORDS);
        }
        if (stateAbove.m_60713_((Block)PPBlocks.PIGLIN_BRUTE_HEAD.get())) {
            event.setCanceled(true);
            event.getLevel().m_247517_(null, event.getPos(), SoundEvents.f_12302_, SoundSource.RECORDS);
        }
    }

    public static TransformationSourceListener getTransformationSourceListener(LivingEntity entity) {
        LazyOptional listener = entity.getCapability(PPCapablities.TRANSFORMATION_SOURCE_TRACKER);
        if (listener.isPresent()) {
            return (TransformationSourceListener)listener.orElseThrow(() -> new IllegalStateException("Capability not found! Report this to the piglin proliferation github!"));
        }
        return null;
    }
}

