/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.tags;

import appeng.api.ids.AETags;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.tags.ConventionTags;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockTagsProvider
extends IntrinsicHolderTagsProvider<Block>
implements IAE2DataProvider {
    private static final BlockDefinition<?>[] SKY_STONE_BLOCKS = new BlockDefinition[]{AEBlocks.SKY_STONE_BLOCK, AEBlocks.SMOOTH_SKY_STONE_BLOCK, AEBlocks.SKY_STONE_BRICK, AEBlocks.SKY_STONE_SMALL_BRICK, AEBlocks.SKY_STONE_CHEST, AEBlocks.SMOOTH_SKY_STONE_CHEST, AEBlocks.SKY_STONE_STAIRS, AEBlocks.SMOOTH_SKY_STONE_STAIRS, AEBlocks.SKY_STONE_BRICK_STAIRS, AEBlocks.SKY_STONE_SMALL_BRICK_STAIRS, AEBlocks.SKY_STONE_WALL, AEBlocks.SMOOTH_SKY_STONE_WALL, AEBlocks.SKY_STONE_BRICK_WALL, AEBlocks.SKY_STONE_SMALL_BRICK_WALL, AEBlocks.SKY_STONE_SLAB, AEBlocks.SMOOTH_SKY_STONE_SLAB, AEBlocks.SKY_STONE_BRICK_SLAB, AEBlocks.SKY_STONE_SMALL_BRICK_SLAB};

    public BlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(packOutput, Registries.f_256747_, registries, block -> block.m_204297_().m_205785_(), "ae2", existingFileHelper);
    }

    protected void m_6577_(HolderLookup.Provider provider) {
        this.m_206424_(AETags.SPATIAL_BLACKLIST).m_255245_((Object)Blocks.f_50752_).m_176841_(ConventionTags.IMMOVABLE_BLOCKS.f_203868_());
        this.m_206424_(AETags.ANNIHILATION_PLANE_BLOCK_BLACKLIST);
        this.m_206424_(AETags.FACADE_BLOCK_WHITELIST).m_255179_((Object[])new Block[]{AEBlocks.QUARTZ_GLASS.block(), AEBlocks.QUARTZ_VIBRANT_GLASS.block()}).m_176841_(ConventionTags.GLASS_BLOCK.f_203868_());
        this.m_206424_(AETags.GROWTH_ACCELERATABLE).m_255179_((Object[])new Block[]{Blocks.f_50570_, Blocks.f_50571_, Blocks.f_50130_, Blocks.f_50130_, Blocks.f_50191_, Blocks.f_50704_, Blocks.f_50702_, Blocks.f_152538_, Blocks.f_50685_, Blocks.f_50200_, Blocks.f_50575_}).m_176841_(ConventionTags.CROPS.f_203868_()).m_176841_(ConventionTags.SAPLINGS.f_203868_()).m_206428_(ConventionTags.BUDDING_BLOCKS_BLOCKS);
        this.m_206424_(ConventionTags.BUDDING_BLOCKS_BLOCKS).m_255245_((Object)Blocks.f_152491_).m_255245_((Object)AEBlocks.FLAWLESS_BUDDING_QUARTZ.block()).m_255245_((Object)AEBlocks.FLAWED_BUDDING_QUARTZ.block()).m_255245_((Object)AEBlocks.CHIPPED_BUDDING_QUARTZ.block()).m_255245_((Object)AEBlocks.DAMAGED_BUDDING_QUARTZ.block());
        this.m_206424_(ConventionTags.BUDS_BLOCKS).m_255245_((Object)AEBlocks.SMALL_QUARTZ_BUD.block()).m_255245_((Object)AEBlocks.MEDIUM_QUARTZ_BUD.block()).m_255245_((Object)AEBlocks.LARGE_QUARTZ_BUD.block());
        this.m_206424_(ConventionTags.CLUSTERS_BLOCKS).m_255245_((Object)AEBlocks.QUARTZ_CLUSTER.block());
        this.m_206424_(ConventionTags.CERTUS_QUARTZ_STORAGE_BLOCK_BLOCK).m_255245_((Object)AEBlocks.QUARTZ_BLOCK.block());
        this.m_206424_(Tags.Blocks.STORAGE_BLOCKS).m_206428_(ConventionTags.CERTUS_QUARTZ_STORAGE_BLOCK_BLOCK);
        this.m_206424_(BlockTags.f_13032_).m_255179_((Object[])new Block[]{AEBlocks.SKY_STONE_WALL.block(), AEBlocks.SMOOTH_SKY_STONE_WALL.block(), AEBlocks.SKY_STONE_BRICK_WALL.block(), AEBlocks.SKY_STONE_SMALL_BRICK_WALL.block(), AEBlocks.FLUIX_WALL.block(), AEBlocks.QUARTZ_WALL.block(), AEBlocks.CUT_QUARTZ_WALL.block(), AEBlocks.SMOOTH_QUARTZ_WALL.block(), AEBlocks.QUARTZ_BRICK_WALL.block(), AEBlocks.CHISELED_QUARTZ_WALL.block(), AEBlocks.QUARTZ_PILLAR_WALL.block()});
        this.m_206424_(BlockTags.f_13081_).m_255179_((Object[])new Block[]{AEBlocks.QUARTZ_FIXTURE.block(), AEBlocks.LIGHT_DETECTOR.block()});
        this.addEffectiveTools();
    }

    private void addEffectiveTools() {
        HashMap specialTags = new HashMap();
        for (BlockDefinition<?> skyStoneBlock : SKY_STONE_BLOCKS) {
            specialTags.put(skyStoneBlock, List.of(BlockTags.f_144282_, BlockTags.f_144285_));
        }
        List<TagKey> defaultTags = List.of(BlockTags.f_144282_);
        for (BlockDefinition<?> block : AEBlocks.getBlocks()) {
            for (TagKey desiredTag : specialTags.getOrDefault(block, defaultTags)) {
                this.m_206424_(desiredTag).m_255245_(block.block());
            }
        }
    }

    private TagsProvider.TagAppender<Block> tag(String name) {
        return this.m_206424_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(name)));
    }
}

