/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.RandomSource;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class SpatialSkyRender {
    private static final SpatialSkyRender INSTANCE = new SpatialSkyRender();
    private final RandomSource random = RandomSource.m_216327_();
    private final VertexBuffer sparkleBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
    private long cycle = 0L;
    private static final Quaternionf[] SKYBOX_SIDE_ROTATIONS = new Quaternionf[]{new Quaternionf(), new Quaternionf().rotationX(1.5707964f), new Quaternionf().rotationX(-1.5707964f), new Quaternionf().rotationX((float)Math.PI), new Quaternionf().rotationZ(1.5707964f), new Quaternionf().rotationZ(-1.5707964f)};

    public static SpatialSkyRender getInstance() {
        return INSTANCE;
    }

    public void render(PoseStack poseStack, Matrix4f projectionMatrix) {
        long now = System.currentTimeMillis();
        if (now - this.cycle > 2000L) {
            this.cycle = now;
            this.rebuildSparkles();
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)false);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        for (Quaternionf rotation : SKYBOX_SIDE_ROTATIONS) {
            poseStack.m_85836_();
            poseStack.m_252781_(rotation);
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(matrix4f, -100.0f, -100.0f, -100.0f).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, -100.0f, -100.0f, 100.0f).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, 100.0f, -100.0f, 100.0f).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, 100.0f, -100.0f, -100.0f).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
            tessellator.m_85914_();
            poseStack.m_85849_();
        }
        float fade = now - this.cycle;
        fade /= 1000.0f;
        if ((fade = 0.25f * (1.0f - Math.abs((fade - 1.0f) * (fade - 1.0f)))) > 0.0f) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)fade, (float)fade, (float)fade, (float)1.0f);
            this.sparkleBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172811_());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
    }

    private void rebuildSparkles() {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vb = tessellator.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < 50; ++i) {
            double iX = this.random.m_188501_() * 2.0f - 1.0f;
            double iY = this.random.m_188501_() * 2.0f - 1.0f;
            double iZ = this.random.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.05f + this.random.m_188501_() * 0.1f;
            double dist = iX * iX + iY * iY + iZ * iZ;
            if (!(dist < 1.0) || !(dist > 0.01)) continue;
            dist = 1.0 / Math.sqrt(dist);
            double x = (iX *= dist) * 100.0;
            double y = (iY *= dist) * 100.0;
            double z = (iZ *= dist) * 100.0;
            double d8 = Math.atan2(iX, iZ);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(iX * iX + iZ * iZ), iY);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = this.random.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + 0.0 * d13;
                double d23 = 0.0 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                vb.m_5483_(x + d24, y + d22, z + d25).m_6122_(255, 255, 255, 255).m_5752_();
            }
        }
        this.sparkleBuffer.m_231221_(vb.m_231175_());
    }
}

