/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.screen;

import appeng.client.Point;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytParagraph;
import appeng.client.guidebook.document.flow.LytFlowSpan;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.MinecraftFontMetrics;
import appeng.client.guidebook.navigation.NavigationNode;
import appeng.client.guidebook.navigation.NavigationTree;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.client.guidebook.screen.GuideScreen;
import appeng.sounds.AppEngSounds;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class GuideNavBar
extends AbstractWidget {
    private static final int WIDTH_CLOSED = 15;
    private static final int WIDTH_OPEN = 150;
    private static final int CHILD_ROW_INDENT = 10;
    private static final int PARENT_ROW_INDENT = 7;
    private NavigationTree navTree;
    private final List<Row> rows = new ArrayList<Row>();
    private final GuideScreen screen;
    private int scrollOffset;
    private State state = State.CLOSED;

    public GuideNavBar(GuideScreen screen) {
        super(0, 0, 15, screen.f_96544_, (Component)Component.m_237113_((String)"Navigation Tree"));
        this.screen = screen;
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (this.state != State.OPENING && this.state != State.OPEN) {
            return;
        }
        Row row = this.pickRow(mouseX, mouseY);
        if (row != null) {
            row.expanded = !row.expanded;
            this.updateLayout();
            SoundManager handler = Minecraft.m_91087_().m_91106_();
            handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)AppEngSounds.GUIDE_CLICK_EVENT, (float)1.0f));
            if (row.node.pageId() != null) {
                this.screen.navigateTo(row.node.pageId());
            }
        }
    }

    public void m_7435_(SoundManager handler) {
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.state != State.OPENING && this.state != State.OPEN) {
            return false;
        }
        this.setScrollOffset((int)Math.round((double)this.scrollOffset - dragY));
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.state != State.OPENING && this.state != State.OPEN) {
            return false;
        }
        this.setScrollOffset((int)Math.round((double)this.scrollOffset - delta * 20.0));
        return true;
    }

    private void setScrollOffset(int offset) {
        int maxScrollOffset = 0;
        List<Row> visibleRows = this.rows.stream().filter(Row::isVisible).toList();
        if (!visibleRows.isEmpty()) {
            int contentHeight = visibleRows.get((int)(visibleRows.size() - 1)).bottom - visibleRows.get((int)0).top;
            maxScrollOffset = Math.max(0, contentHeight - this.f_93619_);
        }
        this.scrollOffset = Mth.m_14045_((int)offset, (int)0, (int)maxScrollOffset);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        LytRect viewport = new LytRect(0, this.scrollOffset, this.f_93618_, this.f_93619_);
        SimpleRenderContext renderContext = new SimpleRenderContext(viewport, graphics);
        boolean containsMouse = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY <= this.m_252907_() + this.f_93619_;
        switch (this.state) {
            case CLOSED: {
                if (!containsMouse) break;
                this.state = State.OPENING;
                break;
            }
            case OPENING: {
                this.f_93618_ = Math.round((float)this.f_93618_ + Math.max(1.0f, partialTick * 135.0f));
                if (this.f_93618_ < 150) break;
                this.f_93618_ = 150;
                this.state = State.OPEN;
                break;
            }
            case OPEN: {
                if (containsMouse) break;
                this.state = State.CLOSING;
                break;
            }
            case CLOSING: {
                this.f_93618_ = Math.round((float)this.f_93618_ - Math.max(1.0f, partialTick * 135.0f));
                if (this.f_93618_ > 15) break;
                this.f_93618_ = 15;
                this.state = State.CLOSED;
            }
        }
        this.updateMousePos(mouseX, mouseY);
        NavigationTree currentNavTree = this.screen.getGuide().getNavigationTree();
        if (currentNavTree != this.navTree) {
            this.recreateRows();
        }
        if (this.state == State.CLOSED) {
            renderContext.fillGradientHorizontal(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, SymbolicColor.NAVBAR_BG_TOP, SymbolicColor.NAVBAR_BG_BOTTOM);
            Vec2 p1 = new Vec2((float)(this.f_93618_ - 4), (float)this.f_93619_ / 2.0f);
            Vec2 p2 = new Vec2(4.0f, (float)this.f_93619_ / 2.0f - 5.0f);
            Vec2 p3 = new Vec2(4.0f, (float)this.f_93619_ / 2.0f + 5.0f);
            renderContext.fillTriangle(p1, p2, p3, SymbolicColor.NAVBAR_EXPAND_ARROW);
        } else {
            renderContext.fillGradientVertical(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, SymbolicColor.NAVBAR_BG_TOP, SymbolicColor.NAVBAR_BG_BOTTOM);
        }
        if (this.state != State.CLOSED) {
            graphics.m_280588_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)this.m_252754_(), (float)(this.m_252907_() - this.scrollOffset), 0.0f);
            Row hoveredRow = this.pickRow(mouseX, mouseY);
            if (hoveredRow != null) {
                renderContext.fillRect(hoveredRow.getBounds(), SymbolicColor.NAVBAR_ROW_HOVER);
            }
            MultiBufferSource.BufferSource buffers = renderContext.beginBatch();
            for (Row row : this.rows) {
                if (!row.isVisible(viewport)) continue;
                row.paragraph.renderBatch(renderContext, (MultiBufferSource)buffers);
            }
            renderContext.endBatch(buffers);
            for (Row row : this.rows) {
                ItemStack icon;
                if (!row.isVisible(viewport)) continue;
                if (row.hasChildren) {
                    Vec2 p3;
                    Vec2 p2;
                    Vec2 p1;
                    float x = row.getBounds().x();
                    x += 5.0f;
                    float y = row.getBounds().y();
                    y += 2.0f;
                    if (row.expanded) {
                        p1 = new Vec2(x + 5.0f, y);
                        p2 = new Vec2(x, y);
                        p3 = new Vec2(x + 2.5f, y + 5.0f);
                    } else {
                        p1 = new Vec2(x + 5.0f, y + 2.5f);
                        p2 = new Vec2(x, y);
                        p3 = new Vec2(x, y + 5.0f);
                    }
                    SymbolicColor color = row == hoveredRow ? SymbolicColor.LINK : SymbolicColor.BODY_TEXT;
                    renderContext.fillTriangle(p1, p2, p3, color);
                }
                if ((icon = row.node.icon()).m_41619_()) continue;
                renderContext.renderItem(icon, row.paragraph.getBounds().x() - 9, row.paragraph.getBounds().y(), 1, 8.0f, 8.0f);
            }
            pose.m_85849_();
            graphics.m_280618_();
        }
    }

    @Nullable
    private Row pickRow(double x, double y) {
        Point vpPos = this.getViewportPoint(x, y);
        if (vpPos != null) {
            for (Row row : this.rows) {
                if (!row.isVisible() || vpPos.getY() < row.top || vpPos.getY() >= row.bottom) continue;
                return row;
            }
        }
        return null;
    }

    private void updateMousePos(double x, double y) {
        Point vpPos = this.getViewportPoint(x, y);
        for (Row row : this.rows) {
            if (!row.isVisible()) continue;
            if (vpPos != null && row.contains(vpPos.getX(), vpPos.getY())) {
                row.paragraph.onMouseEnter(row.span);
                continue;
            }
            row.paragraph.onMouseLeave();
        }
    }

    private void recreateRows() {
        this.navTree = this.screen.getGuide().getNavigationTree();
        this.rows.clear();
        for (NavigationNode rootNode : this.navTree.getRootNodes()) {
            Row row = new Row(rootNode, null);
            this.rows.add(row);
            for (NavigationNode child : row.node.children()) {
                row.hasChildren = true;
                Row childRow = new Row(child, row);
                this.rows.add(childRow);
            }
        }
        this.updateLayout();
    }

    private void updateLayout() {
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics());
        int currentY = 0;
        for (Row row : this.rows) {
            if (!row.isVisible()) continue;
            int indent = row.hasChildren ? 7 : (row.parent != null ? 10 : 0);
            if (!row.node.icon().m_41619_()) {
                indent += 8;
            }
            int x = indent;
            int width = 150 - indent;
            LytRect bounds = row.paragraph.layout(context, x, currentY, width);
            row.top = bounds.y();
            row.bottom = bounds.bottom();
            currentY = bounds.bottom();
        }
    }

    @Nullable
    private Point getViewportPoint(double screenX, double screenY) {
        if (this.state != State.OPENING && this.state != State.OPEN) {
            return null;
        }
        if (screenX >= (double)this.m_252754_() && screenX < (double)(this.m_252754_() + this.f_93618_) && screenY >= (double)this.m_252907_() && screenY < (double)(this.m_252907_() + this.f_93619_)) {
            int vpX = (int)Math.round(screenX - (double)this.m_252754_());
            int vpY = (int)Math.round(screenY + (double)this.scrollOffset - (double)this.m_252907_());
            return new Point(vpX, vpY);
        }
        return null;
    }

    static enum State {
        CLOSED,
        OPENING,
        OPEN,
        CLOSING;

    }

    private class Row {
        private final NavigationNode node;
        private final LytParagraph paragraph = new LytParagraph();
        public final LytFlowSpan span;
        private boolean expanded;
        private final Row parent;
        private boolean hasChildren;
        public int top;
        public int bottom;

        public Row(NavigationNode node, Row parent) {
            this.node = node;
            this.parent = parent;
            this.span = new LytFlowSpan();
            this.span.appendText(node.title());
            this.span.modifyHoverStyle(style -> style.color(SymbolicColor.LINK));
            this.paragraph.setPaddingLeft(5);
            this.paragraph.append(this.span);
        }

        public LytRect getBounds() {
            return new LytRect(0, this.top, GuideNavBar.this.f_93618_, this.bottom - this.top);
        }

        public boolean contains(int x, int y) {
            return x >= 0 && x < GuideNavBar.this.f_93618_ && y >= this.top && y < this.bottom;
        }

        public boolean isVisible() {
            return this.parent == null || this.parent.expanded;
        }

        public boolean isVisible(LytRect viewport) {
            return this.isVisible() && this.bottom > viewport.y() && this.top < viewport.bottom();
        }
    }
}

