/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.util.AECableType;
import appeng.block.networking.EnergyCellBlock;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.hooks.ticking.TickHandler;
import appeng.me.energy.StoredEnergyAmount;
import appeng.util.SettingsFrom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class EnergyCellBlockEntity
extends AENetworkBlockEntity
implements IAEPowerStorage {
    private final StoredEnergyAmount stored;
    private byte currentDisplayLevel;
    private boolean neighborChangePending;

    public EnergyCellBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IAEPowerStorage.class, this);
        EnergyCellBlock cellBlock = (EnergyCellBlock)this.m_58900_().m_60734_();
        this.stored = new StoredEnergyAmount(0.0, cellBlock.getMaxPower(), this::emitPowerEvent);
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        super.onReady();
        int value = (Integer)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)EnergyCellBlock.ENERGY_STORAGE);
        this.currentDisplayLevel = (byte)value;
        this.updateStateForPowerLevel();
    }

    public static int getStorageLevelFromFillFactor(double fillFactor) {
        return (int)Math.floor(4.0 * Mth.m_14008_((double)(fillFactor + 0.01), (double)0.0, (double)1.0));
    }

    private void updateStateForPowerLevel() {
        if (this.m_58901_()) {
            return;
        }
        int storageLevel = EnergyCellBlockEntity.getStorageLevelFromFillFactor(this.stored.getAmount() / this.stored.getMaximum());
        if (this.currentDisplayLevel != storageLevel) {
            this.currentDisplayLevel = (byte)storageLevel;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(storageLevel)));
        }
    }

    private void onAmountChanged() {
        if (!this.neighborChangePending) {
            this.neighborChangePending = true;
            TickHandler.instance().addCallable((LevelAccessor)this.f_58857_, () -> {
                if (!this.m_58901_() && this.neighborChangePending) {
                    this.neighborChangePending = false;
                    this.updateStateForPowerLevel();
                    this.m_6596_();
                }
            });
        }
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128347_("internalCurrentPower", this.stored.getAmount());
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.stored.setStored(data.m_128459_("internalCurrentPower"));
    }

    @Override
    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            this.stored.setStored(input.m_128459_("internalCurrentPower"));
        }
    }

    @Override
    public void exportSettings(SettingsFrom from, CompoundTag data, @Nullable Player player) {
        super.exportSettings(from, data, player);
        if (from == SettingsFrom.DISMANTLE_ITEM && this.stored.getAmount() > 0.0) {
            data.m_128347_("internalCurrentPower", this.stored.getAmount());
            data.m_128347_("internalMaxPower", this.stored.getMaximum());
        }
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        double inserted = this.stored.insert(amt, mode == Actionable.MODULATE);
        if (mode == Actionable.MODULATE && inserted > 0.0) {
            this.onAmountChanged();
        }
        return amt - inserted;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    private double extractAEPower(double amt, Actionable mode) {
        double extracted = this.stored.extract(amt, mode == Actionable.MODULATE);
        if (mode == Actionable.MODULATE && extracted > 0.0) {
            this.onAmountChanged();
        }
        return extracted;
    }

    @Override
    public double getAEMaxPower() {
        return this.stored.getMaximum();
    }

    @Override
    public double getAECurrentPower() {
        return this.stored.getAmount();
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public int getPriority() {
        return ((EnergyCellBlock)this.m_58900_().m_60734_()).getPriority();
    }

    private void emitPowerEvent(GridPowerStorageStateChanged.PowerEventType type) {
        this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, type)));
    }
}

