/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.implementations.menuobjects;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemMenuHost
implements IUpgradeableObject {
    private final Player player;
    @Nullable
    private final Integer slot;
    private final ItemStack itemStack;
    private final IUpgradeInventory upgrades;
    private int powerTicks = 0;
    private double powerDrainPerTick = 0.5;

    public ItemMenuHost(Player player, @Nullable Integer slot, ItemStack itemStack) {
        this.player = player;
        this.slot = slot;
        this.itemStack = itemStack;
        Item item = itemStack.m_41720_();
        if (item instanceof IUpgradeableItem) {
            IUpgradeableItem upgradeableItem = (IUpgradeableItem)item;
            this.upgrades = upgradeableItem.getUpgrades(itemStack);
        } else {
            this.upgrades = UpgradeInventories.empty();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public Integer getSlot() {
        return this.slot;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean isClientSide() {
        return this.player.m_9236_().f_46443_;
    }

    public boolean onBroadcastChanges(AbstractContainerMenu menu) {
        return true;
    }

    protected boolean ensureItemStillInSlot() {
        if (this.slot == null) {
            return true;
        }
        ItemStack expectedItem = this.getItemStack();
        Inventory inventory = this.getPlayer().m_150109_();
        ItemStack currentItem = inventory.m_8020_(this.slot.intValue());
        if (!currentItem.m_41619_() && !expectedItem.m_41619_()) {
            if (currentItem == expectedItem) {
                return true;
            }
            if (ItemStack.m_41656_((ItemStack)expectedItem, (ItemStack)currentItem)) {
                inventory.m_6836_(this.slot.intValue(), expectedItem);
                return true;
            }
        }
        return false;
    }

    public boolean drainPower() {
        ItemMenuHost itemMenuHost = this;
        if (itemMenuHost instanceof IEnergySource) {
            IEnergySource energySource = (IEnergySource)((Object)itemMenuHost);
            ++this.powerTicks;
            if (this.powerTicks > 10) {
                double amt = (double)this.powerTicks * this.powerDrainPerTick;
                this.powerTicks = 0;
                return energySource.extractAEPower(amt, Actionable.MODULATE, PowerMultiplier.CONFIG) > 0.0;
            }
        }
        return true;
    }

    protected void setPowerDrainPerTick(double powerDrainPerTick) {
        this.powerDrainPerTick = powerDrainPerTick;
    }

    @Override
    public final IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }
}

