/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class Pair<T, V> {
    private final T left;
    private final V right;

    public Pair(T t, V v) {
        this.left = t;
        this.right = v;
    }

    public static <T, V> Pair<T, V> onlyRight(V v) {
        return new Pair<Object, V>(null, v);
    }

    public static <T, V> Pair<T, V> onlyLeft(T t) {
        return new Pair<T, Object>(t, null);
    }

    public static <T, V> Pair<T, V> of(T t, V v) {
        return new Pair<T, V>(t, v);
    }

    public T getLeft() {
        return this.left;
    }

    public V getRight() {
        return this.right;
    }

    public boolean leftPresent() {
        return this.left != null;
    }

    public boolean rightPresent() {
        return this.right != null;
    }

    public void ifRightPresent(Consumer<V> consumer) {
        if (this.rightPresent()) {
            consumer.accept(this.right);
        }
    }

    public void ifLeftPresent(Consumer<T> consumer) {
        if (this.leftPresent()) {
            consumer.accept(this.left);
        }
    }

    public <T1> Pair<T1, V> mapLeft(Function<T, T1> mapFunc) {
        return new Pair<T1, V>(mapFunc.apply(this.left), this.right);
    }

    public <V1> Pair<T, V1> mapRight(Function<V, V1> mapFunc) {
        return new Pair<T, V1>(this.left, mapFunc.apply(this.right));
    }

    public <T1, V1> Pair<T1, V1> mapBoth(BiFunction<T, V, Pair<T1, V1>> mapFunc) {
        return mapFunc.apply(this.left, this.right);
    }

    public <T1> Pair<T1, V> ignoreLeft() {
        return new Pair<Object, V>(null, this.right);
    }

    public <V1> Pair<T, V1> ignoreRight() {
        return new Pair<T, Object>(this.left, null);
    }

    public <R> R reduce(BiFunction<T, V, R> reduceFunc) {
        return reduceFunc.apply(this.left, this.right);
    }
}

