/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.turtles;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.ChatBoxPeripheral;
import de.srendi.advancedperipherals.common.events.Events;
import de.srendi.advancedperipherals.lib.turtle.PeripheralTurtleUpgrade;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class TurtleChatBoxUpgrade
extends PeripheralTurtleUpgrade<ChatBoxPeripheral> {
    private long lastConsumedMessage = Events.getLastChatMessageID() - 1L;

    public TurtleChatBoxUpgrade(ResourceLocation id, ItemStack item) {
        super(id, item);
    }

    @Override
    public ModelResourceLocation getLeftModel() {
        return new ModelResourceLocation(AdvancedPeripherals.getRL("turtle_chat_box_upgrade_left"), "inventory");
    }

    @Override
    public ModelResourceLocation getRightModel() {
        return new ModelResourceLocation(AdvancedPeripherals.getRL("turtle_chat_box_upgrade_right"), "inventory");
    }

    @Override
    protected ChatBoxPeripheral buildPeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        return new ChatBoxPeripheral(turtle, side);
    }

    public void update(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        BlockEntity tile;
        super.update(turtle, side);
        if (turtle.getLevel().f_46443_) {
            return;
        }
        if (turtle.getUpgrade(side) instanceof TurtleChatBoxUpgrade && (tile = turtle.getLevel().m_7702_(turtle.getPosition())) instanceof TurtleBlockEntity) {
            TurtleBlockEntity tileTurtle = (TurtleBlockEntity)tile;
            ServerComputer computer = tileTurtle.getServerComputer();
            this.lastConsumedMessage = Events.traverseChatMessages(this.lastConsumedMessage, message -> computer.queueEvent("chat", new Object[]{message.username(), message.message(), message.uuid(), message.isHidden()}));
        }
    }
}

