/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.mixin;

import com.fizzware.dramaticdoors.config.DDConfig;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class DDMixinConfig
implements IMixinConfigPlugin {
    private boolean waterloggableDoors = true;
    private boolean waterloggableFenceGates = true;

    public void onLoad(String mixinPackage) {
        DDConfig.initializeConfigs();
        this.waterloggableDoors = DDConfig.CONFIG.getOrDefault("dramaticdoors.waterloggable_doors", true);
        this.waterloggableFenceGates = DDConfig.CONFIG.getOrDefault("dramaticdoors.waterloggable_fence_gates", true);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.equals("com.fizzware.dramaticdoors.mixin.DoorBlockMixin")) {
            return this.waterloggableDoors && !FabricLoader.getInstance().isModLoaded("fluidlogged");
        }
        if (mixinClassName.equals("com.fizzware.dramaticdoors.mixin.fabric.JapaneseDoorBlockMixinFabric")) {
            return this.waterloggableDoors && FabricLoader.getInstance().isModLoaded("mcwdoors") && !FabricLoader.getInstance().isModLoaded("forge");
        }
        if (mixinClassName.equals("com.fizzware.dramaticdoors.mixin.forge.JapaneseDoorBlockMixinForge")) {
            return this.waterloggableDoors && FabricLoader.getInstance().isModLoaded("mcwdoors") && FabricLoader.getInstance().isModLoaded("forge");
        }
        if (mixinClassName.equals("com.fizzware.dramaticdoors.mixin.FenceGateBlockMixin")) {
            return this.waterloggableFenceGates && !FabricLoader.getInstance().isModLoaded("fluidlogged");
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

