/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.compat;

import com.fizzware.dramaticdoors.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.blocks.TallSlidingDoorBlock;
import com.fizzware.dramaticdoors.blocks.TallStableDoorBlock;
import com.fizzware.dramaticdoors.items.DDItems;
import com.fizzware.dramaticdoors.items.ShortDoorItem;
import com.fizzware.dramaticdoors.items.TallDoorItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_8177;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class DDCompatRegistry {
    public static final List<Pair<String, class_2248>> DOOR_BLOCKS_TO_REGISTER = new ArrayList<Pair<String, class_2248>>();
    public static final List<Pair<String, class_1792>> DOOR_ITEMS_TO_REGISTER = new ArrayList<Pair<String, class_1792>>();

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, class_2248 block, class_8177 blocksettype, boolean includeShort) {
        class_2248 tempBlock = DDCompatRegistry.createDoorBlock(block, blocksettype, true);
        class_1792 tempItem = DDCompatRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDCompatRegistry.createDoorBlock(block, blocksettype, false);
            tempItem = DDCompatRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    public static void registerSlidingDoorBlockAndItem(String tallname, @Nullable String shortname, class_2248 block, class_8177 blocksettype, boolean includeShort) {
        class_2248 tempBlock = DDCompatRegistry.createSlidingDoorBlock(block, blocksettype, true);
        class_1792 tempItem = DDCompatRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDCompatRegistry.createSlidingDoorBlock(block, blocksettype, false);
            tempItem = DDCompatRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    public static void registerStableDoorBlockAndItem(String tallname, @Nullable String shortname, class_2248 block, class_8177 blocksettype, boolean includeShort) {
        class_2248 tempBlock = DDCompatRegistry.createStableDoorBlock(block, blocksettype, true);
        class_1792 tempItem = DDCompatRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDCompatRegistry.createStableDoorBlock(block, blocksettype, false);
            tempItem = DDCompatRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    protected static class_2248 createSlidingDoorBlock(class_2248 block, class_8177 blocksettype, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw sliding doors are currently not supported.");
        }
        TallSlidingDoorBlock tempBlock = new TallSlidingDoorBlock(block, blocksettype);
        return tempBlock;
    }

    protected static class_2248 createStableDoorBlock(class_2248 block, class_8177 blocksettype, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw stable doors are currently not supported.");
        }
        TallStableDoorBlock tempBlock = new TallStableDoorBlock(block, blocksettype);
        return tempBlock;
    }

    protected static class_2248 createDoorBlock(class_2248 block, class_8177 blocksettype, boolean isTall) {
        class_2248 tempBlock = isTall ? new TallDoorBlock(block, blocksettype) : new ShortDoorBlock(block, blocksettype);
        return tempBlock;
    }

    protected static class_1792 createDoorItem(class_2248 block, boolean isTall) {
        class_1747 tempItem = isTall ? new TallDoorItem(block, DDItems.PROPERTIES) : new ShortDoorItem(block, DDItems.PROPERTIES);
        return tempItem;
    }
}

