/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SelectFluidScreen
extends ButtonListBaseScreen {
    private final FluidConfig config;
    private final ConfigCallback callback;

    public SelectFluidScreen(FluidConfig c, ConfigCallback cb) {
        this.setTitle((Component)Component.m_237115_((String)"ftblibrary.select_fluid.gui"));
        this.setHasSearchBox(true);
        this.config = c;
        this.callback = cb;
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.config.allowEmptyFluid()) {
            FluidStack fluidStack = FluidStack.create((Fluid)Fluids.f_76191_, (long)FluidStack.bucketAmount());
            this.addFluidButton(panel, ItemIcon.getItemIcon(Items.f_42446_), fluidStack);
        }
        for (Fluid fluid : BuiltInRegistries.f_257020_) {
            if (fluid == Fluids.f_76191_ || !fluid.m_76145_().m_76170_()) continue;
            FluidStack fluidStack = FluidStack.create((Fluid)fluid, (long)FluidStack.bucketAmount());
            Icon icon = Icon.getIcon(ClientUtils.getStillTexture(fluidStack)).withTint(Color4I.rgb(ClientUtils.getFluidColor(fluidStack)));
            this.addFluidButton(panel, icon, fluidStack);
        }
    }

    private void addFluidButton(Panel panel, Icon icon, final FluidStack fluidStack) {
        panel.add(new SimpleTextButton(panel, fluidStack.getName(), icon){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectFluidScreen.this.config.setCurrentValue(fluidStack.copy());
                SelectFluidScreen.this.callback.save(true);
            }

            @Override
            public Optional<PositionedIngredient> getIngredientUnderMouse() {
                return PositionedIngredient.of(fluidStack, this);
            }
        });
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return true;
        }
        return false;
    }
}

