/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SignPostBlockTileRenderer
implements BlockEntityRenderer<SignPostBlockTile> {
    private final Camera camera;
    private final Font font;
    public final ModelPart signModel;

    public static LayerDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("sign", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-12.0f, -5.0f, -3.0f, 2.0f, 1.0f, 1.0f).m_171514_(0, 0).m_171481_(-8.0f, -7.0f, -3.0f, 16.0f, 5.0f, 1.0f).m_171514_(0, 6).m_171481_(-10.0f, -6.0f, -3.0f, 2.0f, 3.0f, 1.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)16);
    }

    public SignPostBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.m_173582_(ClientRegistry.SIGN_POST_MODEL);
        this.signModel = model.m_171324_("sign");
        this.camera = Minecraft.m_91087_().f_91063_.m_109153_();
        this.font = context.m_173586_();
    }

    public int m_142163_() {
        return 96;
    }

    public void render(SignPostBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockPos pos = tile.m_58899_();
        Vec3 cameraPos = this.camera.m_90583_();
        LOD lod = new LOD(cameraPos, pos);
        SignPostBlockTile.Sign signUp = tile.getSignUp();
        SignPostBlockTile.Sign signDown = tile.getSignDown();
        boolean up = signUp.active();
        boolean down = signDown.active();
        if (up || down) {
            TextUtil.RenderProperties textProperties;
            Vector3f v;
            float relAngle = LOD.getRelativeAngle((Vec3)cameraPos, (BlockPos)pos);
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            if (up) {
                v = new Vector3f();
                v.rotateY(signUp.yaw() * ((float)Math.PI / 180));
                textProperties = tile.getTextHolder(0).computeRenderProperties(combinedLightIn, v, () -> ((LOD)lod).isVeryNear());
                poseStack.m_85836_();
                this.renderSign(tile, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, lod, signUp, relAngle, textProperties, 0);
                poseStack.m_85849_();
            }
            if (down) {
                v = new Vector3f();
                v.rotateY(signUp.yaw() * ((float)Math.PI / 180));
                textProperties = tile.getTextHolder(1).computeRenderProperties(combinedLightIn, v, () -> ((LOD)lod).isVeryNear());
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, -0.5, 0.0);
                this.renderSign(tile, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, lod, signDown, relAngle, textProperties, 1);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    private void renderSign(SignPostBlockTile tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, LOD lod, SignPostBlockTile.Sign sign, float relAngle, TextUtil.RenderProperties textProperties, int line) {
        boolean left = sign.left();
        int o = left ? 1 : -1;
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(sign.yaw() - 90.0f));
        if (tile.isSlim()) {
            matrixStackIn.m_252880_(0.0f, 0.0f, -0.0625f);
        }
        matrixStackIn.m_85836_();
        if (!left) {
            matrixStackIn.m_252781_(RotHlpr.YN180);
            matrixStackIn.m_85837_(0.0, 0.0, -0.3125);
        }
        matrixStackIn.m_85841_(1.0f, -1.0f, -1.0f);
        Material material = ModMaterials.SIGN_POSTS_MATERIALS.get().get(sign.woodType());
        VertexConsumer builder = material.m_119194_(bufferIn, RenderType::m_110446_);
        this.signModel.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
        if (lod.isNear() && LOD.isOutOfFocus((float)relAngle, (float)(sign.yaw() + 90.0f), (float)2.0f)) {
            matrixStackIn.m_85837_(-0.03125 * (double)o, 0.28125, 0.1925);
            matrixStackIn.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
            TextUtil.renderLine((FormattedCharSequence)tile.getTextHolder(line).getRenderMessages(0, this.font), (Font)this.font, (float)-4.0f, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (TextUtil.RenderProperties)textProperties);
        }
    }
}

