/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class JarBakedModel
implements CustomBakedModel {
    private static final boolean SINGLE_PASS = PlatHelper.getPlatform().isFabric();
    private static final Vector3f LAST_KNOWN_DIMENSIONS = new Vector3f(0.5f, 0.75f, 0.0625f);
    private final BakedModel jar;
    private final float width;
    private final float height;
    private final float yOffset;

    public JarBakedModel(BakedModel goblet, float width, float height, float yOffset, ModelState rotation) {
        this.jar = goblet;
        this.width = width;
        this.height = height;
        this.yOffset = yOffset;
        LAST_KNOWN_DIMENSIONS.set(width, height, yOffset);
    }

    public static Vector3f getJarLiquidDimensions() {
        return LAST_KNOWN_DIMENSIONS;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (!SINGLE_PASS && renderType == RenderType.m_110466_()) {
            SoftFluid fluid = (SoftFluid)data.get(ModBlockProperties.FLUID);
            if (fluid != null && !fluid.isEmpty()) {
                float amount = ((Float)data.get(ModBlockProperties.FILL_LEVEL)).floatValue();
                TextureAtlasSprite sprite = ModMaterials.get(fluid.getStillTexture()).m_119204_();
                BakedQuadBuilder builder = BakedQuadBuilder.create((TextureAtlasSprite)sprite);
                builder.setAutoDirection();
                builder.lightEmission(fluid.getLuminosity());
                builder.setTint(1);
                PoseStack p = new PoseStack();
                p.m_85837_(0.5, (double)this.yOffset, 0.5);
                try {
                    builder.setAutoBuild(w -> quads.add((BakedQuad)w));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                VertexUtils.addCube((VertexConsumer)builder, p, 0.5f - this.width / 2.0f, 0.0f, this.width, this.height * amount, 0, -1, 1.0f);
            }
            if (!SINGLE_PASS) {
                return quads;
            }
        }
        quads.addAll(this.jar.m_213637_(state, side, rand));
        return quads;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData extraModelData) {
        return this.jar.m_6160_();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

