/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.foundation.ponder.content;

import com.google.common.collect.Lists;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlock;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlockEntity;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.HyperExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiBlocks;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.entry.CeiItems;

public class EnchantmentScenes {
    public static void disenchant(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("disenchant", "Disenchanting");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.68f);
        scene.world.setKineticSpeed(util.select.everywhere(), 32.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 6, 4, 6), Direction.DOWN);
        scene.overlay.showText(100).text("All received items will have their enchantments removed and the removed enchantments will be converted to liquid experience for storage.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 1));
        scene.world.propagatePipeChange(util.grid.at(2, 1, 5));
        BlockPos beltStart = util.grid.at(6, 1, 1);
        List<ItemStack> items = Stream.of(Items.f_42393_, Items.f_42385_, Items.f_42473_, Items.f_42690_, Items.f_42407_, Items.f_42479_, Items.f_42423_).map(Item::m_7968_).toList();
        for (ItemStack item : items) {
            EnchantmentScenes.enchantRandomly(item);
            ElementLink itemEntity = scene.world.createItemEntity(util.vector.centerOf(6, 4, 1), util.vector.of(0.0, 0.0, 0.0), item);
            scene.idle(13);
            scene.world.modifyEntity(itemEntity, Entity::m_146870_);
            scene.world.createItemOnBelt(beltStart, Direction.DOWN, item);
            scene.idle(2);
        }
        scene.idle(80);
        scene.overlay.showText(100).text("Players standing on the disenchanter will be quickly washed away their experience level, and the washed away experience value will be converted into liquid experience for storage").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 1));
        scene.idle(120);
    }

    public static void transformBlazeBurner(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("transform", "Using Enchanting Guide");
        scene.configureBasePlate(0, 0, 3);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 2, 1, 2), Direction.DOWN);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(1, 1, 1), Pointing.DOWN).whileSneaking().rightClick().withItem(CeiItems.ENCHANTING_GUIDE.asStack()), 30);
        scene.overlay.showText(50).text("Right-click the Blaze Burner with an Enchanting Guide in hand when sneaking to transform it to a Blaze Enchanter.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 1));
        scene.idle(30);
        scene.world.setBlock(util.grid.at(1, 1, 1), CeiBlocks.BLAZE_ENCHANTER.getDefaultState(), false);
        scene.world.modifyBlockEntity(util.grid.at(1, 1, 1), BlazeEnchanterBlockEntity.class, be -> be.setTargetItem(EnchantmentScenes.enchantingGuide(Enchantments.f_44962_, 1)));
        scene.idle(25);
        scene.overlay.showText(100).text("To make Blaze Enchanter work, Enchanting Guide must be configured first. Right-clicking Blaze Enchanter or right-clicking Enchanting Guide in hands can open configuration panel.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 1, 1));
        scene.idle(105);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(1, 1, 1), Pointing.DOWN).whileSneaking().rightClick().withWrench(), 30);
        scene.overlay.showText(50).text("To retrieve the enchanting guide, right-click the Blaze Enchanter with wrench when sneaking.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 1, 1));
        scene.idle(30);
        scene.world.setBlock(util.grid.at(1, 1, 1), (BlockState)AllBlocks.BLAZE_BURNER.getDefaultState().m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING), false);
        scene.idle(25);
        scene.world.setBlock(util.grid.at(1, 1, 1), CeiBlocks.BLAZE_ENCHANTER.getDefaultState(), false);
        scene.world.modifyBlockEntity(util.grid.at(1, 1, 1), BlazeEnchanterBlockEntity.class, be -> be.setTargetItem(EnchantmentScenes.enchantingGuide(Enchantments.f_44962_, 1)));
        scene.idle(10);
        scene.world.setBlock(util.grid.at(1, 1, 1), (BlockState)AllBlocks.BLAZE_BURNER.getDefaultState().m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), false);
        scene.overlay.showText(60).text("You can replace the Enchanting Guide by holding it directly in your hand and right-clicking on the Blaze Enchanter.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 1, 1));
        scene.idle(60);
    }

    public static void enchant(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("enchant", "Enchanting");
        scene.configureBasePlate(0, 0, 8);
        scene.scaleSceneView(0.6f);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.setKineticSpeed(util.select.everywhere(), 80.0f);
        scene.world.setKineticSpeed(util.select.fromTo(0, 2, 7, 5, 2, 7), -80.0f);
        scene.world.setKineticSpeed(util.select.fromTo(7, 2, 2, 7, 2, 7), -80.0f);
        scene.world.setBlock(util.grid.at(1, 2, 0), (BlockState)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().m_61124_(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.setBlock(util.grid.at(0, 2, 6), (BlockState)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().m_61124_(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.setBlock(util.grid.at(6, 2, 7), (BlockState)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().m_61124_(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.setBlock(util.grid.at(7, 2, 1), (BlockState)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().m_61124_(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.modifyBlockEntity(util.grid.at(1, 2, 0), BlazeEnchanterBlockEntity.class, be -> {
            be.setTargetItem(EnchantmentScenes.enchantingGuide(Enchantments.f_44972_, 1));
            be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> tank.fill(new FluidStack(((ExperienceFluid)((Object)((Object)((Object)CeiFluids.EXPERIENCE.get())))).m_5613_(), 1000), IFluidHandler.FluidAction.EXECUTE));
        });
        scene.world.modifyBlockEntity(util.grid.at(0, 2, 6), BlazeEnchanterBlockEntity.class, be -> {
            be.setTargetItem(EnchantmentScenes.enchantingGuide(Enchantments.f_44972_, 2));
            be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> tank.fill(new FluidStack(((ExperienceFluid)((Object)((Object)((Object)CeiFluids.EXPERIENCE.get())))).m_5613_(), 1000), IFluidHandler.FluidAction.EXECUTE));
        });
        scene.world.modifyBlockEntity(util.grid.at(6, 2, 7), BlazeEnchanterBlockEntity.class, be -> {
            be.setTargetItem(EnchantmentScenes.enchantingGuide(Enchantments.f_44962_, 1));
            be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> tank.fill(new FluidStack(((ExperienceFluid)((Object)((Object)((Object)CeiFluids.EXPERIENCE.get())))).m_5613_(), 1000), IFluidHandler.FluidAction.EXECUTE));
        });
        scene.world.modifyBlockEntity(util.grid.at(7, 2, 1), BlazeEnchanterBlockEntity.class, be -> {
            be.setTargetItem(EnchantmentScenes.enchantingGuide(Enchantments.f_44986_, 1));
            be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> tank.fill(new FluidStack(((ExperienceFluid)((Object)((Object)((Object)CeiFluids.EXPERIENCE.get())))).m_5613_(), 1000), IFluidHandler.FluidAction.EXECUTE));
        });
        scene.world.modifyBlockEntity(util.grid.at(3, 1, 3), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).m_5613_(), 1000)));
        scene.world.propagatePipeChange(util.grid.at(2, 1, 2));
        scene.world.propagatePipeChange(util.grid.at(5, 1, 2));
        scene.world.propagatePipeChange(util.grid.at(5, 1, 5));
        scene.world.propagatePipeChange(util.grid.at(5, 1, 2));
        scene.world.showSection(util.select.fromTo(0, 1, 0, 7, 4, 7), Direction.DOWN);
        scene.idle(5);
        List<ItemStack> items = Stream.of(Items.f_42481_, Items.f_42517_, Items.f_42690_, Items.f_42388_, Items.f_42388_, Items.f_42408_).map(Item::m_7968_).toList();
        for (ItemStack item : items) {
            BlockPos beltStart = util.grid.at(7, 2, 0);
            ElementLink itemEntity = scene.world.createItemEntity(util.vector.centerOf(7, 5, 0), util.vector.of(0.0, 0.0, 0.0), item);
            scene.idle(13);
            scene.world.modifyEntity(itemEntity, Entity::m_146870_);
            scene.world.createItemOnBelt(beltStart, Direction.DOWN, item);
            scene.idle(10);
        }
        scene.overlay.showText(60).text("Blaze Enchanter can enchant your items.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 2, 0));
        scene.idle(70);
        scene.overlay.showText(60).text("However, it cannot work on books...").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 2, 0));
        scene.idle(70);
        scene.overlay.showText(60).text("... nor can it add incompatible enchantments to your items.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 2, 0));
        scene.idle(70);
        scene.overlay.showText(60).text("Blaze Enchanter can upgrade an existing enchantment to a higher level if feasible").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(0, 2, 6));
        scene.idle(70);
        scene.idle(100);
    }

    public static void hyperEnchant(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("hyper_enchant", "Hyper-enchanting");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.68f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.modifyBlockEntity(util.grid.at(3, 1, 1), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).m_5613_(), 1000)));
        scene.world.modifyBlockEntity(util.grid.at(3, 1, 3), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((HyperExperienceFluid)((Object)((Object)CeiFluids.HYPER_EXPERIENCE.get()))).m_5613_(), 1000)));
        scene.world.propagatePipeChange(util.grid.at(2, 1, 1));
        scene.world.propagatePipeChange(util.grid.at(2, 1, 3));
        scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 3, 4), Direction.DOWN);
        scene.overlay.showText(60).text("This is liquid hyper experience").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(3, 3, 3));
        scene.overlay.showOutline(PonderPalette.BLUE, new Object(), util.select.fromTo(3, 1, 3, 3, 3, 3), 80);
        scene.idle(90);
        scene.world.setKineticSpeed(util.select.everywhere(), 128.0f);
        scene.idle(25);
        scene.world.setBlock(util.grid.at(1, 2, 1), (BlockState)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().m_61124_(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.setBlock(util.grid.at(1, 2, 3), (BlockState)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().m_61124_(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.SEETHING)), false);
        scene.idle(15);
        scene.overlay.showOutline(PonderPalette.BLUE, new Object(), util.select.position(1, 2, 3), 80);
        scene.overlay.showText(80).text("Hyper experience can make the Blaze Enchanter into seething state, and the level of the enchantment produced in this state will be one level higher than the set enchantment.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 2, 3));
        scene.idle(90);
        scene.overlay.showText(60).text("Enchantment with level cap of 1 level cannot be upgraded to level 2 in hyper-enchant.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 2, 3));
        scene.idle(60);
    }

    public static void handleExperienceNugget(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("absorb_experience_nugget", "Converting Experience Nugget to Liquid");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.68f);
        scene.world.setKineticSpeed(util.select.everywhere(), 32.0f);
        scene.world.setKineticSpeed(util.select.fromTo(0, 1, 2, 2, 1, 4), -32.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 1, 4), Direction.DOWN);
        ArrayList poses = Lists.newArrayList((Object[])new BlockPos[]{util.grid.at(2, 1, 0), util.grid.at(0, 1, 2), util.grid.at(2, 1, 4), util.grid.at(4, 1, 2)});
        for (BlockPos pos : poses) {
            ItemStack item = AllItems.EXP_NUGGET.asStack(64);
            ElementLink itemEntity = scene.world.createItemEntity(Vec3.m_82512_((Vec3i)pos.m_6630_(3)), util.vector.of(0.0, 0.0, 0.0), item);
            scene.idle(13);
            scene.world.modifyEntity(itemEntity, Entity::m_146870_);
            scene.world.createItemOnBelt(pos, Direction.DOWN, item);
            scene.idle(10);
        }
        scene.overlay.showText(60).text("Experience nugget can be absorbed by disenchanter.").placeNearTarget().pointAt(util.vector.topOf(2, 1, 2));
        scene.idle(60);
    }

    public static void dropExperienceNugget(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("drop_experience_nugget", "Maybe A Exp-farm?");
        scene.configureBasePlate(0, 0, 3);
        scene.scaleSceneView(1.2f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 2, 1, 2), Direction.DOWN);
        BlockPos deployerPos = util.grid.at(1, 1, 2);
        Selection deployerSelection = util.select.position(deployerPos);
        ItemStack sword = new ItemStack((ItemLike)Items.f_42393_);
        scene.idle(10);
        scene.world.modifyBlockEntityNBT(deployerSelection, DeployerBlockEntity.class, nbt -> {
            nbt.m_128365_("HeldItem", (Tag)sword.serializeNBT());
            nbt.m_128359_("mode", "PUNCH");
        });
        scene.idle(30);
        scene.world.setKineticSpeed(util.select.everywhere(), 32.0f);
        scene.addKeyframe();
        ElementLink sheep = scene.world.createEntity(w -> {
            Sheep entity = (Sheep)EntityType.f_20520_.m_20615_(w);
            entity.m_29855_(DyeColor.PINK);
            Vec3 p = util.vector.topOf(util.grid.at(1, 0, 0));
            entity.m_6034_(p.f_82479_, p.f_82480_, p.f_82481_);
            entity.f_19854_ = p.f_82479_;
            entity.f_19855_ = p.f_82480_;
            entity.f_19856_ = p.f_82481_;
            WalkAnimationState animation = entity.f_267362_;
            animation.m_267566_(-animation.m_267756_(), 1.0f);
            animation.m_267771_(1.0f);
            entity.f_19859_ = 210.0f;
            entity.m_146922_(210.0f);
            entity.f_20886_ = 210.0f;
            entity.f_20885_ = 210.0f;
            return entity;
        });
        scene.idle(5);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.modifyEntity(sheep, Entity::m_146870_);
        scene.effects.emitParticles(util.vector.topOf(deployerPos.m_122025_(2)).m_82520_(0.0, -0.25, 0.0), EmitParticlesInstruction.Emitter.withinBlockSpace((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50100_.m_49966_()), (Vec3)util.vector.of(0.0, 0.0, 0.0)), 25.0f, 1);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.overlay.showText(60).text("When mob is killed by deployer, experience nuggets are dropped.").placeNearTarget().pointAt(util.vector.centerOf(1, 1, 2));
        scene.overlay.showOutline(PonderPalette.BLUE, new Object(), util.select.position(1, 1, 2), 50);
        scene.world.flapFunnel(deployerPos.m_122012_(), true);
        scene.world.createItemEntity(util.vector.centerOf(deployerPos.m_122024_()).m_82492_(0.0, 0.45, 0.0), util.vector.of(-0.1, 0.0, 0.0), new ItemStack((ItemLike)Items.f_41876_));
        scene.idle(10);
        scene.world.flapFunnel(deployerPos.m_122012_(), true);
        scene.world.createItemEntity(util.vector.centerOf(deployerPos.m_122024_()).m_82492_(0.0, 0.45, 0.0), util.vector.of(-0.1, 0.0, 0.0), new ItemStack((ItemLike)Items.f_42658_));
        scene.idle(10);
        scene.world.flapFunnel(deployerPos.m_122012_(), true);
        scene.world.createItemEntity(util.vector.centerOf(deployerPos.m_122024_()).m_82492_(0.0, 0.45, 0.0), util.vector.of(-0.1, 0.0, 0.0), AllItems.EXP_NUGGET.asStack());
        scene.idle(40);
    }

    public static void crushingWheelTweak(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("crushing_wheel_tweak", "We call it inefficiency...");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.75f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 3, 4), Direction.DOWN);
        Selection crushWheelSelection = util.select.position(util.grid.at(4, 3, 3));
        scene.world.setKineticSpeed(util.select.everywhere(), 128.0f);
        scene.world.setKineticSpeed(crushWheelSelection, -128.0f);
        scene.addKeyframe();
        ElementLink sheep = scene.world.createEntity(w -> {
            Sheep entity = (Sheep)EntityType.f_20520_.m_20615_(w);
            entity.m_29855_(DyeColor.PINK);
            Vec3 p = util.vector.topOf(util.grid.at(4, 3, 2));
            entity.m_6034_(p.f_82479_, p.f_82480_, p.f_82481_);
            entity.f_19854_ = p.f_82479_;
            entity.f_19855_ = p.f_82480_;
            entity.f_19856_ = p.f_82481_;
            WalkAnimationState animation = entity.f_267362_;
            animation.m_267566_(-animation.m_267756_(), 1.0f);
            animation.m_267771_(1.0f);
            entity.f_19859_ = 210.0f;
            entity.m_146922_(210.0f);
            entity.f_20886_ = 210.0f;
            entity.f_20885_ = 210.0f;
            return entity;
        });
        scene.idle(10);
        scene.world.modifyEntity(sheep, Entity::m_146870_);
        scene.effects.emitParticles(util.vector.topOf(util.grid.at(4, 3, 2)).m_82520_(0.0, -0.25, 0.0), EmitParticlesInstruction.Emitter.withinBlockSpace((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50504_.m_49966_()), (Vec3)util.vector.centerOf(0, 0, 0)), 25.0f, 1);
        ElementLink itemEntity = scene.world.createItemEntity(util.vector.blockSurface(util.grid.at(4, 2, 2), Direction.DOWN, 0.0f), util.vector.of(0.0, 0.0, 0.0), new ItemStack((ItemLike)Items.f_41876_));
        ElementLink itemEntity2 = scene.world.createItemEntity(util.vector.blockSurface(util.grid.at(4, 2, 2), Direction.DOWN, 0.0f), util.vector.of(0.0, 0.0, 0.0), new ItemStack((ItemLike)AllItems.EXP_NUGGET.get()));
        scene.idle(13);
        scene.world.modifyEntity(itemEntity, Entity::m_146870_);
        scene.world.createItemOnBelt(util.grid.at(4, 1, 2), Direction.DOWN, new ItemStack((ItemLike)Items.f_41876_));
        scene.idle(3);
        scene.world.modifyEntity(itemEntity2, Entity::m_146870_);
        scene.world.createItemOnBelt(util.grid.at(4, 1, 2), Direction.DOWN, new ItemStack((ItemLike)AllItems.EXP_NUGGET.get()));
        scene.idle(10);
        scene.overlay.showText(60).text("The Crushing Wheel has a chance of dropping a very small amount of experience nugget when it kills a creature.").placeNearTarget().pointAt(util.vector.centerOf(4, 3, 2));
        scene.idle(60);
    }

    public static void handleExperienceBottle(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("experience_bottle", "Dealing with Bottle o' Enchanting");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.68f);
        scene.world.setKineticSpeed(util.select.everywhere(), 16.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 5, 4, 5), Direction.DOWN);
        scene.world.propagatePipeChange(util.grid.at(3, 1, 1));
        scene.world.propagatePipeChange(util.grid.at(2, 3, 3));
        ItemStack item = Items.f_42612_.m_7968_();
        item.m_41764_(64);
        BlockPos beltStart = util.grid.at(4, 1, 0);
        ElementLink itemEntity = scene.world.createItemEntity(util.vector.centerOf(4, 5, 0), util.vector.of(0.0, 0.0, 0.0), item);
        scene.idle(13);
        scene.world.modifyEntity(itemEntity, Entity::m_146870_);
        scene.world.createItemOnBelt(beltStart, Direction.DOWN, item);
        scene.idle(10);
        scene.overlay.showText(80).text("Bottle o' Enchanting can be emptied at Item Drain.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(2, 1, 0));
        scene.idle(80);
        scene.overlay.showText(80).text("Bottle o' Enchanting also can be manufactured by Spout as well.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(0, 3, 3));
        ItemStack item2 = Items.f_42590_.m_7968_();
        BlockPos beltStart2 = util.grid.at(0, 1, 1);
        ElementLink itemEntity2 = scene.world.createItemEntity(util.vector.centerOf(0, 5, 1), util.vector.of(0.0, 0.0, 0.0), item2);
        scene.idle(13);
        scene.world.modifyEntity(itemEntity2, Entity::m_146870_);
        ElementLink beltItem = scene.world.createItemOnBelt(beltStart2, Direction.DOWN, item2);
        Selection spoutS = util.select.position(0, 3, 3);
        BlockPos spoutPos = util.grid.at(0, 3, 3);
        scene.idle(60);
        scene.world.stallBeltItem(beltItem, true);
        scene.world.modifyBlockEntityNBT(spoutS, SpoutBlockEntity.class, nbt -> nbt.m_128405_("ProcessingTicks", 20));
        scene.idle(10);
        scene.world.removeItemsFromBelt(spoutPos.m_6625_(2));
        scene.world.createItemOnBelt(spoutPos.m_6625_(2), Direction.UP, Items.f_42612_.m_7968_());
        scene.idle(70);
    }

    public static void copy(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("copy", "Using Printer");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.68f);
        scene.world.setKineticSpeed(util.select.everywhere(), 32.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 6, 3, 6), Direction.DOWN);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 3, 2), Pointing.DOWN).rightClick().withItem(Items.f_42690_.m_7968_()), 40);
        scene.world.modifyBlockEntity(util.grid.at(2, 1, 5), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).m_5613_(), 1000)));
        scene.world.modifyBlockEntity(util.grid.at(2, 3, 2), PrinterBlockEntity.class, be -> be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> tank.fill(new FluidStack(((ExperienceFluid)((Object)((Object)((Object)CeiFluids.EXPERIENCE.get())))).m_5613_(), 3000), IFluidHandler.FluidAction.EXECUTE)));
        scene.overlay.showText(40).text("Liquid Experience is required to duplicate enchanted books.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
        scene.world.modifyBlockEntity(util.grid.at(2, 1, 5), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((HyperExperienceFluid)((Object)((Object)CeiFluids.HYPER_EXPERIENCE.get()))).m_5613_(), 1000)));
        scene.world.modifyBlockEntity(util.grid.at(2, 3, 2), PrinterBlockEntity.class, be -> be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> {
            tank.drain(3000, IFluidHandler.FluidAction.EXECUTE);
            tank.fill(new FluidStack(((HyperExperienceFluid)((Object)((Object)((Object)CeiFluids.HYPER_EXPERIENCE.get())))).m_5613_(), 3000), IFluidHandler.FluidAction.EXECUTE);
        }));
        scene.overlay.showText(40).text("If the enchantment on the enchantment book you are copying has a level that exceeds its maximum level, then you will need Hyper Experience.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
        ItemStack item = Items.f_42517_.m_7968_();
        BlockPos beltStart = util.grid.at(6, 1, 2);
        ElementLink beltItem = scene.world.createItemOnBelt(beltStart, Direction.DOWN, item);
        Selection copier = util.select.position(2, 3, 2);
        BlockPos copierPos = util.grid.at(2, 3, 2);
        scene.idle(60);
        scene.world.stallBeltItem(beltItem, true);
        scene.world.modifyBlockEntityNBT(copier, PrinterBlockEntity.class, nbt -> nbt.m_128405_("ProcessingTicks", 100));
        scene.idle(95);
        scene.world.removeItemsFromBelt(copierPos.m_6625_(2));
        scene.world.createItemOnBelt(copierPos.m_6625_(2), Direction.UP, Items.f_42690_.m_7968_());
        scene.idle(40);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 3, 2), Pointing.DOWN).rightClick().withItem(Items.f_42615_.m_7968_()), 40);
        scene.world.modifyBlockEntity(util.grid.at(2, 1, 5), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((ForgeFlowingFluid.Flowing)CeiFluids.INK.get()).m_5613_(), 1000)));
        scene.world.modifyBlockEntity(util.grid.at(2, 3, 2), PrinterBlockEntity.class, be -> be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> {
            tank.drain(3000, IFluidHandler.FluidAction.EXECUTE);
            tank.fill(new FluidStack(((ForgeFlowingFluid.Flowing)CeiFluids.INK.get()).m_5613_(), 3000), IFluidHandler.FluidAction.EXECUTE);
        }));
        scene.overlay.showText(40).text("Ink is required to duplicate written books.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
        item = Items.f_42517_.m_7968_();
        beltStart = util.grid.at(6, 1, 2);
        beltItem = scene.world.createItemOnBelt(beltStart, Direction.DOWN, item);
        copier = util.select.position(2, 3, 2);
        copierPos = util.grid.at(2, 3, 2);
        scene.idle(60);
        scene.world.stallBeltItem(beltItem, true);
        scene.world.modifyBlockEntityNBT(copier, PrinterBlockEntity.class, nbt -> nbt.m_128405_("ProcessingTicks", 100));
        scene.idle(95);
        scene.world.removeItemsFromBelt(copierPos.m_6625_(2));
        scene.world.createItemOnBelt(copierPos.m_6625_(2), Direction.UP, Items.f_42615_.m_7968_());
        scene.idle(50);
        scene.world.modifyBlockEntity(util.grid.at(2, 1, 5), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).m_5613_(), 1000)));
        scene.world.modifyBlockEntity(util.grid.at(2, 3, 2), PrinterBlockEntity.class, be -> be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> {
            tank.drain(3000, IFluidHandler.FluidAction.EXECUTE);
            tank.fill(new FluidStack(((ExperienceFluid)((Object)((Object)((Object)CeiFluids.EXPERIENCE.get())))).m_5613_(), 3000), IFluidHandler.FluidAction.EXECUTE);
        }));
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 3, 2), Pointing.DOWN).rightClick().withItem(Items.f_42656_.m_7968_()), 40);
        scene.overlay.showText(40).text("Name Tag and Train Schedule can also be copied.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
        item = Items.f_42388_.m_7968_();
        beltStart = util.grid.at(6, 1, 2);
        beltItem = scene.world.createItemOnBelt(beltStart, Direction.DOWN, item);
        copier = util.select.position(2, 3, 2);
        copierPos = util.grid.at(2, 3, 2);
        scene.idle(60);
        scene.world.stallBeltItem(beltItem, true);
        scene.world.modifyBlockEntityNBT(copier, PrinterBlockEntity.class, nbt -> nbt.m_128405_("ProcessingTicks", 100));
        scene.idle(95);
        scene.world.removeItemsFromBelt(copierPos.m_6625_(2));
        scene.world.createItemOnBelt(copierPos.m_6625_(2), Direction.UP, Items.f_42388_.m_7968_());
        scene.overlay.showText(40).text("If you set the name tag as the print target, you can use the printer to name the item.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
    }

    public static void leak(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("leak", "Oh no! It's leaking!");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.5f);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 3, 4, 4, 4), Direction.DOWN);
        scene.idle(5);
        scene.world.modifyBlockEntity(util.grid.at(3, 1, 3), FluidTankBlockEntity.class, be -> ((FluidTank)be.getTankInventory()).setFluid(new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).m_5613_(), 48000)));
        scene.overlay.showText(40).text("I have a tank full of experience").placeNearTarget().pointAt(util.vector.topOf(2, 4, 2));
        scene.idle(50);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 4, 2), Direction.DOWN);
        scene.world.showSection(util.select.fromTo(0, 1, 3, 2, 4, 4), Direction.DOWN);
        scene.idle(5);
        scene.overlay.showText(40).text("I have an open-ended pipe").placeNearTarget().pointAt(util.vector.topOf(3, 4, 0));
        scene.idle(50);
        scene.world.setKineticSpeed(util.select.everywhere(), 128.0f);
        scene.world.propagatePipeChange(util.grid.at(0, 1, 3));
        scene.world.propagatePipeChange(util.grid.at(3, 1, 0));
        scene.world.propagatePipeChange(util.grid.at(3, 4, 0));
        scene.idle(80);
        scene.overlay.showText(40).text("Ugh!").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector.topOf(3, 4, 0));
        scene.overlay.showOutline(PonderPalette.RED, new Object(), util.select.position(3, 4, 0), 40);
        scene.idle(50);
        scene.overlay.showText(40).text("Don't worry, the leaked liquid experience will turn into experience orbs. Players can also stand at the opening of the pipe to absorb experience.").colored(PonderPalette.GREEN).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(3, 4, 0));
        scene.overlay.showOutline(PonderPalette.GREEN, new Object(), util.select.position(3, 4, 0), 40);
        scene.idle(50);
    }

    private static void enchantItem(ItemStack itemStack, Enchantment enchantment, int level) {
        Map m = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        m.put(enchantment, level);
        EnchantmentHelper.m_44865_((Map)m, (ItemStack)itemStack);
    }

    private static void enchantRandomly(ItemStack itemStack) {
        if (itemStack.m_150930_(Items.f_42690_)) {
            EnchantmentScenes.enchantItem(itemStack, Enchantments.f_44962_, 1);
        } else {
            EnchantmentHelper.m_220292_((RandomSource)RandomSource.m_216327_(), (ItemStack)itemStack, (int)30, (boolean)true);
        }
    }

    private static ItemStack enchantingGuide(Enchantment enchantment, int level) {
        ItemStack ret = CeiItems.ENCHANTING_GUIDE.asStack();
        ret.m_41784_().m_128405_("index", 0);
        ItemStack book = Items.f_42690_.m_7968_();
        EnchantmentHelper.m_44865_(Map.of(enchantment, level), (ItemStack)book);
        ret.m_41784_().m_128365_("target", (Tag)book.serializeNBT());
        return ret;
    }
}

