/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.network.PacketBase;
import shetiphian.multibeds.client.misc.EmbroideryData;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.network.NetworkHandler;

public class PacketShareTag
extends PacketBase {
    private final String name;
    private final boolean toAll;
    private final Embroidery embroidery;

    public PacketShareTag(String name, Embroidery embroidery, boolean toAll) {
        this.name = name;
        this.embroidery = embroidery;
        this.toAll = toAll;
    }

    public static void writeData(PacketShareTag packet, FriendlyByteBuf buffer) {
        PacketShareTag.writeString((FriendlyByteBuf)buffer, (String)packet.name);
        packet.embroidery.writeToBuffer(buffer);
        buffer.writeBoolean(packet.toAll);
    }

    public static PacketShareTag readData(FriendlyByteBuf buffer) {
        return new PacketShareTag(PacketShareTag.readString((FriendlyByteBuf)buffer), Embroidery.fromBuffer(buffer), buffer.readBoolean());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClientSide(Player player) {
        EmbroideryData.addSessionItem(this.name, this.embroidery);
    }

    public void handleServerSide(Player player) {
        if (this.toAll) {
            NetworkHandler.sendToAll(new PacketShareTag(this.name, this.embroidery, false));
        } else if (player != null) {
            NetworkHandler.sendToAllAround(new PacketShareTag(this.name, this.embroidery, false), (Entity)player, 128.0);
        }
    }
}

