/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.Function;
import shetiphian.core.common.network.PacketBase;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.misc.EnumSpreadArt;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class PacketEmbroidery
extends PacketBase {
    private final BlockPos pos;
    private final EnumSpreadArt art;
    private final Embroidery embroidery;

    public PacketEmbroidery(BlockPos pos, EnumSpreadArt art) {
        this(pos, art, null);
    }

    public PacketEmbroidery(BlockPos pos, EnumSpreadArt art, Embroidery embroidery) {
        this.pos = pos;
        this.art = art;
        this.embroidery = art != EnumSpreadArt.CUSTOM ? null : embroidery;
    }

    public static void writeData(PacketEmbroidery packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.m_130130_(packet.art.ordinal());
        if (packet.art == EnumSpreadArt.CUSTOM && packet.embroidery != null) {
            packet.embroidery.writeToBuffer(buffer);
        }
    }

    public static PacketEmbroidery readData(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        EnumSpreadArt art = EnumSpreadArt.byIndex(buffer.m_130242_());
        if (art == EnumSpreadArt.CUSTOM) {
            return new PacketEmbroidery(pos, art, Embroidery.fromBuffer(buffer));
        }
        return new PacketEmbroidery(pos, art);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClientSide(Player player) {
    }

    public void handleServerSide(Player player) {
        TileEntityMultiBed[] tiles;
        if (player != null && (tiles = BlockMultiBedBase.getTiles((BlockGetter)player.m_9236_(), this.pos)) != null) {
            boolean isMirrored;
            ItemStack blanket = tiles[0].hasBlanket() ? tiles[0].getBlanketItem().m_41777_() : tiles[1].getBlanketItem().m_41777_();
            boolean bl = isMirrored = tiles[0].hasBlanket() ? tiles[0].isMirrored() : tiles[1].isMirrored();
            if (!blanket.m_41619_()) {
                ItemEmbroideryThread.setArtwork(blanket, this.art, this.embroidery);
                if (tiles[0].setBlanketItem(blanket, isMirrored)) {
                    tiles[1].setBlanketItem(tiles[0].getBlanketItem(), tiles[0].isMirrored());
                }
                Function.syncTile((BlockEntity)tiles[0]);
                Function.syncTile((BlockEntity)tiles[1]);
                if (this.art != EnumSpreadArt.NONE) {
                    player.m_150109_().m_36056_().m_41622_(1, (LivingEntity)player, entity -> {});
                }
            }
        }
    }
}

