/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;

public class BannerLootHandler
extends LootModifier {
    public static final Codec<BannerLootHandler> CODEC = RecordCodecBuilder.create(inst -> BannerLootHandler.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, BannerLootHandler::new));

    protected BannerLootHandler(LootItemCondition[] conditions) {
        super(conditions);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        CompoundTag tileNBT;
        BlockEntity tile = (BlockEntity)context.m_78953_(LootContextParams.f_81462_);
        if (tile != null && (tileNBT = tile.getPersistentData()).m_128441_("multibeds")) {
            CompoundTag embroidery = tileNBT.m_128469_("multibeds");
            for (ItemStack stack : generatedLoot) {
                if (stack.m_41619_() || !(stack.m_41720_() instanceof BannerItem)) continue;
                ItemEmbroideryThread.writeEmbroideryData(stack, embroidery);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)Roster.LootModifiers.BANNER_EMBROIDERY.get();
    }
}

