/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

public interface TagData {
    @Nonnull
    public CompoundTag getTag(@Nonnull ItemStack var1);

    public String getMirrorKey();

    public String getBlanketKey();

    public String getPillowKey();

    public String getSheetKey();

    default public boolean getMirrored(ItemStack stack) {
        CompoundTag nbtTag;
        if (!stack.m_41619_() && (nbtTag = this.getTag(stack)).m_128441_(this.getMirrorKey())) {
            return nbtTag.m_128471_(this.getMirrorKey());
        }
        return false;
    }

    default public boolean hasArt(ItemStack stack) {
        ItemStack blanket = this.getBlanket(stack);
        return !blanket.m_41619_() && ItemEmbroideryThread.getArtwork(blanket) != EnumSpreadArt.NONE;
    }

    default public ItemStack getArt(ItemStack stack) {
        ItemStack blanket = this.getBlanket(stack);
        return !blanket.m_41619_() && ItemEmbroideryThread.getArtwork(blanket) != EnumSpreadArt.NONE ? blanket : ItemStack.f_41583_;
    }

    default public boolean hasBlanket(ItemStack stack) {
        return !stack.m_41619_() && this.getTag(stack).m_128441_(this.getBlanketKey());
    }

    default public ItemStack getBlanket(ItemStack stack) {
        CompoundTag nbtTag;
        if (!stack.m_41619_() && (nbtTag = this.getTag(stack)).m_128441_(this.getBlanketKey())) {
            return ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_(this.getBlanketKey()));
        }
        return ItemStack.f_41583_;
    }

    default public boolean hasPillow(ItemStack stack) {
        return !stack.m_41619_() && this.getTag(stack).m_128441_(this.getPillowKey());
    }

    default public ItemStack getPillow(ItemStack stack) {
        CompoundTag nbtTag;
        if (!stack.m_41619_() && (nbtTag = this.getTag(stack)).m_128441_(this.getPillowKey())) {
            return ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_(this.getPillowKey()));
        }
        return ItemStack.f_41583_;
    }

    default public boolean hasSheet(ItemStack stack) {
        return !stack.m_41619_() && this.getTag(stack).m_128441_(this.getSheetKey());
    }

    default public ItemStack getSheet(ItemStack stack) {
        CompoundTag nbtTag;
        if (!stack.m_41619_() && (nbtTag = this.getTag(stack)).m_128441_(this.getSheetKey())) {
            return ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_(this.getSheetKey()));
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void addInformation(ItemStack stack, List<Component> tooltip) {
        ItemStack sheet;
        ItemStack pillow;
        DyeColor color;
        if (this.hasBlanket(stack)) {
            ItemStack blanket = this.getBlanket(stack);
            if (blanket.m_41720_() instanceof ItemBlanket) {
                color = ((ItemBlanket)blanket.m_41720_()).getColor(blanket);
                String pattern = ItemBlanket.getPatternName(blanket);
                if (pattern.equalsIgnoreCase("plain")) {
                    tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7o + ").m_7220_((Component)Component.m_237115_((String)("color." + color.m_41065_()))).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"item.multibeds.blanket")));
                } else {
                    tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7o + ").m_7220_((Component)Component.m_237115_((String)("color." + color.m_41065_()))).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)("misc.multibeds.pattern." + pattern))).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"item.multibeds.blanket")));
                }
            } else if (blanket.m_41720_() instanceof BannerItem) {
                tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7o + ").m_7220_(blanket.m_41611_()));
            }
            EnumSpreadArt art = ItemEmbroideryThread.getArtwork(blanket);
            if (art != EnumSpreadArt.NONE) {
                tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7o * ").m_7220_((Component)Component.m_237115_((String)"misc.multibeds.art")).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)("misc.multibeds.art." + art.m_7912_()))));
            }
        }
        if (this.hasPillow(stack) && (pillow = this.getPillow(stack)).m_41720_() instanceof ItemBedCustomization) {
            color = ((ItemBedCustomization)pillow.m_41720_()).getColor(pillow);
            tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7o + ").m_7220_((Component)Component.m_237115_((String)("color." + color.m_41065_()))).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"item.multibeds.pillow")));
        }
        if (this.hasSheet(stack) && (sheet = this.getSheet(stack)).m_41720_() instanceof ItemBedCustomization) {
            color = ((ItemBedCustomization)sheet.m_41720_()).getColor(sheet);
            tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7o + ").m_7220_((Component)Component.m_237115_((String)("color." + color.m_41065_()))).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"item.multibeds.sheet")));
        }
    }
}

