/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.multibeds.common.item.ItemBedCustomization;

public class ItemPillowSheet
extends ItemBedCustomization
implements ITabFiller,
IRGB16_Item {
    public ItemPillowSheet(Item.Properties properties, ItemBedCustomization.EnumType type) {
        super(properties, DyeColor.WHITE, type);
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (DyeColor color : DyeColor.values()) {
            entries.m_246342_(RGB16StackHelper.setRGB16((ItemStack)new ItemStack((ItemLike)this), (String)color.m_41065_()));
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        super.m_7836_(stack, world, player);
        if (RGB16StackHelper.getRGB16((ItemStack)stack) == null) {
            RGB16StackHelper.setRGB16((ItemStack)stack, (short)this.getStartingIndex(stack));
        }
    }

    @Override
    public DyeColor getColor(ItemStack stack) {
        return DyeColor.m_41053_((int)RGB16StackHelper.readSimpleColorTag((ItemStack)stack));
    }

    public int getRenderColor(ItemStack stack) {
        if (!stack.m_41619_()) {
            RGB16 rgb16 = RGB16StackHelper.getRGB16((ItemStack)stack);
            if (rgb16 != null) {
                return rgb16.getColor();
            }
            return this.getColor(stack).m_41070_();
        }
        return -1;
    }

    @Override
    public int getColorFor(IColored.Data data, int index) {
        if (!data.stack.m_41619_()) {
            return this.getRenderColor(data.stack);
        }
        return super.getColorFor(data, index);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag advancedTooltips) {
        tooltip.add((Component)Component.m_237113_((String)RGB16Helper.getTooltip((short)this.getRGB16(stack))));
        super.m_7373_(stack, worldIn, tooltip, advancedTooltips);
    }

    public boolean enableDyeRecipe(ItemStack stack) {
        return true;
    }

    public boolean dyeUseChance(ItemStack stack) {
        return true;
    }

    public double getDyeUseChance(ItemStack result, ItemStack dye, int dyeCounter) {
        if (result.m_41720_() == this && RGB16StackHelper.getRGB16Index((ItemStack)result) == this.getStartingIndex(result)) {
            return 1.0;
        }
        return Math.max(0.0, 1.0 - 0.15 * (double)dyeCounter);
    }
}

