/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.ITabFiller;
import shetiphian.multibeds.client.render.RenderRegistry;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

public class ItemBlanket
extends ItemBedCustomization
implements ITabFiller {
    public static final Pair<EnumBlanket, EnumSpreadArt> NO_DATA = Pair.of((Object)((Object)EnumBlanket.NONE), (Object)((Object)EnumSpreadArt.NONE));

    public ItemBlanket(Item.Properties properties, DyeColor color) {
        super(properties, color, ItemBedCustomization.EnumType.BLANKET);
        this.doLater();
    }

    @Override
    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            RenderRegistry.COLORIZE.add((Object)this);
            RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)((Object)this), (Object)"pattern", (stack, world, entity, number) -> ItemBlanket.getBlanket(stack).getPattern().ordinal()));
        });
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (EnumBlanket.Pattern pattern : EnumBlanket.Pattern.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            if (pattern != EnumBlanket.Pattern.PLAIN) {
                CompoundTag tag = stack.m_41784_();
                tag.m_128359_("pattern", pattern.m_7912_());
            }
            entries.m_246342_(stack);
        }
    }

    public static String getPatternName(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("pattern")) {
            return tag.m_128461_("pattern");
        }
        return "plain";
    }

    public static void setPatternName(ItemStack stack, EnumBlanket.Pattern pattern) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("pattern", pattern.m_7912_());
    }

    private static String getBlanketName(ItemStack stack) {
        return ItemBlanket.getPatternName(stack) + "_" + (stack.m_41720_() instanceof ItemBlanket ? ((ItemBlanket)stack.m_41720_()).getColor(stack).m_41065_() : "red");
    }

    public static EnumBlanket getBlanket(ItemStack stack) {
        EnumBlanket blanket = EnumBlanket.byName(ItemBlanket.getBlanketName(stack));
        return blanket != EnumBlanket.NONE ? blanket : EnumBlanket.PLAIN_RED;
    }

    public static Pair<EnumBlanket, EnumSpreadArt> getBlanketData(ItemStack stack) {
        if (stack.m_41619_()) {
            return NO_DATA;
        }
        if (stack.m_41720_() instanceof BannerItem) {
            return Pair.of((Object)((Object)EnumBlanket.BANNER), (Object)((Object)ItemEmbroideryThread.getArtwork(stack)));
        }
        return Pair.of((Object)((Object)EnumBlanket.byName(ItemBlanket.getBlanketName(stack))), (Object)((Object)ItemEmbroideryThread.getArtwork(stack)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        EnumSpreadArt art;
        super.m_7373_(stack, world, tooltip, advancedTooltips);
        if (!ItemBlanket.getPatternName(stack).equalsIgnoreCase("plain")) {
            tooltip.add((Component)Component.m_237115_((String)"misc.multibeds.pattern").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)("misc.multibeds.pattern." + ItemBlanket.getPatternName(stack)))));
        }
        if ((art = ItemEmbroideryThread.getArtwork(stack)) != EnumSpreadArt.NONE) {
            tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7o * ").m_7220_((Component)Component.m_237115_((String)"misc.multibeds.art")).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)("misc.multibeds.art." + art.toString()))));
        }
    }
}

