/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.render.RenderRegistry;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.item.ItemPillowSheet;
import shetiphian.multibeds.common.item.TagData;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class ItemBeddingPackage
extends Item
implements IColored,
TagData {
    public ItemBeddingPackage(Item.Properties properties) {
        super(properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            RenderRegistry.COLORIZE.add(this);
            RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)this, (Object)"fill", (stack, world, entity, number) -> (this.hasArt(stack) ? 1 : 0) + (this.hasBlanket(stack) ? 2 : 0) + (this.hasPillow(stack) ? 4 : 0) + (this.hasSheet(stack) ? 8 : 0)));
        });
    }

    public InteractionResult m_6225_(UseOnContext data) {
        Level world = data.m_43725_();
        BlockPos pos = data.m_8083_();
        ItemStack dataItem = data.m_43722_();
        if (world.m_8055_(pos).m_60734_() instanceof BlockMultiBedBase && dataItem.m_41720_() instanceof ItemBeddingPackage) {
            TileEntityMultiBed[] bedTiles;
            Player player = data.m_43723_();
            Direction face = data.m_43719_();
            BlockPos[] bedBlocks = BlockMultiBedBase.getBlocks((BlockGetter)world, pos);
            if ((player == null || player.m_36204_(bedBlocks[0], face, dataItem) && player.m_36204_(bedBlocks[1], face, dataItem)) && (bedTiles = BlockMultiBedBase.getTiles((BlockGetter)world, pos)) != null) {
                ItemStack bedding = dataItem.m_41620_(1);
                if (!world.m_5776_()) {
                    this.setTagFrom(bedding, bedTiles, true);
                    if (player != null) {
                        if (!player.m_150110_().f_35937_) {
                            Function.giveItem((Player)player, (ItemStack)bedding, (SoundEvent)(dataItem.m_41613_() > 0 ? SoundEvents.f_12019_ : null));
                        } else {
                            if (dataItem.m_41613_() < 1) {
                                dataItem.m_41764_(1);
                            }
                            boolean give = true;
                            NonNullList inventory = player.m_150109_().f_35974_;
                            for (ItemStack invStack : inventory) {
                                if (!Function.areItemStacksEqual((ItemStack)invStack, (ItemStack)bedding)) continue;
                                give = false;
                                break;
                            }
                            if (give) {
                                Function.giveItem((Player)player, (ItemStack)bedding);
                            }
                        }
                    }
                }
                SoundType soundtype = SoundType.f_56745_;
                world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void setTagFrom(ItemStack bedding, TileEntityMultiBed[] bedTiles, boolean alterBed) {
        if (bedTiles != null) {
            boolean mirror = false;
            ItemStack blanket = ItemStack.f_41583_;
            ItemStack pillow = ItemStack.f_41583_;
            ItemStack sheet = ItemStack.f_41583_;
            for (int half = 0; half < 2; ++half) {
                if (blanket.m_41619_() && bedTiles[half].hasBlanket()) {
                    blanket = bedTiles[half].getBlanketItem();
                    mirror = bedTiles[half].isMirrored();
                }
                if (pillow.m_41619_() && bedTiles[half].hasPillow()) {
                    pillow = bedTiles[half].getPillowItem();
                }
                if (!sheet.m_41619_() || !bedTiles[half].hasSheet()) continue;
                sheet = bedTiles[half].getSheetItem();
            }
            if (alterBed) {
                if (bedTiles[0].setBlanketItem(this.getBlanket(bedding), this.getMirrored(bedding))) {
                    bedTiles[1].setBlanketItem(bedTiles[0].getBlanketItem(), bedTiles[0].isMirrored());
                } else {
                    bedTiles[0].removeBlanket();
                    bedTiles[1].removeBlanket();
                }
                if (bedTiles[0].setPillowItem(this.getPillow(bedding))) {
                    bedTiles[1].setPillowItem(bedTiles[0].getPillowItem());
                } else {
                    bedTiles[0].removePillow();
                    bedTiles[1].removePillow();
                }
                if (bedTiles[0].setSheetItem(this.getSheet(bedding))) {
                    bedTiles[1].setSheetItem(bedTiles[0].getSheetItem());
                } else {
                    bedTiles[0].removeSheet();
                    bedTiles[1].removeSheet();
                }
                Function.syncTile((BlockEntity)bedTiles[0]);
                Function.syncTile((BlockEntity)bedTiles[1]);
            }
            CompoundTag tag = this.getTag(bedding);
            tag.m_128473_("mirror");
            tag.m_128473_("blanket");
            tag.m_128473_("pillow");
            tag.m_128473_("sheet");
            this.setMirrored(bedding, mirror);
            this.setBlanket(bedding, blanket.m_41777_());
            this.setPillow(bedding, pillow.m_41777_());
            this.setSheet(bedding, sheet.m_41777_());
        }
    }

    public static ItemStack createFor(TileEntityMultiBed[] bedTiles) {
        ItemStack bedding;
        if (Roster.Items.BEDDING_PACKAGE != null && bedTiles != null && !(bedding = new ItemStack((ItemLike)Roster.Items.BEDDING_PACKAGE.get())).m_41619_() && bedding.m_41720_() instanceof ItemBeddingPackage) {
            ((ItemBeddingPackage)bedding.m_41720_()).setTagFrom(bedding, bedTiles, false);
            return bedding;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public CompoundTag getTag(ItemStack stack) {
        return stack.m_41784_();
    }

    @Override
    public String getMirrorKey() {
        return "mirror";
    }

    @Override
    public String getBlanketKey() {
        return "blanket";
    }

    @Override
    public String getPillowKey() {
        return "pillow";
    }

    @Override
    public String getSheetKey() {
        return "sheet";
    }

    private void setMirrored(ItemStack bedding, boolean mirrored) {
        if (this.hasBlanket(bedding)) {
            this.getTag(bedding).m_128379_(this.getMirrorKey(), mirrored);
        }
    }

    private void setBlanket(ItemStack bedding, ItemStack blanket) {
        if (!bedding.m_41619_() && !blanket.m_41619_()) {
            CompoundTag compoundNBT = new CompoundTag();
            blanket.m_41739_(compoundNBT);
            this.getTag(bedding).m_128365_(this.getBlanketKey(), (Tag)compoundNBT);
        }
    }

    private void setPillow(ItemStack bedding, ItemStack pillow) {
        if (!bedding.m_41619_() && !pillow.m_41619_()) {
            CompoundTag compoundNBT = new CompoundTag();
            pillow.m_41739_(compoundNBT);
            this.getTag(bedding).m_128365_(this.getPillowKey(), (Tag)compoundNBT);
        }
    }

    private void setSheet(ItemStack bedding, ItemStack sheet) {
        if (!bedding.m_41619_() && !sheet.m_41619_()) {
            CompoundTag compoundNBT = new CompoundTag();
            sheet.m_41739_(compoundNBT);
            this.getTag(bedding).m_128365_(this.getSheetKey(), (Tag)compoundNBT);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        ItemStack stack;
        if (index > 0 && index < 5 && !(stack = this.getColorStack(data.stack, index)).m_41619_()) {
            if (index == 4) {
                return ItemEmbroideryThread.getArtwork(stack).getColor();
            }
            Item item = stack.m_41720_();
            if (item instanceof BannerItem) {
                return ((BannerItem)item).m_40545_().m_41070_();
            }
            if (item instanceof ItemPillowSheet) {
                return ((ItemPillowSheet)item).getRenderColor(stack);
            }
            if (item instanceof ItemBedCustomization) {
                return ((ItemBedCustomization)item).getColor(stack).m_41070_();
            }
        }
        return 0xFFFFFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ItemStack getColorStack(ItemStack bedding, int index) {
        if (!bedding.m_41619_() && bedding.m_41720_() instanceof ItemBeddingPackage) {
            switch (index) {
                case 1: {
                    return this.getSheet(bedding);
                }
                case 2: {
                    return this.getBlanket(bedding);
                }
                case 3: {
                    return this.getPillow(bedding);
                }
                case 4: {
                    return this.getArt(bedding);
                }
            }
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, world, tooltip, advancedTooltips);
        this.addInformation(stack, tooltip);
    }
}

