/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.crafting;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import shetiphian.core.common.Function;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.item.ItemBlockLadder;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;

public class RecipeUncraft
extends CustomRecipe {
    public static final byte LADDER_COUNT = 4;

    public RecipeUncraft(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        for (int index = 0; index < inventory.m_6643_(); ++index) {
            ItemStack stack = inventory.m_8020_(index);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof ItemBlockMultiBed) {
                return this.handleBeds(inventory, index) > 0;
            }
            if (item instanceof ItemBlockLadder) {
                return !this.handleLadders(inventory, index).m_41619_();
            }
            return false;
        }
        return false;
    }

    private int handleBeds(CraftingContainer inventory, int start) {
        int counter = 0;
        for (int index = start; index < inventory.m_6643_(); ++index) {
            ItemBlockMultiBed bed;
            ItemStack stack = inventory.m_8020_(index);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof ItemBlockMultiBed && !(bed = (ItemBlockMultiBed)item).hasBedding(stack)) {
                counter += stack.m_41613_();
                continue;
            }
            return 0;
        }
        return counter > 0 && counter <= ((Item)Roster.Items.BED_KIT.get()).m_41459_() ? counter : 0;
    }

    private ItemStack handleLadders(CraftingContainer inventory, int start) {
        ItemStack material = ItemStack.f_41583_;
        int counter = 0;
        for (int index = start; index < inventory.m_6643_(); ++index) {
            ItemStack stack = inventory.m_8020_(index);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemBlockLadder) {
                ItemStack texture = ItemBlockLadder.getTextureStack(stack);
                if (material.m_41619_() || Function.areItemStacksEqual((ItemStack)material, (ItemStack)texture)) {
                    material = texture;
                    counter += stack.m_41613_();
                    continue;
                }
            }
            return ItemStack.f_41583_;
        }
        return (counter /= 4) > 0 ? material.m_255036_(Math.min(counter, material.m_41741_())) : ItemStack.f_41583_;
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess manager) {
        for (int index = 0; index < inventory.m_6643_(); ++index) {
            ItemStack stack = inventory.m_8020_(index);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof ItemBlockMultiBed) {
                int count = this.handleBeds(inventory, index);
                if (count <= 0) continue;
                return new ItemStack((ItemLike)Roster.Items.BED_KIT.get(), count);
            }
            if (!(item instanceof ItemBlockLadder)) continue;
            return this.handleLadders(inventory, index);
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        ItemStack material = this.handleLadders(inventory, 0);
        int used = material != null ? material.m_41613_() * 4 : 0;
        NonNullList list = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int index = 0; index < list.size(); ++index) {
            ItemStack stack = inventory.m_8020_(index);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof ItemBlockMultiBed) {
                inventory.m_8016_(index);
                list.set(index, (Object)ItemBlockMultiBed.getTextureStack(stack).m_255036_(stack.m_41613_()));
                continue;
            }
            if (!(item instanceof ItemBlockLadder)) continue;
            inventory.m_8016_(index);
            if ((used -= stack.m_41613_()) >= 0) continue;
            list.set(index, (Object)stack.m_255036_(-used));
            used = 0;
        }
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 0;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Roster.RecipeSerializers.UNCRAFT.get();
    }
}

