/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.block;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.HitBoxData;

class HitBoxHelper {
    private final Table<String, Direction, VoxelShape> HITBOXES = HashBasedTable.create();

    HitBoxHelper() {
    }

    Table<String, Direction, VoxelShape> get() {
        return this.HITBOXES;
    }

    private void addHitBoxData(String key, double[][] cordsets) {
        Map map = HitBoxData.build((double[][])cordsets, (boolean)false);
        map.forEach((direction, shape) -> this.HITBOXES.put((Object)key, direction, (Object)(direction.m_122434_() != Direction.Axis.Y ? shape : Shapes.m_83040_())));
    }

    HitBoxHelper loadLadderBoxes() {
        this.addHitBoxData("ladder_top", new double[][]{{2.0, 0.0, 0.0, 4.0, 16.0, 2.0}, {2.0, 0.0, 2.0, 4.0, 15.0, 3.0}, {12.0, 0.0, 0.0, 14.0, 16.0, 2.0}, {12.0, 0.0, 2.0, 14.0, 15.0, 3.0}, {4.0, 5.0, 0.0, 12.0, 6.0, 3.0}, {4.0, 13.0, 0.0, 12.0, 14.0, 3.0}});
        this.addHitBoxData("ladder_middle", new double[][]{{2.0, 0.0, 0.0, 4.0, 16.0, 3.0}, {12.0, 0.0, 0.0, 14.0, 16.0, 3.0}, {4.0, 5.0, 0.0, 12.0, 6.0, 3.0}, {4.0, 13.0, 0.0, 12.0, 14.0, 3.0}});
        this.addHitBoxData("ladder_bottom", new double[][]{{2.0, 2.0, 0.0, 4.0, 16.0, 2.0}, {2.0, 3.0, 2.0, 4.0, 16.0, 3.0}, {12.0, 2.0, 0.0, 14.0, 16.0, 2.0}, {12.0, 3.0, 2.0, 14.0, 16.0, 3.0}, {4.0, 5.0, 0.0, 12.0, 6.0, 3.0}, {4.0, 13.0, 0.0, 12.0, 14.0, 3.0}});
        this.addHitBoxData("ladder_single", new double[][]{{2.0, 2.0, 0.0, 4.0, 16.0, 2.0}, {2.0, 3.0, 2.0, 4.0, 15.0, 3.0}, {12.0, 2.0, 0.0, 14.0, 16.0, 2.0}, {12.0, 3.0, 2.0, 14.0, 15.0, 3.0}, {4.0, 5.0, 0.0, 12.0, 6.0, 3.0}, {4.0, 13.0, 0.0, 12.0, 14.0, 3.0}});
        return this;
    }

    HitBoxHelper loadBedBoxes() {
        this.loadBed_Common();
        this.loadBed_Classic();
        this.loadBed_Cot();
        this.loadBed_Modern();
        this.loadBed_Rustic();
        this.loadBed_Vintage();
        return this;
    }

    private void loadBed_Common() {
        this.addHitBoxData("flat_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 2.0, 16.0}});
        this.addHitBoxData("pillow_left", new double[][]{{3.0, 9.0, 2.0, 15.0, 10.0, 7.0}});
        this.addHitBoxData("pillow_middle", new double[][]{{2.0, 9.0, 2.0, 14.0, 10.0, 7.0}});
        this.addHitBoxData("pillow_right", new double[][]{{1.0, 9.0, 2.0, 13.0, 10.0, 7.0}});
        this.addHitBoxData("mattress_left_foot", new double[][]{{1.1, 7.0, 0.0, 16.0, 9.0, 14.9}});
        this.addHitBoxData("mattress_left_head", new double[][]{{1.1, 7.0, 1.1, 16.0, 9.0, 16.0}});
        this.addHitBoxData("mattress_middle_foot", new double[][]{{0.0, 7.0, 0.0, 16.0, 9.0, 14.9}});
        this.addHitBoxData("mattress_middle_head", new double[][]{{0.0, 7.0, 1.1, 16.0, 9.0, 16.0}});
        this.addHitBoxData("mattress_right_foot", new double[][]{{0.0, 7.0, 0.0, 14.9, 9.0, 14.9}});
        this.addHitBoxData("mattress_right_head", new double[][]{{0.0, 7.0, 1.1, 14.9, 9.0, 16.0}});
        this.addHitBoxData("mattress_single_foot", new double[][]{{1.1, 7.0, 0.0, 14.9, 9.0, 14.9}});
        this.addHitBoxData("mattress_single_head", new double[][]{{1.1, 7.0, 1.1, 14.9, 9.0, 16.0}});
        this.addHitBoxData("base_slat_left_foot", new double[][]{{1.0, 5.0, 0.0, 16.0, 7.0, 15.0}, {0.0, 5.0, 0.0, 1.0, 8.0, 15.0}});
        this.addHitBoxData("base_slat_left_head", new double[][]{{1.0, 5.0, 1.0, 16.0, 7.0, 16.0}, {0.0, 5.0, 1.0, 1.0, 8.0, 16.0}});
        this.addHitBoxData("base_slat_middle_foot", new double[][]{{0.0, 5.0, 0.0, 16.0, 7.0, 15.0}});
        this.addHitBoxData("base_slat_middle_head", new double[][]{{0.0, 5.0, 1.0, 16.0, 7.0, 16.0}});
        this.addHitBoxData("base_slat_right_foot", new double[][]{{0.0, 5.0, 0.0, 15.0, 7.0, 15.0}, {15.0, 5.0, 0.0, 16.0, 8.0, 15.0}});
        this.addHitBoxData("base_slat_right_head", new double[][]{{0.0, 5.0, 1.0, 15.0, 7.0, 16.0}, {15.0, 5.0, 1.0, 16.0, 8.0, 16.0}});
        this.addHitBoxData("base_slat_single_foot", new double[][]{{1.0, 5.0, 0.0, 15.0, 7.0, 15.0}, {0.0, 5.0, 0.0, 1.0, 8.0, 15.0}, {15.0, 5.0, 0.0, 16.0, 8.0, 15.0}});
        this.addHitBoxData("base_slat_single_head", new double[][]{{1.0, 5.0, 1.0, 15.0, 7.0, 16.0}, {0.0, 5.0, 1.0, 1.0, 8.0, 16.0}, {15.0, 5.0, 1.0, 16.0, 8.0, 16.0}});
    }

    private void loadBed_Classic() {
        this.addHitBoxData("classic_bunk_bottom_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 16.0, 16.0}, {13.0, 0.0, 15.0, 16.0, 16.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 5.0, 15.0}, {14.0, 0.0, 14.0, 16.0, 5.0, 15.0}, {3.0, 4.0, 15.0, 4.0, 5.0, 16.0}, {12.0, 4.0, 15.0, 13.0, 5.0, 16.0}, {2.0, 5.0, 15.0, 14.0, 12.0, 16.0}, {5.0, 12.0, 15.0, 11.0, 13.0, 16.0}});
        this.addHitBoxData("classic_bunk_bottom_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 16.0, 1.0}, {13.0, 0.0, 0.0, 16.0, 16.0, 1.0}, {0.0, 0.0, 1.0, 2.0, 5.0, 2.0}, {14.0, 0.0, 1.0, 16.0, 5.0, 2.0}, {3.0, 4.0, 0.0, 4.0, 5.0, 1.0}, {12.0, 4.0, 0.0, 13.0, 5.0, 1.0}, {2.0, 5.0, 0.0, 14.0, 15.0, 1.0}, {5.0, 15.0, 0.0, 11.0, 16.0, 1.0}});
        this.addHitBoxData("classic_bunk_middle_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 16.0, 16.0}, {13.0, 0.0, 15.0, 16.0, 16.0, 16.0}, {0.0, 2.0, 14.0, 2.0, 5.0, 15.0}, {14.0, 2.0, 14.0, 16.0, 5.0, 15.0}, {3.0, 4.0, 15.0, 4.0, 5.0, 16.0}, {12.0, 4.0, 15.0, 13.0, 5.0, 16.0}, {2.0, 5.0, 15.0, 14.0, 12.0, 16.0}, {5.0, 12.0, 15.0, 11.0, 13.0, 16.0}});
        this.addHitBoxData("classic_bunk_middle_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 16.0, 1.0}, {13.0, 0.0, 0.0, 16.0, 16.0, 1.0}, {0.0, 2.0, 1.0, 2.0, 5.0, 2.0}, {14.0, 2.0, 1.0, 16.0, 5.0, 2.0}, {3.0, 4.0, 0.0, 4.0, 5.0, 1.0}, {12.0, 4.0, 0.0, 13.0, 5.0, 1.0}, {2.0, 5.0, 0.0, 14.0, 15.0, 1.0}, {5.0, 15.0, 0.0, 11.0, 16.0, 1.0}});
        this.addHitBoxData("classic_bunk_top_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 11.0, 16.0}, {13.0, 0.0, 15.0, 16.0, 11.0, 16.0}, {0.0, 2.0, 14.0, 2.0, 5.0, 15.0}, {14.0, 2.0, 14.0, 16.0, 5.0, 15.0}, {3.0, 4.0, 15.0, 4.0, 5.0, 16.0}, {12.0, 4.0, 15.0, 13.0, 5.0, 16.0}, {2.0, 5.0, 15.0, 14.0, 12.0, 16.0}, {5.0, 12.0, 15.0, 11.0, 13.0, 16.0}});
        this.addHitBoxData("classic_bunk_top_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 14.0, 1.0}, {13.0, 0.0, 0.0, 16.0, 14.0, 1.0}, {0.0, 2.0, 1.0, 2.0, 5.0, 2.0}, {14.0, 2.0, 1.0, 16.0, 5.0, 2.0}, {3.0, 4.0, 0.0, 4.0, 5.0, 1.0}, {12.0, 4.0, 0.0, 13.0, 5.0, 1.0}, {2.0, 5.0, 0.0, 14.0, 15.0, 1.0}, {5.0, 15.0, 0.0, 11.0, 16.0, 1.0}});
        this.addHitBoxData("classic_left_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 11.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 5.0, 15.0}, {3.0, 4.0, 15.0, 4.0, 5.0, 16.0}, {2.0, 5.0, 15.0, 16.0, 12.0, 16.0}, {5.0, 12.0, 15.0, 16.0, 13.0, 16.0}});
        this.addHitBoxData("classic_left_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 14.0, 1.0}, {0.0, 0.0, 1.0, 2.0, 5.0, 2.0}, {3.0, 4.0, 0.0, 4.0, 5.0, 1.0}, {2.0, 5.0, 0.0, 16.0, 15.0, 1.0}, {5.0, 15.0, 0.0, 16.0, 16.0, 1.0}});
        this.addHitBoxData("classic_middle_foot", new double[][]{{6.0, 0.0, 15.0, 10.0, 4.0, 16.0}, {7.0, 0.0, 14.0, 9.0, 6.0, 15.0}, {5.0, 4.0, 15.0, 11.0, 5.0, 16.0}, {0.0, 5.0, 15.0, 16.0, 13.0, 16.0}});
        this.addHitBoxData("classic_middle_head", new double[][]{{6.0, 0.0, 0.0, 10.0, 4.0, 1.0}, {7.0, 0.0, 1.0, 9.0, 6.0, 2.0}, {5.0, 4.0, 0.0, 11.0, 5.0, 1.0}, {0.0, 5.0, 0.0, 16.0, 16.0, 1.0}});
        this.addHitBoxData("classic_right_foot", new double[][]{{13.0, 0.0, 15.0, 16.0, 11.0, 16.0}, {14.0, 0.0, 14.0, 16.0, 5.0, 15.0}, {12.0, 4.0, 15.0, 13.0, 5.0, 16.0}, {0.0, 5.0, 15.0, 14.0, 12.0, 16.0}, {0.0, 12.0, 15.0, 11.0, 13.0, 16.0}});
        this.addHitBoxData("classic_right_head", new double[][]{{13.0, 0.0, 0.0, 16.0, 14.0, 1.0}, {14.0, 0.0, 1.0, 16.0, 5.0, 2.0}, {12.0, 4.0, 0.0, 13.0, 5.0, 1.0}, {0.0, 5.0, 0.0, 14.0, 15.0, 1.0}, {0.0, 15.0, 0.0, 11.0, 16.0, 1.0}});
        this.addHitBoxData("classic_single_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 11.0, 16.0}, {13.0, 0.0, 15.0, 16.0, 11.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 5.0, 15.0}, {14.0, 0.0, 14.0, 16.0, 5.0, 15.0}, {3.0, 4.0, 15.0, 4.0, 5.0, 16.0}, {12.0, 4.0, 15.0, 13.0, 5.0, 16.0}, {2.0, 5.0, 15.0, 14.0, 12.0, 16.0}, {5.0, 12.0, 15.0, 11.0, 13.0, 16.0}});
        this.addHitBoxData("classic_single_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 14.0, 1.0}, {13.0, 0.0, 0.0, 16.0, 14.0, 1.0}, {0.0, 0.0, 1.0, 2.0, 5.0, 2.0}, {14.0, 0.0, 1.0, 16.0, 5.0, 2.0}, {3.0, 4.0, 0.0, 4.0, 5.0, 1.0}, {12.0, 4.0, 0.0, 13.0, 5.0, 1.0}, {2.0, 5.0, 0.0, 14.0, 15.0, 1.0}, {5.0, 15.0, 0.0, 11.0, 16.0, 1.0}});
        this.addHitBoxData("classic_rail_left", new double[][]{{0.0, 8.0, 1.0, 1.0, 13.0, 13.0}, {0.0, 8.0, 13.0, 1.0, 12.0, 15.0}, {0.0, 8.0, 15.0, 1.0, 11.0, 16.0}});
        this.addHitBoxData("classic_rail_right", new double[][]{{15.0, 8.0, 1.0, 16.0, 13.0, 13.0}, {15.0, 8.0, 13.0, 16.0, 12.0, 15.0}, {15.0, 8.0, 15.0, 16.0, 11.0, 16.0}});
    }

    private void loadBed_Cot() {
        this.addHitBoxData("cot_bunk_bottom_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 16.0, 16.0}, {14.0, 0.0, 14.0, 16.0, 16.0, 16.0}});
        this.addHitBoxData("cot_bunk_bottom_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 0.0, 0.0, 2.0, 16.0, 2.0}, {14.0, 0.0, 0.0, 16.0, 16.0, 2.0}});
        this.addHitBoxData("cot_bunk_middle_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 16.0, 16.0}, {14.0, 0.0, 14.0, 16.0, 16.0, 16.0}});
        this.addHitBoxData("cot_bunk_middle_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 0.0, 0.0, 2.0, 16.0, 2.0}, {14.0, 0.0, 0.0, 16.0, 16.0, 2.0}});
        this.addHitBoxData("cot_bunk_top_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 5.0, 16.0}, {14.0, 0.0, 14.0, 16.0, 5.0, 16.0}});
        this.addHitBoxData("cot_bunk_top_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 0.0, 0.0, 2.0, 5.0, 2.0}, {14.0, 0.0, 0.0, 16.0, 5.0, 2.0}});
        this.addHitBoxData("cot_left_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 5.0, 16.0}});
        this.addHitBoxData("cot_left_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 0.0, 0.0, 2.0, 5.0, 2.0}});
        this.addHitBoxData("cot_middle_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {7.0, 0.0, 14.0, 9.0, 7.0, 16.0}});
        this.addHitBoxData("cot_middle_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {7.0, 0.0, 0.0, 9.0, 7.0, 2.0}});
        this.addHitBoxData("cot_right_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {14.0, 0.0, 14.0, 16.0, 5.0, 16.0}});
        this.addHitBoxData("cot_right_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {14.0, 0.0, 0.0, 16.0, 5.0, 2.0}});
        this.addHitBoxData("cot_single_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 5.0, 16.0}, {14.0, 0.0, 14.0, 16.0, 5.0, 16.0}});
        this.addHitBoxData("cot_single_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 0.0, 0.0, 2.0, 5.0, 2.0}, {14.0, 0.0, 0.0, 16.0, 5.0, 2.0}});
    }

    private void loadBed_Modern() {
        this.addHitBoxData("modern_bunk_bottom_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 1.0, 12.0, 1.0, 16.0, 16.0}, {15.0, 1.0, 12.0, 16.0, 16.0, 16.0}, {1.0, 1.0, 12.0, 2.0, 2.0, 16.0}, {14.0, 1.0, 12.0, 15.0, 2.0, 16.0}, {1.0, 0.0, 12.0, 15.0, 1.0, 16.0}});
        this.addHitBoxData("modern_bunk_bottom_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 1.0, 0.0, 1.0, 16.0, 4.0}, {15.0, 1.0, 0.0, 16.0, 16.0, 4.0}, {1.0, 1.0, 0.0, 2.0, 2.0, 4.0}, {14.0, 1.0, 0.0, 15.0, 2.0, 4.0}, {1.0, 0.0, 0.0, 15.0, 1.0, 4.0}, {1.0, 13.0, 0.0, 15.0, 16.0, 1.0}});
        this.addHitBoxData("modern_bunk_middle_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 0.0, 12.0, 1.0, 16.0, 16.0}, {15.0, 0.0, 12.0, 16.0, 16.0, 16.0}});
        this.addHitBoxData("modern_bunk_middle_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 16.0, 4.0}, {15.0, 0.0, 0.0, 16.0, 16.0, 4.0}, {1.0, 13.0, 0.0, 15.0, 16.0, 1.0}});
        this.addHitBoxData("modern_bunk_top_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 0.0, 12.0, 1.0, 5.0, 16.0}, {15.0, 0.0, 12.0, 16.0, 5.0, 16.0}});
        this.addHitBoxData("modern_bunk_top_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 15.0, 4.0}, {15.0, 0.0, 0.0, 16.0, 15.0, 4.0}, {1.0, 14.0, 0.0, 2.0, 15.0, 4.0}, {14.0, 14.0, 0.0, 15.0, 15.0, 4.0}, {1.0, 15.0, 0.0, 15.0, 16.0, 4.0}});
        this.addHitBoxData("modern_left_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 1.0, 12.0, 1.0, 5.0, 16.0}, {1.0, 1.0, 12.0, 2.0, 2.0, 16.0}, {1.0, 0.0, 12.0, 16.0, 1.0, 16.0}});
        this.addHitBoxData("modern_left_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 1.0, 0.0, 1.0, 15.0, 4.0}, {1.0, 1.0, 0.0, 2.0, 2.0, 4.0}, {1.0, 0.0, 0.0, 16.0, 1.0, 4.0}, {1.0, 14.0, 0.0, 2.0, 15.0, 4.0}, {1.0, 15.0, 0.0, 16.0, 16.0, 4.0}});
        this.addHitBoxData("modern_middle_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 0.0, 12.0, 16.0, 1.0, 16.0}});
        this.addHitBoxData("modern_middle_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 0.0, 0.0, 16.0, 1.0, 4.0}, {0.0, 15.0, 0.0, 16.0, 16.0, 4.0}});
        this.addHitBoxData("modern_right_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {15.0, 1.0, 12.0, 16.0, 5.0, 16.0}, {14.0, 1.0, 12.0, 15.0, 2.0, 16.0}, {0.0, 0.0, 12.0, 15.0, 1.0, 16.0}});
        this.addHitBoxData("modern_right_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {15.0, 1.0, 0.0, 16.0, 15.0, 4.0}, {14.0, 1.0, 0.0, 15.0, 2.0, 4.0}, {0.0, 0.0, 0.0, 15.0, 1.0, 4.0}, {14.0, 14.0, 0.0, 15.0, 15.0, 4.0}, {0.0, 15.0, 0.0, 15.0, 16.0, 4.0}});
        this.addHitBoxData("modern_single_foot", new double[][]{{0.0, 5.0, 15.0, 16.0, 8.0, 16.0}, {0.0, 1.0, 12.0, 1.0, 5.0, 16.0}, {15.0, 1.0, 12.0, 16.0, 5.0, 16.0}, {1.0, 1.0, 12.0, 2.0, 2.0, 16.0}, {14.0, 1.0, 12.0, 15.0, 2.0, 16.0}, {1.0, 0.0, 12.0, 15.0, 1.0, 16.0}});
        this.addHitBoxData("modern_single_head", new double[][]{{0.0, 5.0, 0.0, 16.0, 8.0, 1.0}, {0.0, 1.0, 0.0, 1.0, 15.0, 4.0}, {15.0, 1.0, 0.0, 16.0, 15.0, 4.0}, {1.0, 1.0, 0.0, 2.0, 2.0, 4.0}, {14.0, 1.0, 0.0, 15.0, 2.0, 4.0}, {1.0, 0.0, 0.0, 15.0, 1.0, 4.0}, {1.0, 14.0, 0.0, 2.0, 15.0, 4.0}, {14.0, 14.0, 0.0, 15.0, 15.0, 4.0}, {1.0, 15.0, 0.0, 15.0, 16.0, 4.0}});
        this.addHitBoxData("modern_rail_left", new double[][]{{0.0, 8.0, 5.0, 1.0, 12.0, 16.0}, {0.0, 12.0, 6.0, 1.0, 13.0, 15.0}});
        this.addHitBoxData("modern_rail_right", new double[][]{{15.0, 8.0, 5.0, 16.0, 12.0, 16.0}, {15.0, 12.0, 6.0, 16.0, 13.0, 15.0}});
    }

    private void loadBed_Rustic() {
        this.addHitBoxData("rustic_bunk_bottom_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 16.0, 16.0}, {13.0, 0.0, 15.0, 16.0, 16.0, 16.0}, {0.0, 12.0, 14.0, 16.0, 15.0, 15.0}});
        this.addHitBoxData("rustic_bunk_bottom_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 16.0, 1.0}, {13.0, 0.0, 0.0, 16.0, 16.0, 1.0}, {7.0, 4.0, 0.0, 9.0, 16.0, 1.0}, {0.0, 12.0, 1.0, 16.0, 15.0, 2.0}});
        this.addHitBoxData("rustic_bunk_middle_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 16.0, 16.0}, {13.0, 0.0, 15.0, 16.0, 16.0, 16.0}, {0.0, 12.0, 14.0, 16.0, 15.0, 15.0}});
        this.addHitBoxData("rustic_bunk_middle_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 16.0, 1.0}, {13.0, 0.0, 0.0, 16.0, 16.0, 1.0}, {7.0, 0.0, 0.0, 9.0, 16.0, 1.0}, {0.0, 12.0, 1.0, 16.0, 15.0, 2.0}});
        this.addHitBoxData("rustic_bunk_top_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 16.0, 16.0}, {13.0, 0.0, 15.0, 16.0, 16.0, 16.0}, {0.0, 12.0, 14.0, 16.0, 15.0, 15.0}});
        this.addHitBoxData("rustic_bunk_top_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 16.0, 1.0}, {13.0, 0.0, 0.0, 16.0, 16.0, 1.0}, {7.0, 0.0, 0.0, 9.0, 16.0, 1.0}, {0.0, 12.0, 1.0, 16.0, 15.0, 2.0}});
        this.addHitBoxData("rustic_left_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 10.0, 16.0}});
        this.addHitBoxData("rustic_left_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 16.0, 1.0}, {11.0, 4.0, 0.0, 13.0, 16.0, 1.0}, {0.0, 12.0, 1.0, 16.0, 15.0, 2.0}});
        this.addHitBoxData("rustic_middle_foot", new double[][]{{6.5, 0.0, 15.0, 9.5, 10.0, 16.0}});
        this.addHitBoxData("rustic_middle_head", new double[][]{{6.5, 0.0, 0.0, 9.5, 16.0, 1.0}, {0.0, 12.0, 1.0, 16.0, 15.0, 2.0}});
        this.addHitBoxData("rustic_right_foot", new double[][]{{13.0, 0.0, 15.0, 16.0, 10.0, 16.0}});
        this.addHitBoxData("rustic_right_head", new double[][]{{13.0, 0.0, 0.0, 16.0, 16.0, 1.0}, {3.0, 4.0, 0.0, 5.0, 16.0, 1.0}, {0.0, 12.0, 1.0, 16.0, 15.0, 2.0}});
        this.addHitBoxData("rustic_single_foot", new double[][]{{0.0, 0.0, 15.0, 3.0, 10.0, 16.0}, {13.0, 0.0, 15.0, 16.0, 10.0, 16.0}});
        this.addHitBoxData("rustic_single_head", new double[][]{{0.0, 0.0, 0.0, 3.0, 16.0, 1.0}, {13.0, 0.0, 0.0, 16.0, 16.0, 1.0}, {7.0, 4.0, 0.0, 9.0, 16.0, 1.0}, {0.0, 12.0, 1.0, 16.0, 15.0, 2.0}});
        this.addHitBoxData("rustic_rail_left", new double[][]{{0.0, 8.0, 1.0, 1.0, 12.0, 16.0}, {0.0, 12.0, 14.0, 1.0, 13.0, 16.0}});
        this.addHitBoxData("rustic_rail_right", new double[][]{{15.0, 8.0, 1.0, 16.0, 12.0, 16.0}, {15.0, 12.0, 14.0, 16.0, 13.0, 16.0}});
    }

    private void loadBed_Vintage() {
        this.addHitBoxData("vintage_bunk_bottom_foot", new double[][]{{0.0, 0.0, 15.0, 2.0, 16.0, 16.0}, {14.0, 0.0, 15.0, 16.0, 16.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 5.0, 15.0}, {14.0, 0.0, 14.0, 16.0, 5.0, 15.0}, {2.0, 2.0, 15.0, 14.0, 11.0, 16.0}, {3.0, 11.0, 15.0, 13.0, 12.0, 16.0}, {5.0, 12.0, 15.0, 11.0, 13.0, 16.0}});
        this.addHitBoxData("vintage_bunk_bottom_head", new double[][]{{0.0, 0.0, 0.0, 2.0, 16.0, 1.0}, {14.0, 0.0, 0.0, 16.0, 16.0, 1.0}, {0.0, 0.0, 1.0, 2.0, 5.0, 2.0}, {14.0, 0.0, 1.0, 16.0, 5.0, 2.0}, {2.0, 2.0, 0.0, 14.0, 14.0, 1.0}, {3.0, 14.0, 0.0, 13.0, 15.0, 1.0}, {5.0, 15.0, 0.0, 11.0, 16.0, 1.0}});
        this.addHitBoxData("vintage_bunk_middle_foot", new double[][]{{0.0, 0.0, 15.0, 2.0, 16.0, 16.0}, {14.0, 0.0, 15.0, 16.0, 16.0, 16.0}, {0.0, 2.0, 14.0, 2.0, 5.0, 15.0}, {14.0, 2.0, 14.0, 16.0, 5.0, 15.0}, {2.0, 2.0, 15.0, 14.0, 11.0, 16.0}, {3.0, 11.0, 15.0, 13.0, 12.0, 16.0}, {5.0, 12.0, 15.0, 11.0, 13.0, 16.0}});
        this.addHitBoxData("vintage_bunk_middle_head", new double[][]{{0.0, 0.0, 0.0, 2.0, 16.0, 1.0}, {14.0, 0.0, 0.0, 16.0, 16.0, 1.0}, {0.0, 2.0, 1.0, 2.0, 5.0, 2.0}, {14.0, 2.0, 1.0, 16.0, 5.0, 2.0}, {2.0, 2.0, 0.0, 14.0, 14.0, 1.0}, {3.0, 14.0, 0.0, 13.0, 15.0, 1.0}, {5.0, 15.0, 0.0, 11.0, 16.0, 1.0}});
        this.addHitBoxData("vintage_bunk_top_foot", new double[][]{{0.0, 0.0, 15.0, 2.0, 12.0, 16.0}, {14.0, 0.0, 15.0, 16.0, 12.0, 16.0}, {0.0, 2.0, 14.0, 2.0, 5.0, 15.0}, {14.0, 2.0, 14.0, 16.0, 5.0, 15.0}, {2.0, 2.0, 15.0, 14.0, 11.0, 16.0}, {3.0, 11.0, 15.0, 13.0, 12.0, 16.0}, {5.0, 12.0, 15.0, 11.0, 13.0, 16.0}});
        this.addHitBoxData("vintage_bunk_top_head", new double[][]{{0.0, 0.0, 0.0, 2.0, 15.0, 1.0}, {14.0, 0.0, 0.0, 16.0, 15.0, 1.0}, {0.0, 2.0, 1.0, 2.0, 5.0, 2.0}, {14.0, 2.0, 1.0, 16.0, 5.0, 2.0}, {2.0, 2.0, 0.0, 14.0, 14.0, 1.0}, {3.0, 14.0, 0.0, 13.0, 15.0, 1.0}, {5.0, 15.0, 0.0, 11.0, 16.0, 1.0}});
        this.addHitBoxData("vintage_left_foot", new double[][]{{0.0, 0.0, 15.0, 2.0, 12.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 5.0, 15.0}, {2.0, 2.0, 15.0, 16.0, 11.0, 16.0}, {7.0, 11.0, 15.0, 16.0, 12.0, 16.0}, {11.0, 12.0, 15.0, 16.0, 13.0, 16.0}});
        this.addHitBoxData("vintage_left_head", new double[][]{{0.0, 0.0, 0.0, 2.0, 15.0, 1.0}, {0.0, 0.0, 1.0, 2.0, 5.0, 2.0}, {2.0, 2.0, 0.0, 16.0, 14.0, 1.0}, {7.0, 14.0, 0.0, 16.0, 15.0, 1.0}, {11.0, 15.0, 0.0, 16.0, 16.0, 1.0}});
        this.addHitBoxData("vintage_middle_foot", new double[][]{{7.0, 0.0, 15.0, 9.0, 4.0, 16.0}, {0.0, 2.0, 15.0, 16.0, 11.0, 16.0}, {0.0, 11.0, 15.0, 16.0, 12.0, 16.0}, {0.0, 12.0, 15.0, 16.0, 13.0, 16.0}});
        this.addHitBoxData("vintage_middle_head", new double[][]{{7.0, 0.0, 0.0, 9.0, 4.0, 1.0}, {0.0, 2.0, 0.0, 16.0, 14.0, 1.0}, {0.0, 14.0, 0.0, 16.0, 15.0, 1.0}, {0.0, 15.0, 0.0, 16.0, 16.0, 1.0}});
        this.addHitBoxData("vintage_right_foot", new double[][]{{14.0, 0.0, 15.0, 16.0, 12.0, 16.0}, {14.0, 0.0, 14.0, 16.0, 5.0, 15.0}, {0.0, 2.0, 15.0, 14.0, 11.0, 16.0}, {0.0, 11.0, 15.0, 9.0, 12.0, 16.0}, {0.0, 12.0, 15.0, 5.0, 13.0, 16.0}});
        this.addHitBoxData("vintage_right_head", new double[][]{{14.0, 0.0, 0.0, 16.0, 15.0, 1.0}, {14.0, 0.0, 1.0, 16.0, 5.0, 2.0}, {0.0, 2.0, 0.0, 14.0, 14.0, 1.0}, {0.0, 14.0, 0.0, 9.0, 15.0, 1.0}, {0.0, 15.0, 0.0, 5.0, 16.0, 1.0}});
        this.addHitBoxData("vintage_single_foot", new double[][]{{0.0, 0.0, 15.0, 2.0, 12.0, 16.0}, {14.0, 0.0, 15.0, 16.0, 12.0, 16.0}, {0.0, 0.0, 14.0, 2.0, 5.0, 15.0}, {14.0, 0.0, 14.0, 16.0, 5.0, 15.0}, {2.0, 2.0, 15.0, 14.0, 11.0, 16.0}, {3.0, 11.0, 15.0, 13.0, 12.0, 16.0}, {5.0, 12.0, 15.0, 11.0, 13.0, 16.0}});
        this.addHitBoxData("vintage_single_head", new double[][]{{0.0, 0.0, 0.0, 2.0, 15.0, 1.0}, {14.0, 0.0, 0.0, 16.0, 15.0, 1.0}, {0.0, 0.0, 1.0, 2.0, 5.0, 2.0}, {14.0, 0.0, 1.0, 16.0, 5.0, 2.0}, {2.0, 2.0, 0.0, 14.0, 14.0, 1.0}, {3.0, 14.0, 0.0, 13.0, 15.0, 1.0}, {5.0, 15.0, 0.0, 11.0, 16.0, 1.0}});
        this.addHitBoxData("vintage_rail_left", new double[][]{{0.0, 8.0, 1.0, 1.0, 13.0, 7.0}, {0.0, 8.0, 7.0, 1.0, 12.0, 11.0}, {0.0, 8.0, 11.0, 1.0, 11.0, 15.0}});
        this.addHitBoxData("vintage_rail_right", new double[][]{{15.0, 8.0, 1.0, 16.0, 13.0, 7.0}, {15.0, 8.0, 7.0, 16.0, 12.0, 11.0}, {15.0, 8.0, 11.0, 16.0, 11.0, 15.0}});
    }
}

