/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.block;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.BlockLightingHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.render.RenderRegistry;
import shetiphian.multibeds.common.block.HitBoxHelper;
import shetiphian.multibeds.common.block.ILighting;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBeddingPackage;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public abstract class BlockMultiBedBase
extends BedBlock
implements IColored,
ILighting,
SimpleWaterloggedBlock {
    private final EnumBedStyle enumBedStyle;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final Table<String, Direction, VoxelShape> HITBOXES = new HitBoxHelper().loadBedBoxes().get();
    private static final Map<String, VoxelShape> BOXCACHE = new HashMap<String, VoxelShape>();
    private static final VoxelShape SHAPE_BASE = Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    private static final VoxelShape SHAPE_SLAB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_CUSTOM = Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_EXT = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public BlockMultiBedBase(EnumBedStyle style, BlockBehaviour.Properties properties) {
        super(DyeColor.WHITE, properties.m_60953_(BlockLightingHelper::getLightValue));
        this.enumBedStyle = style;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_49440_, (Comparable)BedPart.FOOT)).m_61124_((Property)f_49441_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockLightingHelper.LIGHTING, (Comparable)BlockLightingHelper.PackedData.UNKNOWEN));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add(this));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, BlockLightingHelper.LIGHTING});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)Roster.Tiles.BED.get()).m_155264_(pos, state);
    }

    public EnumBedStyle getBedStyle() {
        return this.enumBedStyle;
    }

    public MapColor getMapColor(BlockState state, BlockGetter world, BlockPos pos, MapColor defaultColor) {
        TileEntityMultiBed tile = BlockMultiBedBase.getTile(world, pos);
        if (tile != null) {
            return tile.getBlanketType().getMapColor();
        }
        return DyeColor.WHITE.m_284406_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        String cacheKey;
        String type = "single:single";
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEntityMultiBed) {
            type = ((TileEntityMultiBed)tile).getModelType();
        }
        if (!BOXCACHE.containsKey(cacheKey = "collision:" + this.enumBedStyle.getString() + ":" + type + ":" + (state.m_61143_((Property)f_49440_) == BedPart.FOOT ? "foot" : "head") + ":" + ((Direction)state.m_61143_((Property)f_54117_)).m_122433_())) {
            BOXCACHE.put(cacheKey, this.buildShape(state, world, pos, context, true));
        }
        return BOXCACHE.get(cacheKey);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        String cacheKey;
        String type = "single:single";
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEntityMultiBed) {
            type = ((TileEntityMultiBed)tile).getModelType();
        }
        if (!BOXCACHE.containsKey(cacheKey = this.enumBedStyle.getString() + ":" + type + ":" + (state.m_61143_((Property)f_49440_) == BedPart.FOOT ? "foot" : "head") + ":" + ((Direction)state.m_61143_((Property)f_54117_)).m_122433_())) {
            BOXCACHE.put(cacheKey, this.buildShape(state, world, pos, context, false));
        }
        return BOXCACHE.get(cacheKey);
    }

    private VoxelShape buildShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context, boolean collision) {
        if (!HITBOXES.isEmpty()) {
            Direction dir = (Direction)state.m_61143_((Property)f_54117_);
            boolean isFoot = state.m_61143_((Property)f_49440_) == BedPart.FOOT;
            String typeLegs = "single";
            String typeBody = "single";
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof TileEntityMultiBed) {
                String[] types = ((TileEntityMultiBed)tile).getModelType().split("#");
                typeLegs = types[0];
                typeBody = types[1];
            }
            typeBody = typeBody.contains("bunk") ? "single" : typeBody;
            VoxelShape[] parts = new VoxelShape[6];
            String mattress = "mattress_" + typeBody + (isFoot ? "_foot" : "_head");
            VoxelShape voxelShape = parts[2] = collision ? SHAPE_EXT : (VoxelShape)HITBOXES.get((Object)mattress, (Object)dir);
            if (!isFoot) {
                String pillow = "pillow_" + (mattress.contains("left") ? "left" : (mattress.contains("right") ? "right" : "middle"));
                parts[3] = (VoxelShape)HITBOXES.get((Object)pillow, (Object)dir);
                if (typeLegs.equalsIgnoreCase("bunk_middle") || typeLegs.equalsIgnoreCase("bunk_top")) {
                    if (typeBody.contains("left") || typeBody.contains("single")) {
                        parts[4] = (VoxelShape)HITBOXES.get((Object)(this.enumBedStyle.getString() + "_rail_left"), (Object)dir);
                    }
                    if (typeBody.contains("right") || typeBody.contains("single")) {
                        parts[5] = (VoxelShape)HITBOXES.get((Object)(this.enumBedStyle.getString() + "_rail_right"), (Object)dir);
                    }
                }
            }
            if (this.enumBedStyle == EnumBedStyle.CUSTOM) {
                return Shapes.m_83124_((VoxelShape)SHAPE_CUSTOM, (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
            }
            if (this.enumBedStyle == EnumBedStyle.SLAB) {
                return Shapes.m_83124_((VoxelShape)SHAPE_SLAB, (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
            }
            String base = this.enumBedStyle.getBaseType();
            if (!base.equalsIgnoreCase("none")) {
                parts[0] = (VoxelShape)HITBOXES.get((Object)("base_" + base + "_" + typeBody + (isFoot ? "_foot" : "_head")), (Object)dir);
            }
            String frame = this.enumBedStyle.getString() + "_" + typeLegs + (isFoot ? "_foot" : "_head");
            parts[1] = (VoxelShape)HITBOXES.get((Object)frame, (Object)dir);
            return Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
        }
        return super.m_5940_(state, world, pos, context);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_()) {
            Item item = heldItem.m_41720_();
            if (item instanceof ItemBedCustomization || item instanceof ItemBeddingPackage || item instanceof ItemEmbroideryThread) {
                return InteractionResult.PASS;
            }
            if (item instanceof BannerItem && ItemBedCustomization.putOnBed(heldItem.m_41777_(), player, world, pos, hit.m_82434_(), player.m_6047_())) {
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (player != null && player.m_6047_() && !world.m_5776_()) {
            this.removeBedding(world, pos, player);
        }
        super.m_6256_(state, world, pos, player);
    }

    public void removeBedding(Level world, BlockPos pos, Player player) {
        TileEntityMultiBed[] bedTiles = BlockMultiBedBase.getTiles((BlockGetter)world, pos);
        if (bedTiles != null) {
            int half;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            boolean dropped = false;
            for (half = 0; half < 2; ++half) {
                if (dropped || !bedTiles[half].hasBlanket()) continue;
                dropped = true;
                drops.add(bedTiles[half].getBlanketItem());
                bedTiles[0].removeBlanket();
                bedTiles[1].removeBlanket();
            }
            dropped = false;
            for (half = 0; half < 2; ++half) {
                if (dropped || !bedTiles[half].hasPillow()) continue;
                dropped = true;
                drops.add(bedTiles[half].getPillowItem());
                bedTiles[0].removePillow();
                bedTiles[1].removePillow();
            }
            dropped = false;
            for (half = 0; half < 2; ++half) {
                if (dropped || !bedTiles[half].hasSheet()) continue;
                dropped = true;
                drops.add(bedTiles[half].getSheetItem());
                bedTiles[0].removeSheet();
                bedTiles[1].removeSheet();
            }
            if (!drops.isEmpty()) {
                Function.syncTile((BlockEntity)bedTiles[0]);
                Function.syncTile((BlockEntity)bedTiles[1]);
                SoundType soundtype = SoundType.f_56745_;
                world.m_5594_(player, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                for (ItemStack stack : drops) {
                    Function.giveItem((Player)player, (ItemStack)stack);
                }
            }
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos blockpos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
        world.m_7731_(blockpos, (BlockState)((BlockState)state.m_61124_((Property)f_49440_, (Comparable)BedPart.HEAD)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(blockpos).m_76152_() == Fluids.f_76193_)), 3);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_49440_, (Comparable)BedPart.FOOT), 3);
        TileEntityMultiBed[] tiles = BlockMultiBedBase.getTiles((BlockGetter)world, pos);
        if (tiles != null) {
            ItemStack texture = ItemBlockMultiBed.getTextureStack(stack);
            CompoundTag nbtTag = new CompoundTag();
            if (tiles[0].m_58899_() == pos) {
                tiles[0].setBedTextureBlock(texture);
                tiles[0].buildNBT(nbtTag);
                tiles[1].processNBT(nbtTag);
            } else {
                tiles[1].setBedTextureBlock(texture);
                tiles[1].buildNBT(nbtTag);
                tiles[0].processNBT(nbtTag);
            }
            Function.syncTile((BlockEntity)tiles[0]);
            Function.syncTile((BlockEntity)tiles[1]);
            this.setLighting(state, world, pos, texture);
        }
        world.m_6289_(pos, Blocks.f_50016_);
        state.m_60701_((LevelAccessor)world, pos, 3);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        super.m_6861_(state, world, pos, block, neighbor, isMoving);
        TileEntityMultiBed tile = BlockMultiBedBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            if (neighbor != pos.m_121945_((Direction)state.m_61143_((Property)f_54117_))) {
                Function.syncTile((BlockEntity)tile);
            }
            this.setLighting(state, world, pos, tile.getBedTextureBlock());
        }
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        TileEntityMultiBed tile = BlockMultiBedBase.getTile(world, pos);
        return ItemBlockMultiBed.createStack((Block)this, tile != null ? tile.getBedTextureBlock() : ItemStack.f_41583_);
    }

    public static BlockPos[] getBlocks(BlockGetter world, BlockPos pos) {
        BlockPos[] bedPos = new BlockPos[]{pos, pos};
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof BlockMultiBedBase) {
            if (state.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
                bedPos[0] = pos.m_121945_((Direction)state.m_61143_((Property)BedBlock.f_54117_));
            } else {
                bedPos[1] = pos.m_121945_(((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122424_());
            }
        }
        return bedPos;
    }

    private static TileEntityMultiBed getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityMultiBed ? (TileEntityMultiBed)tile : null;
    }

    public static TileEntityMultiBed[] getTiles(BlockGetter world, BlockPos pos) {
        BlockPos[] bedBlocks = BlockMultiBedBase.getBlocks(world, pos);
        TileEntityMultiBed[] tiles = new TileEntityMultiBed[]{BlockMultiBedBase.getTile(world, bedBlocks[0]), BlockMultiBedBase.getTile(world, bedBlocks[1])};
        return tiles[0] != null && tiles[1] != null ? tiles : null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityMultiBed tile;
        if (index > -1 && index < 3 && data.world != null && data.pos != null && (tile = BlockMultiBedBase.getTile((BlockGetter)data.world, data.pos)) != null) {
            if (index == 0) {
                return tile.getMaterialColor();
            }
            if (index == 1 && tile.hasSheet()) {
                return tile.getSheetColor();
            }
            if (index == 2 && tile.hasPillow()) {
                return tile.getPillowColor();
            }
        }
        return 0xFFFFFF;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack bedding;
        if (player != null && player.m_150110_().f_35937_ && player.m_6047_() && !(bedding = ItemBeddingPackage.createFor(BlockMultiBedBase.getTiles(world, pos))).m_41619_()) {
            return bedding;
        }
        return this.m_7397_(world, pos, state);
    }
}

