/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.rgb16.BlockRGB16;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.render.RenderRegistry;

public class BlockHanger
extends BlockRGB16
implements SimpleWaterloggedBlock {
    public static final EnumProperty<EnumAttached> ATTACHED = EnumProperty.m_61587_((String)"attached", EnumAttached.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)0.0, (double)10.0, (double)15.0, (double)3.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)13.0, (double)11.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)13.0, (double)10.0, (double)15.0, (double)16.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)-4.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)-4.0, (double)10.0, (double)16.0, (double)1.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)20.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)17.0, (double)11.0, (double)6.0, (double)20.0, (double)16.0, (double)10.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)11.0, (double)20.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)17.0, (double)10.0, (double)16.0, (double)20.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)-4.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)-4.0, (double)11.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)-6.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)-6.0, (double)10.0, (double)17.0, (double)-3.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)22.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)19.0, (double)11.0, (double)6.0, (double)22.0, (double)17.0, (double)10.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)11.0, (double)22.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)19.0, (double)10.0, (double)17.0, (double)22.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)-6.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)-6.0, (double)11.0, (double)6.0, (double)-3.0, (double)17.0, (double)10.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)-2.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)-2.0, (double)10.0, (double)15.0, (double)3.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)18.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)13.0, (double)11.0, (double)6.0, (double)18.0, (double)15.0, (double)10.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)11.0, (double)18.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)13.0, (double)10.0, (double)15.0, (double)18.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)-2.0, (double)0.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)-2.0, (double)11.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)-8.0, (double)-2.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)-2.0, (double)10.0, (double)15.0, (double)3.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)-8.0, (double)2.0, (double)18.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)13.0, (double)11.0, (double)6.0, (double)18.0, (double)15.0, (double)10.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)-8.0, (double)0.0, (double)14.0, (double)11.0, (double)18.0), (VoxelShape)Block.m_49796_((double)6.0, (double)11.0, (double)13.0, (double)10.0, (double)15.0, (double)18.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)-2.0, (double)-8.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)-2.0, (double)11.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0))};

    public BlockHanger() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60978_(0.2f).m_60955_().m_278183_().m_278166_(PushReaction.DESTROY), (pos, state) -> new TileEntityRGB16((BlockEntityType)Roster.Tiles.RGB16.get(), pos, state));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(ATTACHED, (Comparable)((Object)EnumAttached.BLOCK))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ATTACHED, FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES[((EnumAttached)((Object)state.m_61143_(ATTACHED))).ordinal() * 4 + ((Direction)state.m_61143_((Property)FACING)).m_122416_()];
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        Direction direction = face.m_122434_() == Direction.Axis.Y ? context.m_8125_().m_122424_() : face;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(ATTACHED, (Comparable)((Object)this.getAttachment((LevelAccessor)world, pos, direction, face != Direction.UP)))).m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    private EnumAttached getAttachment(LevelAccessor world, BlockPos pos, Direction facing, boolean horizontals) {
        double distance;
        VoxelShape shape;
        BlockPos oPos;
        EnumAttached attached;
        boolean unusableGround = this.isUnusableGround(world, pos.m_7495_());
        EnumAttached enumAttached = attached = unusableGround ? EnumAttached.BLOCK : EnumAttached.GROUND;
        if (horizontals || unusableGround) {
            oPos = pos.m_121945_(facing.m_122424_());
            shape = world.m_8055_(oPos).m_60816_((BlockGetter)world, oPos);
            double d = distance = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 - shape.m_83297_(facing.m_122434_()) : shape.m_83288_(facing.m_122434_());
            EnumAttached enumAttached2 = distance <= 0.125 ? EnumAttached.BLOCK : (distance <= 0.25 ? EnumAttached.WALL : (attached = distance <= 0.375 ? EnumAttached.POST : attached));
        }
        if (attached == EnumAttached.GROUND) {
            oPos = pos.m_121945_(Direction.DOWN);
            shape = world.m_8055_(oPos).m_60816_((BlockGetter)world, oPos);
            distance = 1.0 - shape.m_83297_(Direction.Axis.Y);
            attached = distance <= 0.125 ? EnumAttached.GROUND : (distance <= 0.5 ? EnumAttached.GROUND_TALL : EnumAttached.BLOCK);
        }
        return attached;
    }

    private boolean isUnusableGround(LevelAccessor world, BlockPos pos) {
        if (!world.m_46859_(pos)) {
            BlockState state = world.m_8055_(pos);
            return state.m_247087_() || state.m_60734_() instanceof BlockHanger;
        }
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        state = (BlockState)state.m_61124_(ATTACHED, (Comparable)((Object)this.getAttachment(world, pos, (Direction)state.m_61143_((Property)FACING), !((EnumAttached)((Object)state.m_61143_(ATTACHED))).isGround() || this.isUnusableGround(world, pos.m_7495_()))));
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static enum EnumAttached implements StringRepresentable
    {
        BLOCK("block"),
        WALL("wall"),
        POST("post"),
        GROUND("ground"),
        GROUND_TALL("ground_tall");

        private final String name;

        private EnumAttached(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        boolean isGround() {
            return this == GROUND || this == GROUND_TALL;
        }
    }
}

