/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.ColorHandler;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.model.ModelBed;
import shetiphian.multibeds.client.model.ModelLadder;
import shetiphian.multibeds.client.render.RenderArtOnBed;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="multibeds", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RenderRegistry {
    public static List<Object> COLORIZE = new ArrayList<Object>();
    public static List<Triple<Item, String, ItemPropertyFunction>> OVERRIDES = new ArrayList<Triple<Item, String, ItemPropertyFunction>>();

    @SubscribeEvent
    public static void modelRegistryEvent(ModelEvent.RegisterGeometryLoaders event) {
        event.register("bed", (IGeometryLoader)ModelBed.INSTANCE);
        event.register("ladder", (IGeometryLoader)ModelLadder.INSTANCE);
    }

    @SubscribeEvent
    public static void blockColorHandlerEvent(RegisterColorHandlersEvent.Block event) {
        for (Object object : COLORIZE) {
            if (!(object instanceof Block)) continue;
            event.register((BlockColor)ColorHandler.BlockColor.INSTANCE, new Block[]{(Block)object});
        }
    }

    @SubscribeEvent
    public static void itemColorHandlerEvent(RegisterColorHandlersEvent.Item event) {
        for (Object object : COLORIZE) {
            if (object instanceof Block) {
                event.register((ItemColor)ColorHandler.ItemColor.INSTANCE, new ItemLike[]{Item.m_41439_((Block)((Block)object))});
                continue;
            }
            if (!(object instanceof Item)) continue;
            event.register((ItemColor)ColorHandler.ItemColor.INSTANCE, new ItemLike[]{(Item)object});
        }
    }

    @SubscribeEvent
    public static void entityRenderersEvent(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)Roster.Tiles.BED.get(), context -> new RenderArtOnBed());
    }

    public static void setupNow() {
    }

    public static void setupLater() {
        for (Triple<Item, String, ItemPropertyFunction> data : OVERRIDES) {
            ItemProperties.register((Item)((Item)data.getLeft()), (ResourceLocation)new ResourceLocation((String)data.getMiddle()), (ItemPropertyFunction)((ItemPropertyFunction)data.getRight()));
        }
        OVERRIDES.clear();
    }
}

