/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.render;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.multibeds.client.model.CacheBuilder;
import shetiphian.multibeds.client.render.CustomArtTextures;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

@OnlyIn(value=Dist.CLIENT)
public class RenderArtOnBed
implements BlockEntityRenderer<TileEntityMultiBed> {
    private static final Table<String, Direction, Boolean> MODEL_CACHE = HashBasedTable.create();
    private static final Map<int[], int[]> VERTEX_CACHE = new HashMap<int[], int[]>();
    private static final BlockColors BLOCK_COLORS = Minecraft.m_91087_().m_91298_();
    private static final ModelBlockRenderer RENDERER = new ModelBlockRenderer(BLOCK_COLORS);

    public static void rebuildCache() {
        MODEL_CACHE.clear();
        VERTEX_CACHE.clear();
    }

    public void render(TileEntityMultiBed tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ResourceLocation texture;
        String part;
        String key;
        BakedModel model;
        Triple<String, Byte, byte[]> artData;
        if (tile.getBannerEntity() == null && tile.getArtData() == null) {
            return;
        }
        Direction facing = tile.getFacing();
        if (tile.m_58904_() == null) {
            return;
        }
        BlockState state = tile.m_58900_();
        if (!(state.m_60734_() instanceof BlockMultiBedBase)) {
            return;
        }
        BannerBlockEntity banner = tile.getBannerEntity();
        if (banner != null) {
            boolean railRight;
            String[] types = tile.getModelType().split("#");
            String typeLegs = types[0];
            String typeBody = types[1];
            String typeBlanket = typeBody.contains("bunk") ? "bunk" : typeBody;
            boolean isUp = typeLegs.equalsIgnoreCase("bunk_middle") || typeLegs.equalsIgnoreCase("bunk_top");
            boolean railLeft = isUp && (typeBody.contains("left") || typeBody.contains("single"));
            boolean bl = railRight = isUp && (typeBody.contains("right") || typeBody.contains("single"));
            typeBlanket = typeLegs.contains("bunk") ? (railLeft && !railRight ? "bunk_left" : (!railLeft && railRight ? "bunk_right" : typeBlanket)) : typeBlanket;
            String key2 = "common/banner_" + typeBlanket + "_" + (tile.isBedFoot() ? "foot" : "head") + (tile.isMirrored() ? "_mirror" : "");
            BakedModel model2 = CacheBuilder.getBed(key2, "default", facing, "minecraft:white_wool");
            if (model2 != null) {
                this.localizeModelUVs(model2, key2, facing, state);
                List list = banner.m_58508_();
                for (int index = 0; index < 17 && index < list.size(); ++index) {
                    Pair pair = (Pair)list.get(index);
                    float[] values = ((DyeColor)pair.getSecond()).m_41068_();
                    Optional pattern = ((Holder)pair.getFirst()).m_203543_();
                    if (!pattern.isPresent()) continue;
                    Material material = new Material(Sheets.f_110737_, BannerPattern.m_222697_((ResourceKey)((ResourceKey)pattern.get()), (boolean)true));
                    VertexConsumer vertexBuilder = material.m_119194_(buffer, RenderType::m_110473_);
                    RENDERER.renderModel(matrixStack.m_85850_(), vertexBuilder, state, model2, values[0], values[1], values[2], combinedLight, combinedOverlay, ModelData.EMPTY, null);
                }
            }
        }
        if (tile.getCustomArt() == null && (artData = tile.getArtData()) != null) {
            byte[] indices = (byte[])artData.getRight();
            int canvasScale = Embroidery.getCanvasScale(indices);
            NativeImage image = new NativeImage(canvasScale, canvasScale, true);
            for (int row = 0; row < canvasScale; ++row) {
                for (int col = 0; col < canvasScale; ++col) {
                    int javaColor = Embroidery.getColorAt((Byte)artData.getMiddle(), indices, canvasScale * row + col);
                    int vA = (javaColor & 0xFF000000) >> 24;
                    int vR = (javaColor & 0xFF0000) >> 16;
                    int vG = (javaColor & 0xFF00) >> 8;
                    int vB = javaColor & 0xFF;
                    int mojangColor = (vA << 24) + (vB << 16) + (vG << 8) + vR;
                    image.m_84988_(col, row, mojangColor);
                }
            }
            tile.setArtLocation(CustomArtTextures.TEXTURES.getResourceLocation((String)artData.getLeft(), image));
        }
        if (tile.getCustomArt() != null && (model = CacheBuilder.getBed(key = "common/art_custom_" + (part = state.m_61143_((Property)BlockMultiBedBase.f_49440_) == BedPart.FOOT ? "foot" : "head"), "default", facing, (texture = tile.getCustomArt()).toString())) != null) {
            this.localizeModelUVs(model, key, facing, state);
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
            int color = BLOCK_COLORS.m_92577_(state, null, null, 0);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RENDERER.renderModel(matrixStack.m_85850_(), builder, state, model, red, green, blue, combinedLight, combinedOverlay, ModelData.EMPTY, null);
        }
    }

    private void localizeModelUVs(BakedModel model, String key, Direction facing, BlockState state) {
        if (model != null && !MODEL_CACHE.contains((Object)key, (Object)facing)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            List quads = model.getQuads(state, null, RandomSource.m_216327_(), ModelData.EMPTY, null);
            for (BakedQuad quad : quads) {
                TextureAtlasSprite sprite = quad.m_173410_();
                int[] vertex = quad.m_111303_();
                int vertexOffset = vertex.length / 4;
                if (!VERTEX_CACHE.containsKey(vertex)) {
                    VERTEX_CACHE.put(vertex, (int[])vertex.clone());
                }
                int[] dVertex = VERTEX_CACHE.get(vertex);
                for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                    float u = Float.intBitsToFloat(dVertex[vertexIndex * vertexOffset + 4]);
                    float v = Float.intBitsToFloat(dVertex[vertexIndex * vertexOffset + 5]);
                    u = (u - sprite.m_118409_()) / (sprite.m_118410_() - sprite.m_118409_());
                    v = (v - sprite.m_118411_()) / (sprite.m_118412_() - sprite.m_118411_());
                    vertex[vertexIndex * vertexOffset + 4] = Float.floatToRawIntBits(u);
                    vertex[vertexIndex * vertexOffset + 5] = Float.floatToRawIntBits(v);
                }
            }
            MODEL_CACHE.put((Object)key, (Object)facing, (Object)true);
        }
    }
}

