/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
class CustomArtTextures {
    static final Cache TEXTURES = new Cache();

    CustomArtTextures() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Cache {
        private final Map<String, CacheEntry> cacheMap = Maps.newLinkedHashMap();

        Cache() {
        }

        @Nullable
        ResourceLocation getResourceLocation(String id, NativeImage artImage) {
            if (((String)id).isEmpty()) {
                return null;
            }
            CacheEntry cacheEntry = this.cacheMap.get(id = "multibed." + (String)id);
            if (cacheEntry == null) {
                if (this.cacheMap.size() >= 256 && !this.freeCacheSlot()) {
                    return MissingTextureAtlasSprite.m_118071_();
                }
                cacheEntry = new CacheEntry();
                cacheEntry.textureLocation = new ResourceLocation((String)id);
                Minecraft.m_91087_().m_91097_().m_118495_(cacheEntry.textureLocation, (AbstractTexture)new DynamicTexture(artImage));
                this.cacheMap.put((String)id, cacheEntry);
            }
            cacheEntry.lastUseMillis = Util.m_137550_();
            return cacheEntry.textureLocation;
        }

        private boolean freeCacheSlot() {
            long i = Util.m_137550_();
            Iterator<String> iterator = this.cacheMap.keySet().iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                CacheEntry cacheEntry = this.cacheMap.get(s);
                if (i - cacheEntry.lastUseMillis <= 5000L) continue;
                Minecraft.m_91087_().m_91097_().m_118513_(cacheEntry.textureLocation);
                iterator.remove();
                return true;
            }
            return this.cacheMap.size() < 256;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CacheEntry {
        long lastUseMillis;
        ResourceLocation textureLocation;

        private CacheEntry() {
        }
    }
}

