/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.model.IPartData;
import shetiphian.multibeds.client.model.PartData;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

@OnlyIn(value=Dist.CLIENT)
class Parts {
    static final List<ResourceLocation> BED_TEXTURES = Parts.getBedTextures();
    static final List<IPartData> BED_MODELS = Parts.getBedModels();
    static final List<IPartData> LADDER_MODELS = Parts.getLadderModels();

    Parts() {
    }

    static String getMattressTexture() {
        return "multibeds:block/mattress";
    }

    static String getPillowTexture() {
        return "multibeds:block/pillow";
    }

    private static String getDefaultPillowTexture() {
        return "multibeds:block/pillow_bare";
    }

    static String getSheetTexture() {
        return "multibeds:block/fitted_sheet";
    }

    static String getBlanketTexture(EnumBlanket blanket) {
        return "multibeds:block/blanket/" + (blanket == EnumBlanket.BANNER ? ".banner" : blanket.m_7912_());
    }

    static String getArtTexture(EnumSpreadArt art) {
        return "multibeds:block/art/" + (art == EnumSpreadArt.CUSTOM ? ".custom" : art.m_7912_());
    }

    private static List<ResourceLocation> getBedTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(new ResourceLocation(Parts.getMattressTexture()));
        list.add(new ResourceLocation(Parts.getPillowTexture()));
        list.add(new ResourceLocation(Parts.getDefaultPillowTexture()));
        list.add(new ResourceLocation(Parts.getSheetTexture()));
        for (EnumBlanket enumBlanket : EnumBlanket.values()) {
            if (enumBlanket == EnumBlanket.NONE) continue;
            list.add(new ResourceLocation(Parts.getBlanketTexture(enumBlanket)));
        }
        for (Enum enum_ : EnumSpreadArt.values()) {
            if (enum_ == EnumSpreadArt.NONE) continue;
            list.add(new ResourceLocation(Parts.getArtTexture((EnumSpreadArt)enum_)));
        }
        return list;
    }

    private static List<IPartData> getBedModels() {
        String[] types;
        ArrayList<IPartData> list = new ArrayList<IPartData>();
        list.add(new PartData("common/art"));
        list.add(new PartData("common/art_custom_foot"));
        list.add(new PartData("common/art_custom_head"));
        for (String string : types = new String[]{"bunk", "single", "left", "middle", "right"}) {
            list.add(new PartData("common/banner_" + string + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
            list.add(new PartData("common/banner_" + string + "_foot_mirror", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
            list.add(new PartData("common/banner_" + string + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
            list.add(new PartData("common/banner_" + string + "_head_mirror", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
            list.add(new PartData("common/blanket_" + string + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_RED)));
            list.add(new PartData("common/blanket_" + string + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_RED)));
            if (string.equals("left") || string.equals("right")) {
                list.add(new PartData("common/banner_bunk_" + string + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData("common/banner_bunk_" + string + "_foot_mirror", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData("common/banner_bunk_" + string + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData("common/banner_bunk_" + string + "_head_mirror", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData("common/blanket_bunk_" + string + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_RED)));
                list.add(new PartData("common/blanket_bunk_" + string + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_RED)));
            }
            if (string.equals("bunk")) continue;
            if (!string.equals("single")) {
                list.add(new PartData("common/pillow_" + string, Parts.getDefaultPillowTexture()));
            }
            list.add(new PartData("common/mattress_" + string + "_foot", Parts.getMattressTexture()));
            list.add(new PartData("common/mattress_" + string + "_head", Parts.getMattressTexture()));
            list.add(new PartData("base/slat_" + string + "_foot"));
            list.add(new PartData("base/slat_" + string + "_head"));
            for (EnumBedStyle enumBedStyle : EnumBedStyle.values()) {
                if (!string.equalsIgnoreCase("single") && !enumBedStyle.isGangable()) continue;
                list.add(new PartData(enumBedStyle + "/" + string + "_foot"));
                list.add(new PartData(enumBedStyle + "/" + string + "_head"));
            }
        }
        types = new String[]{"bottom", "middle", "top"};
        for (EnumBedStyle enumBedStyle : EnumBedStyle.values()) {
            if (!enumBedStyle.isBunkable()) continue;
            list.add(new PartData(enumBedStyle + "/bunk_rail_left"));
            list.add(new PartData(enumBedStyle + "/bunk_rail_right"));
            for (String string : types) {
                list.add(new PartData(enumBedStyle + "/bunk_" + string + "_foot"));
                list.add(new PartData(enumBedStyle + "/bunk_" + string + "_head"));
            }
        }
        list.add(new PartData("item/parts/pillow", Parts.getDefaultPillowTexture()));
        list.add(new PartData("item/parts/mattress", Parts.getMattressTexture()));
        list.add(new PartData("item/parts/base_slat"));
        for (EnumBedStyle enumBedStyle : EnumBedStyle.values()) {
            list.add(new PartData("item/parts/bed_" + enumBedStyle));
        }
        list.add(new PartData("item/parts/blanket"));
        list.add(new PartData("item/parts/blanket_art"));
        return list;
    }

    private static List<IPartData> getLadderModels() {
        ArrayList<IPartData> list = new ArrayList<IPartData>();
        list.add(new PartData("ladder/bottom"));
        list.add(new PartData("ladder/middle"));
        list.add(new PartData("ladder/single"));
        list.add(new PartData("ladder/top"));
        list.add(new PartData("ladder/inventory"));
        return list;
    }
}

