/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.joml.Vector3f;
import shetiphian.core.client.ClientFunction;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.CompositeBakedModel;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.multibeds.client.misc.TextureInfoHelper;
import shetiphian.multibeds.client.model.CacheBuilder;
import shetiphian.multibeds.common.block.BlockLadderBase;
import shetiphian.multibeds.common.item.ItemBlockLadder;

@OnlyIn(value=Dist.CLIENT)
public class ModelLadder {
    public static final Loader INSTANCE = new Loader();

    private static void add(List<BakedModel> list, String part, String key, Direction facing, String particle) {
        BakedModel model = CacheBuilder.getLadder(part, key, facing, particle);
        if (model != null) {
            list.add(model);
        }
    }

    private static class Loader
    implements IGeometryLoader<Geometry> {
        private Loader() {
        }

        public Geometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return Geometry.INSTANCE;
        }
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static ItemTransforms transforms;

        private ItemHandler() {
        }

        BakedModel getModel(ItemStack stack, BakedModel original) {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockLadder) {
                ItemStack materialItem;
                String material;
                String modelKey;
                if (transforms == null) {
                    this.buildTransforms();
                }
                if (!CacheBuilder.INSTANCE.ITEM_CACHE.containsKey(modelKey = "ladder::" + (material = CacheBuilder.INSTANCE.getTexture(materialItem = ItemBlockLadder.getTextureStack(stack))))) {
                    ArrayList<BakedModel> list = new ArrayList<BakedModel>();
                    ModelLadder.add(list, "ladder/inventory", material, Direction.SOUTH, material);
                    BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)materialItem);
                    CacheBuilder.INSTANCE.ITEM_CACHE.put(modelKey, new AssembledBakedModel(list, new ItemTransforms[]{transforms}).setItemLayers(new RenderType[]{ClientFunction.isTranslucent((BlockState)materialState) ? Sheets.m_110792_() : (ClientFunction.isCutout((BlockState)materialState) ? Sheets.m_110790_() : Sheets.m_110789_())}));
                }
                return (BakedModel)CacheBuilder.INSTANCE.ITEM_CACHE.get(modelKey);
            }
            return original;
        }

        void buildTransforms() {
            ItemTransform thirdperson = this.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson = this.create(0.0f, 135.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform gui = this.create(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform fixed = this.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            transforms = new ItemTransforms(thirdperson, thirdperson, firstperson, firstperson, head, gui, ground, fixed);
        }

        private ItemTransform create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.mul(0.0625f);
            translation.set(Mth.m_14036_((float)translation.x, (float)-5.0f, (float)5.0f), Mth.m_14036_((float)translation.y, (float)-5.0f, (float)5.0f), Mth.m_14036_((float)translation.z, (float)-5.0f, (float)5.0f));
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.set(Mth.m_14036_((float)scale.x, (float)-4.0f, (float)4.0f), Mth.m_14036_((float)scale.y, (float)-4.0f, (float)4.0f), Mth.m_14036_((float)scale.z, (float)-4.0f, (float)4.0f));
            return new ItemTransform(rotation, translation, scale);
        }
    }

    private static class BlockHandler {
        static BlockHandler INSTANCE = new BlockHandler();

        private BlockHandler() {
        }

        List<BakedModel> getList(BlockState state, ModelData data, RenderType layer) {
            CompoundTag nbtTag;
            if (!(state.m_60734_() instanceof BlockLadderBase)) {
                return Collections.emptyList();
            }
            String ladderType = "single";
            ItemStack materialItem = TextureInfoHelper.DEFAULT_TEXTURE;
            if (data.has(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.get(ModelProperties.NBTProperty)) != null) {
                if (nbtTag.m_128441_("ladder_type")) {
                    ladderType = nbtTag.m_128461_("ladder_type");
                }
                if (nbtTag.m_128441_("ladder_material")) {
                    materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("ladder_material"));
                }
            }
            String material = CacheBuilder.INSTANCE.getTexture(materialItem);
            Direction facing = (Direction)state.m_61143_((Property)BlockLadderBase.f_54337_);
            BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)materialItem);
            boolean doRender = layer == (ClientFunction.isTranslucent((BlockState)materialState) ? RenderType.m_110466_() : (ClientFunction.isCutout((BlockState)materialState) ? RenderType.m_110463_() : RenderType.m_110451_()));
            ArrayList<BakedModel> list = new ArrayList<BakedModel>();
            if (doRender) {
                ModelLadder.add(list, "ladder/" + ladderType, material, facing, material);
            }
            return list;
        }
    }

    private static class Baked
    extends CompositeBakedModel {
        private static final BakedModel INSTANCE = new Baked();

        private Baked() {
        }

        public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
            CompoundTag nbtTag;
            ItemStack materialItem = ItemStack.f_41583_;
            if (data.has(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.get(ModelProperties.NBTProperty)) != null && nbtTag.m_128441_("ladder_material")) {
                materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("ladder_material"));
            }
            if (materialItem.m_41619_()) {
                materialItem = new ItemStack((ItemLike)Blocks.f_50058_);
            }
            return CacheBuilder.INSTANCE.getTextureSprite(materialItem);
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_(), RenderType.m_110463_(), RenderType.m_110451_()});
        }

        protected List<BakedModel> handleBlockState(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType layer) {
            return BlockHandler.INSTANCE.getList(state, data, layer);
        }

        protected BakedModel handleItemState(BakedModel model, ItemStack stack, Level world, LivingEntity entity) {
            return ItemHandler.INSTANCE.getModel(stack, model);
        }
    }

    private static class Geometry
    implements IUnbakedGeometry<Geometry> {
        private static final Geometry INSTANCE = new Geometry();

        private Geometry() {
        }

        public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            CacheBuilder.INSTANCE.preBakeSetup(bakery, spriteGetter);
            return Baked.INSTANCE;
        }
    }
}

