/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;
import shetiphian.core.client.ClientFunction;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.CompositeBakedModel;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.multibeds.client.misc.TextureInfoHelper;
import shetiphian.multibeds.client.model.CacheBuilder;
import shetiphian.multibeds.client.model.Parts;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

@OnlyIn(value=Dist.CLIENT)
public class ModelBed {
    public static final Loader INSTANCE = new Loader();

    private static void add(List<BakedModel> list, String part, String key, Direction facing, String particle) {
        BakedModel model = CacheBuilder.getBed(part, key, facing, particle);
        if (model != null) {
            list.add(model);
        }
    }

    private static class Loader
    implements IGeometryLoader<Geometry> {
        private Loader() {
        }

        public Geometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return Geometry.INSTANCE;
        }
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static ItemTransforms transforms;

        private ItemHandler() {
        }

        BakedModel getModel(ItemStack stack, BakedModel original) {
            Item item;
            if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ItemBlockMultiBed) {
                ItemBlockMultiBed bed = (ItemBlockMultiBed)item;
                if (transforms == null) {
                    this.buildTransforms();
                }
                EnumBedStyle style = EnumBedStyle.byBlock(bed.m_40614_());
                ItemStack materialItem = ItemBlockMultiBed.getTextureStack(stack);
                String material = CacheBuilder.INSTANCE.getTexture(materialItem);
                String modelKey = style + "::" + material;
                boolean hasSheet = false;
                boolean hasPillow = false;
                Pair<EnumBlanket, EnumSpreadArt> blanket = ItemBlanket.NO_DATA;
                if (bed.hasBedding(stack)) {
                    hasSheet = bed.hasSheet(stack);
                    hasPillow = bed.hasPillow(stack);
                    modelKey = modelKey + "::" + (hasSheet ? "s" : "") + (hasPillow ? "p" : "");
                    if (bed.hasBlanket(stack)) {
                        blanket = ItemBlanket.getBlanketData(bed.getBlanket(stack));
                        modelKey = modelKey + "::" + ((EnumBlanket)((Object)blanket.getLeft())).m_7912_() + ":" + ((EnumSpreadArt)((Object)blanket.getRight())).m_7912_();
                    }
                }
                if (!CacheBuilder.INSTANCE.ITEM_CACHE.containsKey(modelKey)) {
                    ArrayList<BakedModel> list = new ArrayList<BakedModel>();
                    if (blanket.getLeft() != EnumBlanket.NONE) {
                        ModelBed.add(list, "item/parts/blanket", Parts.getBlanketTexture((EnumBlanket)((Object)blanket.getLeft())), Direction.SOUTH, material);
                        if (blanket.getRight() != EnumSpreadArt.NONE) {
                            ModelBed.add(list, "item/parts/blanket_art", Parts.getArtTexture((EnumSpreadArt)((Object)blanket.getRight())), Direction.SOUTH, material);
                        }
                    }
                    ModelBed.add(list, "item/parts/pillow", hasPillow ? Parts.getPillowTexture() : "default", Direction.SOUTH, material);
                    ModelBed.add(list, "item/parts/mattress", hasSheet ? Parts.getSheetTexture() : "default", Direction.SOUTH, material);
                    ModelBed.add(list, "item/parts/base_" + style.getBaseType(), material, Direction.SOUTH, material);
                    ModelBed.add(list, "item/parts/bed_" + style.getString(), material, Direction.SOUTH, material);
                    BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)materialItem);
                    CacheBuilder.INSTANCE.ITEM_CACHE.put(modelKey, new AssembledBakedModel(list, new ItemTransforms[]{transforms}).setItemLayers(new RenderType[]{ClientFunction.isTranslucent((BlockState)materialState) ? Sheets.m_110792_() : (ClientFunction.isCutout((BlockState)materialState) ? Sheets.m_110790_() : Sheets.m_110789_())}));
                }
                return (BakedModel)CacheBuilder.INSTANCE.ITEM_CACHE.get(modelKey);
            }
            return original;
        }

        void buildTransforms() {
            ItemTransform thirdperson = this.create(30.0f, 160.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.23f, 0.23f, 0.23f);
            ItemTransform firstperson = this.create(30.0f, 160.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform gui = this.create(30.0f, 160.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.2f, 0.2f, 0.2f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform fixed = this.create(270.0f, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f, 0.5f, 0.5f, 0.5f);
            transforms = new ItemTransforms(thirdperson, thirdperson, firstperson, firstperson, head, gui, ground, fixed);
        }

        private ItemTransform create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.mul(0.0625f);
            translation.set(Mth.m_14036_((float)translation.x, (float)-5.0f, (float)5.0f), Mth.m_14036_((float)translation.y, (float)-5.0f, (float)5.0f), Mth.m_14036_((float)translation.z, (float)-5.0f, (float)5.0f));
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.set(Mth.m_14036_((float)scale.x, (float)-4.0f, (float)4.0f), Mth.m_14036_((float)scale.y, (float)-4.0f, (float)4.0f), Mth.m_14036_((float)scale.z, (float)-4.0f, (float)4.0f));
            return new ItemTransform(rotation, translation, scale);
        }
    }

    private static class BlockHandler {
        static BlockHandler INSTANCE = new BlockHandler();

        private BlockHandler() {
        }

        List<BakedModel> getList(BlockState state, ModelData data, RenderType layer) {
            boolean railRight;
            CompoundTag nbtTag;
            if (!(state.m_60734_() instanceof BlockMultiBedBase)) {
                return Collections.emptyList();
            }
            String typeLegs = "single";
            String typeBody = "single";
            ItemStack materialItem = TextureInfoHelper.DEFAULT_TEXTURE;
            boolean hasSheet = false;
            boolean hasPillowCase = false;
            EnumBlanket blanket = EnumBlanket.NONE;
            EnumSpreadArt art = EnumSpreadArt.NONE;
            if (data.has(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.get(ModelProperties.NBTProperty)) != null) {
                if (nbtTag.m_128441_("bed_type")) {
                    String[] types = nbtTag.m_128461_("bed_type").split("#");
                    typeLegs = types[0];
                    typeBody = types[1];
                }
                if (nbtTag.m_128441_("bed_material")) {
                    materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("bed_material"));
                }
                if (nbtTag.m_128441_("has_sheet")) {
                    hasSheet = nbtTag.m_128471_("has_sheet");
                }
                if (nbtTag.m_128441_("has_pillowcase")) {
                    hasPillowCase = nbtTag.m_128471_("has_pillowcase");
                }
                if (nbtTag.m_128441_("blanket_type")) {
                    blanket = EnumBlanket.byName(nbtTag.m_128461_("blanket_type"));
                }
                if (nbtTag.m_128441_("art_type")) {
                    art = EnumSpreadArt.byName(nbtTag.m_128461_("art_type"));
                }
            }
            String typeBlanket = typeBody.contains("bunk") ? "bunk" : typeBody;
            String string = typeBody = typeBody.contains("bunk") ? "single" : typeBody;
            String typePillow = typeBody.contains("left") ? "left" : (typeBody.contains("right") ? "right" : "middle");
            String material = CacheBuilder.INSTANCE.getTexture(materialItem);
            String part = state.m_61143_((Property)BlockMultiBedBase.f_49440_) == BedPart.FOOT ? "foot" : "head";
            Direction facing = (Direction)state.m_61143_((Property)BlockMultiBedBase.f_54117_);
            EnumBedStyle style = EnumBedStyle.byBlock(state.m_60734_());
            String base = style.getBaseType();
            boolean isUp = typeLegs.equalsIgnoreCase("bunk_middle") || typeLegs.equalsIgnoreCase("bunk_top");
            boolean railLeft = isUp && (typeBody.contains("left") || typeBody.contains("single"));
            boolean bl = railRight = isUp && (typeBody.contains("right") || typeBody.contains("single"));
            typeBlanket = typeLegs.contains("bunk") ? (railLeft && !railRight ? "bunk_left" : (!railLeft && railRight ? "bunk_right" : typeBlanket)) : typeBlanket;
            BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)materialItem);
            boolean renderFrame = layer == (ClientFunction.isTranslucent((BlockState)materialState) ? RenderType.m_110466_() : (ClientFunction.isCutout((BlockState)materialState) ? RenderType.m_110463_() : RenderType.m_110451_()));
            ArrayList<BakedModel> list = new ArrayList<BakedModel>();
            if (renderFrame) {
                if (!base.equalsIgnoreCase("none")) {
                    ModelBed.add(list, "base/" + base + "_" + typeBody + "_" + part, material, facing, material);
                }
                ModelBed.add(list, style + "/" + typeLegs + "_" + part, material, facing, material);
                if (part.equalsIgnoreCase("head")) {
                    if (railLeft) {
                        ModelBed.add(list, style + "/bunk_rail_left", material, facing, material);
                    }
                    if (railRight) {
                        ModelBed.add(list, style + "/bunk_rail_right", material, facing, material);
                    }
                }
            }
            if (layer == RenderType.m_110451_()) {
                if (hasSheet) {
                    ModelBed.add(list, "common/mattress_" + typeBody + "_" + part, Parts.getSheetTexture(), facing, material);
                } else {
                    ModelBed.add(list, "common/mattress_" + typeBody + "_" + part, "default", facing, material);
                }
                if (part.equalsIgnoreCase("head")) {
                    if (hasPillowCase) {
                        ModelBed.add(list, "common/pillow_" + typePillow, Parts.getPillowTexture(), facing, material);
                    } else {
                        ModelBed.add(list, "common/pillow_" + typePillow, "default", facing, material);
                    }
                }
                if (blanket != EnumBlanket.NONE && blanket != EnumBlanket.BANNER) {
                    ModelBed.add(list, "common/blanket_" + typeBlanket + "_" + part, Parts.getBlanketTexture(blanket), facing, material);
                }
            }
            if (layer == RenderType.m_110466_() && blanket != EnumBlanket.NONE && part.equalsIgnoreCase("foot") && art != EnumSpreadArt.NONE && art != EnumSpreadArt.CUSTOM) {
                ModelBed.add(list, "common/art", Parts.getArtTexture(art), facing, material);
            }
            return list;
        }
    }

    private static class Baked
    extends CompositeBakedModel {
        private static final BakedModel INSTANCE = new Baked();

        private Baked() {
        }

        public boolean m_7541_() {
            return false;
        }

        public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
            CompoundTag nbtTag;
            ItemStack materialItem = ItemStack.f_41583_;
            if (data.has(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.get(ModelProperties.NBTProperty)) != null && nbtTag.m_128441_("bed_material")) {
                materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("bed_material"));
            }
            if (materialItem.m_41619_()) {
                materialItem = new ItemStack((ItemLike)Blocks.f_50041_);
            }
            return CacheBuilder.INSTANCE.getTextureSprite(materialItem);
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_(), RenderType.m_110463_(), RenderType.m_110451_()});
        }

        protected List<BakedModel> handleBlockState(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType layer) {
            return BlockHandler.INSTANCE.getList(state, data, layer);
        }

        protected BakedModel handleItemState(BakedModel model, ItemStack stack, Level world, LivingEntity entity) {
            return ItemHandler.INSTANCE.getModel(stack, model);
        }
    }

    private static class Geometry
    implements IUnbakedGeometry<Geometry> {
        private static final Geometry INSTANCE = new Geometry();

        private Geometry() {
        }

        public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            CacheBuilder.INSTANCE.preBakeSetup(bakery, spriteGetter);
            return Baked.INSTANCE;
        }
    }
}

