/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.misc;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.multibeds.common.misc.Embroidery;

public class WIPProject {
    private final byte[] preview;
    private final byte palette;
    private final String[] layers;
    private final boolean[] visible;
    private final int canvasScale;

    public WIPProject(byte[] preview, byte palette, byte[][] layers, boolean[] visible, int canvasScale) {
        this(preview, palette, WIPProject.convert(palette, layers), visible, canvasScale);
    }

    private static String[] convert(byte palette, byte[][] layers) {
        String[] layerTags = new String[layers.length];
        for (int index = 0; index < layers.length; ++index) {
            layerTags[index] = Embroidery.fromUncompressed(palette, layers[index]).buildShareTag(new String[0]);
        }
        return layerTags;
    }

    public WIPProject(byte[] preview, byte palette, String[] layers, boolean[] visible, int canvasScale) {
        this.preview = preview;
        this.palette = palette;
        this.layers = layers;
        this.visible = visible;
        this.canvasScale = canvasScale;
    }

    public byte[] getPreview() {
        return this.preview;
    }

    public byte getPalette() {
        return this.palette;
    }

    public byte[] getLayer(int index) {
        Pair<String, Embroidery> data;
        if (index >= 0 && index < this.layers.length && (data = Embroidery.fromShareTag(this.layers[index])) != null) {
            return ((Embroidery)data.getRight()).getIndices();
        }
        return new byte[this.canvasScale * this.canvasScale];
    }

    public boolean isVisible(int index) {
        if (index >= 0 && index < this.layers.length) {
            return this.visible[index];
        }
        return true;
    }

    public int getCanvasScale() {
        return this.canvasScale;
    }

    public static WIPProject fromNbtTag(CompoundTag tag) {
        ListTag layerList = tag.m_128437_("layers", 10);
        String[] layers = new String[layerList.size()];
        boolean[] visible = new boolean[layerList.size()];
        AtomicInteger index = new AtomicInteger();
        layerList.forEach(layerTag -> {
            layers[index.get()] = ((CompoundTag)layerTag).m_128461_("data");
            visible[index.get()] = ((CompoundTag)layerTag).m_128471_("visible");
            index.getAndIncrement();
        });
        return new WIPProject(tag.m_128463_("preview"), tag.m_128445_("palette"), layers, visible, (int)tag.m_128445_("scale"));
    }

    public CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128382_("preview", this.preview);
        tag.m_128344_("palette", this.palette);
        ListTag layerList = new ListTag();
        for (int index = 0; index < this.layers.length; ++index) {
            CompoundTag layerTag = new CompoundTag();
            layerTag.m_128359_("data", this.layers[index]);
            layerTag.m_128379_("visible", this.isVisible(index));
            layerList.add((Object)layerTag);
        }
        tag.m_128365_("layers", (Tag)layerList);
        tag.m_128344_("scale", (byte)this.canvasScale);
        return tag;
    }
}

