/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.misc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumSpreadArt;
import shetiphian.multibeds.common.tileentity.TileEntityLadder;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class TextureInfoHelper {
    public static final ItemStack DEFAULT_TEXTURE = new ItemStack((ItemLike)Blocks.f_50705_);

    public static List<Component> getHUD(TileEntityMultiBed bed, boolean textures) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (textures) {
            TextureInfoHelper.addTextureInfo(lines, bed.getBedTextureBlock());
        } else {
            ItemStack sheet;
            ItemStack pillow;
            DyeColor color;
            if (bed.hasBlanket()) {
                ItemStack blanket = bed.getBlanketItem();
                if (blanket.m_41720_() instanceof ItemBlanket) {
                    color = ((ItemBlanket)blanket.m_41720_()).getColor(blanket);
                    String pattern = ItemBlanket.getPatternName(blanket);
                    if (pattern.equalsIgnoreCase("plain")) {
                        lines.add((Component)Component.m_237113_((String)" + ").m_7220_((Component)Component.m_237115_((String)("color." + color.m_41065_()))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"item.multibeds.blanket")));
                    } else {
                        lines.add((Component)Component.m_237113_((String)" + ").m_7220_((Component)Component.m_237115_((String)("color." + color.m_41065_()))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("misc.multibeds.pattern." + pattern))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"item.multibeds.blanket")));
                    }
                } else if (blanket.m_41720_() instanceof BannerItem) {
                    lines.add((Component)Component.m_237113_((String)" + ").m_7220_((Component)Component.m_237115_((String)blanket.m_41778_())));
                }
                EnumSpreadArt art = ItemEmbroideryThread.getArtwork(blanket);
                if (art != EnumSpreadArt.NONE) {
                    lines.add((Component)Component.m_237113_((String)" * ").m_7220_((Component)Component.m_237115_((String)"misc.multibeds.art")).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("misc.multibeds.art." + art.m_7912_()))));
                }
            }
            if (bed.hasPillow() && (pillow = bed.getPillowItem()).m_41720_() instanceof ItemBedCustomization) {
                color = ((ItemBedCustomization)pillow.m_41720_()).getColor(pillow);
                lines.add((Component)Component.m_237113_((String)" + ").m_7220_((Component)Component.m_237115_((String)("color." + color.m_41065_()))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"item.multibeds.pillow")));
            }
            if (bed.hasSheet() && (sheet = bed.getSheetItem()).m_41720_() instanceof ItemBedCustomization) {
                color = ((ItemBedCustomization)sheet.m_41720_()).getColor(sheet);
                lines.add((Component)Component.m_237113_((String)" + ").m_7220_((Component)Component.m_237115_((String)("color." + color.m_41065_()))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"item.multibeds.sheet")));
            }
        }
        return lines;
    }

    public static List<Component> getHUD(TileEntityLadder ladder) {
        ArrayList<Component> lines = new ArrayList<Component>();
        TextureInfoHelper.addTextureInfo(lines, ladder.getBedTextureBlock());
        return lines;
    }

    private static void addTextureInfo(List<Component> lines, ItemStack stack) {
        if (!stack.m_41619_()) {
            lines.add((Component)Component.m_237113_((String)" * ").m_7220_((Component)Component.m_237115_((String)stack.m_41778_())));
        } else {
            TextureInfoHelper.addTextureError(lines, new String[0]);
        }
    }

    public static void addTextureInfo(List<Component> lines, CompoundTag tag, String textureKey) {
        if (tag.m_128441_(textureKey)) {
            CompoundTag itemNbt = tag.m_128469_(textureKey);
            ItemStack tagStack = ItemStack.m_41712_((CompoundTag)itemNbt);
            if (!tagStack.m_41619_()) {
                lines.add((Component)Component.m_237113_((String)" * ").m_7220_((Component)Component.m_237115_((String)tagStack.m_41778_())));
            } else {
                TextureInfoHelper.addTextureError(lines, itemNbt.m_128441_("id") ? itemNbt.m_128461_("id") : "");
            }
        } else {
            TextureInfoHelper.addTextureError(lines, new String[0]);
        }
    }

    public static void addTextureError(List<Component> lines, String ... invalid) {
        if (invalid.length == 0) {
            lines.add((Component)Component.m_237113_((String)" * \u26a0 ").m_7220_((Component)Component.m_237115_((String)"info.shetiphian.texture.missing")).m_130946_(" \u26a0"));
        } else {
            lines.add((Component)Component.m_237113_((String)" * \u26a0 ").m_7220_((Component)Component.m_237115_((String)"info.shetiphian.texture.invalid")).m_130946_(" \u26a0"));
            if (!Strings.isNullOrEmpty((String)invalid[0])) {
                lines.add((Component)Component.m_237113_((String)" ** ").m_7220_((Component)Component.m_237115_((String)invalid[0])));
            }
        }
        lines.add((Component)Component.m_237113_((String)" ** ").m_7220_((Component)Component.m_237115_((String)"info.shetiphian.texture.defaulted")).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)DEFAULT_TEXTURE.m_41778_())));
    }
}

