/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.multibeds.client.gui.Textures;
import shetiphian.multibeds.common.inventory.ContainerBuilder;
import shetiphian.multibeds.common.misc.EnumBedStyle;

@OnlyIn(value=Dist.CLIENT)
public class GuiBuilder
extends AbstractContainerScreen<ContainerBuilder> {
    private final Player player;
    private EntityGuiItem displayItem = null;
    private Component displayName = Component.m_237119_();

    public GuiBuilder(ContainerBuilder screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, title);
        this.player = inv.f_35978_;
        this.f_97726_ = 182;
        this.f_97727_ = 233;
        ((ContainerBuilder)this.f_97732_).setInventoryChangeCallback(this::updatePreview);
        this.updatePreview();
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        if (((ContainerBuilder)this.f_97732_).getBuilderMode() == ContainerBuilder.BuilderMode.BED) {
            this.m_142416_(new ButtonIndex(this.f_97735_ + 44, this.f_97736_ + 11, -1));
            this.m_142416_(new ButtonIndex(this.f_97735_ + 128, this.f_97736_ + 11, 1));
        }
    }

    private void updatePreview() {
        try {
            this.displayItem = new EntityGuiItem(this.player.m_9236_(), 0.0, 0.0, 0.0, ((ContainerBuilder)this.f_97732_).getPreviewItem().m_41777_().m_41620_(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (((ContainerBuilder)this.f_97732_).getBuilderMode() == ContainerBuilder.BuilderMode.BED) {
            this.displayName = Component.m_237115_((String)("block.multibeds." + EnumBedStyle.byIndex(((ContainerBuilder)this.f_97732_).getBedStyleIndex()).getString()));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        if (this.displayItem != null) {
            int top = this.f_97736_ + (((ContainerBuilder)this.f_97732_).getBuilderMode() == ContainerBuilder.BuilderMode.BED ? 82 : 88);
            this.displayItem.render(graphics, true, 160.0f, 0.0f, 0.0f, (float)(this.f_97735_ + 91), (float)top, 50.0f, -120.0f, 120.0f, 120.0f);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(graphics);
        ResourceLocation texture = Textures.BED_KIT.get();
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.f_97735_, (double)this.f_97736_, (int)0, (int)23, (int)this.f_97726_, (int)this.f_97727_, (ResourceLocation)texture);
        Slot slot = ((ContainerBuilder)this.f_97732_).getSlotBaseItem();
        if (!slot.m_6657_() && ((ContainerBuilder)this.f_97732_).getBuilderMode() == ContainerBuilder.BuilderMode.BED) {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + slot.f_40220_), (double)(this.f_97736_ + slot.f_40221_), (int)224, (int)16, (int)16, (int)16, (ResourceLocation)texture);
        }
        if (!(slot = ((ContainerBuilder)this.f_97732_).getSlotMaterial()).m_6657_()) {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + slot.f_40220_), (double)(this.f_97736_ + slot.f_40221_), (int)240, (int)16, (int)16, (int)16, (ResourceLocation)texture);
        }
        graphics.m_280653_(this.f_96547_, this.displayName, this.f_96543_ / 2, this.f_97736_ + 11, texture.m_135815_().startsWith("textures/gui/vanilla/") ? 0x404040 : 0xC0C0C0);
    }

    protected void m_280003_(GuiGraphics graphics, int x, int y) {
    }

    private class ButtonIndex
    extends Button
    implements GuiEventListener {
        int shift;

        ButtonIndex(int posX, int posY, int indexShift) {
            super(posX, posY, 12, 9, (Component)Component.m_237119_(), null, f_252438_);
            this.shift = indexShift;
        }

        public void m_5691_() {
            if (this.f_93622_) {
                int index = ((ContainerBuilder)GuiBuilder.this.f_97732_).getBedStyleIndex();
                int max = EnumBedStyle.values().length - 1;
                index += this.shift;
                MultiPlayerGameMode controller = Minecraft.m_91087_().f_91072_;
                if (controller != null) {
                    controller.m_105208_(((ContainerBuilder)((GuiBuilder)GuiBuilder.this).f_97732_).f_38840_, index < 0 ? max : (index > max ? 0 : index));
                }
            }
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int index = (this.shift > 0 ? 1 : 0) + (this.f_93622_ ? 2 : 0);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.m_252754_(), (double)this.m_252907_(), (int)(194 + index * 16), (int)5, (int)this.f_93618_, (int)this.f_93619_, (ResourceLocation)Textures.BED_KIT.get());
        }
    }
}

