/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import shetiphian.core.common.rgb16.BlockItemRGB16;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.multibeds.CreativeTabs;
import shetiphian.multibeds.client.gui.GuiBlanketLoom;
import shetiphian.multibeds.client.gui.GuiBuilder;
import shetiphian.multibeds.client.render.RenderRegistry;
import shetiphian.multibeds.common.block.BlockEarthBed;
import shetiphian.multibeds.common.block.BlockEarthLadder;
import shetiphian.multibeds.common.block.BlockHanger;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.crafting.RecipeSpool;
import shetiphian.multibeds.common.crafting.RecipeUncraft;
import shetiphian.multibeds.common.inventory.ContainerBlanketLoom;
import shetiphian.multibeds.common.inventory.ContainerBuilder;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBeddingPackage;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemBlockLadder;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.item.ItemBuilderKit;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.item.ItemPillowSheet;
import shetiphian.multibeds.common.loot.BannerLootCondition;
import shetiphian.multibeds.common.loot.BannerLootHandler;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.tileentity.TileEntityLadder;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class Roster {
    static void setup(IEventBus eventBus) {
        Blocks.REGISTRY.register(eventBus);
        Tiles.REGISTRY.register(eventBus);
        Items.REGISTRY.register(eventBus);
        Recipes.REGISTRY.register(eventBus);
        RecipeSerializers.REGISTRY.register(eventBus);
        Containers.REGISTRY.register(eventBus);
        eventBus.addListener(Roster::LootConditions);
        LootModifiers.REGISTRY.register(eventBus);
        CreativeTabs.init(eventBus);
    }

    static void process() {
        Block[] allBeds = new Block[]{(Block)Blocks.CUSTOM.get(), (Block)Blocks.SLAB.get(), (Block)Blocks.COT.get(), (Block)Blocks.CLASSIC.get(), (Block)Blocks.VINTAGE.get(), (Block)Blocks.MODERN.get(), (Block)Blocks.RUSTIC.get()};
        ImmutableSet states = ImmutableSet.copyOf((Collection)Arrays.stream(allBeds).flatMap(block -> block.m_49965_().m_61056_().stream()).filter(state -> state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD).collect(Collectors.toSet()));
        Map poimap = GameData.getBlockStatePointOfInterestTypeMap();
        PoiType home = (PoiType)ForgeRegistries.POI_TYPES.getValue(PoiTypes.f_218060_.m_135782_());
        states.forEach(state -> {
            if (!poimap.containsKey(state)) {
                poimap.put(state, home);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    static void registerScreenFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)Containers.BED_KIT.get()), GuiBuilder::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Containers.BLANKET_LOOM.get()), GuiBlanketLoom::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Containers.LADDER_KIT.get()), GuiBuilder::new);
    }

    public static void LootConditions(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registries.f_256976_)) {
            event.register(Registries.f_256976_, new ResourceLocation("multibeds:is_banner"), () -> BannerLootCondition.LOOT_CONDITION_TYPE);
        }
    }

    public static class Blocks {
        private static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"multibeds");
        public static final RegistryObject<BlockMultiBedBase> CUSTOM = REGISTRY.register("custom", () -> new BlockEarthBed(EnumBedStyle.CUSTOM));
        public static final RegistryObject<BlockMultiBedBase> SLAB = REGISTRY.register("slab", () -> new BlockEarthBed(EnumBedStyle.SLAB));
        public static final RegistryObject<BlockMultiBedBase> COT = REGISTRY.register("cot", () -> new BlockEarthBed(EnumBedStyle.COT));
        public static final RegistryObject<BlockMultiBedBase> CLASSIC = REGISTRY.register("classic", () -> new BlockEarthBed(EnumBedStyle.CLASSIC));
        public static final RegistryObject<BlockMultiBedBase> VINTAGE = REGISTRY.register("vintage", () -> new BlockEarthBed(EnumBedStyle.VINTAGE));
        public static final RegistryObject<BlockMultiBedBase> MODERN = REGISTRY.register("modern", () -> new BlockEarthBed(EnumBedStyle.MODERN));
        public static final RegistryObject<BlockMultiBedBase> RUSTIC = REGISTRY.register("rustic", () -> new BlockEarthBed(EnumBedStyle.RUSTIC));
        public static final RegistryObject<Block> HANGER = REGISTRY.register("hanger", BlockHanger::new);
        public static final RegistryObject<Block> LADDER = REGISTRY.register("ladder", BlockEarthLadder::new);
    }

    public static class Tiles {
        private static final DeferredRegister<BlockEntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"multibeds");
        public static final RegistryObject<BlockEntityType<TileEntityMultiBed>> BED = REGISTRY.register("bed", () -> BlockEntityType.Builder.m_155273_(TileEntityMultiBed::new, (Block[])new Block[]{(Block)Blocks.CUSTOM.get(), (Block)Blocks.SLAB.get(), (Block)Blocks.COT.get(), (Block)Blocks.CLASSIC.get(), (Block)Blocks.VINTAGE.get(), (Block)Blocks.MODERN.get(), (Block)Blocks.RUSTIC.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<TileEntityRGB16>> RGB16 = REGISTRY.register("rgb16", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new TileEntityRGB16((BlockEntityType)RGB16.get(), pos, state), (Block[])new Block[]{(Block)Blocks.HANGER.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<TileEntityLadder>> LADDER = REGISTRY.register("ladder", () -> BlockEntityType.Builder.m_155273_(TileEntityLadder::new, (Block[])new Block[]{(Block)Blocks.LADDER.get()}).m_58966_(null));
    }

    public static class Items {
        static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"multibeds");
        public static final RegistryObject<BlockItem> CUSTOM = REGISTRY.register("custom", () -> new ItemBlockMultiBed((Block)Blocks.CUSTOM.get(), Items.stackable()));
        public static final RegistryObject<BlockItem> SLAB = REGISTRY.register("slab", () -> new ItemBlockMultiBed((Block)Blocks.SLAB.get(), Items.stackable()));
        public static final RegistryObject<BlockItem> COT = REGISTRY.register("cot", () -> new ItemBlockMultiBed((Block)Blocks.COT.get(), Items.stackable()));
        public static final RegistryObject<BlockItem> CLASSIC = REGISTRY.register("classic", () -> new ItemBlockMultiBed((Block)Blocks.CLASSIC.get(), Items.stackable()));
        public static final RegistryObject<BlockItem> VINTAGE = REGISTRY.register("vintage", () -> new ItemBlockMultiBed((Block)Blocks.VINTAGE.get(), Items.stackable()));
        public static final RegistryObject<BlockItem> MODERN = REGISTRY.register("modern", () -> new ItemBlockMultiBed((Block)Blocks.MODERN.get(), Items.stackable()));
        public static final RegistryObject<BlockItem> RUSTIC = REGISTRY.register("rustic", () -> new ItemBlockMultiBed((Block)Blocks.RUSTIC.get(), Items.stackable()));
        public static final RegistryObject<BlockItem> HANGER = REGISTRY.register("hanger", () -> new BlockItemRGB16((Block)Blocks.HANGER.get(), Items.stackable(), DyeColor.WHITE).tint(new int[]{0}).callback(item -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add(item))));
        public static final RegistryObject<BlockItem> LADDER = REGISTRY.register("ladder", () -> new ItemBlockLadder((Block)Blocks.LADDER.get(), Items.stackable()));
        public static final RegistryObject<Item> WOOLEN_CLOTH = REGISTRY.register("woolen_cloth", () -> new Item(Items.stackable()));
        public static final RegistryObject<Item> FEATHER_PILE = REGISTRY.register("feather_pile", () -> new Item(Items.stackable()));
        public static final RegistryObject<Item> PADDING = REGISTRY.register("padding", () -> new Item(Items.stackable()));
        public static final RegistryObject<Item> BED_KIT = REGISTRY.register("bed_kit", () -> new ItemBuilderKit.Bed(Items.stackable()));
        public static final RegistryObject<Item> LADDER_TOOLS = REGISTRY.register("ladder_tools", () -> new ItemBuilderKit.Ladder(Items.stackable()));
        public static final RegistryObject<Item> EMBROIDERY_THREAD = REGISTRY.register("embroidery_thread", () -> new ItemEmbroideryThread(Items.singleton()));
        public static final RegistryObject<Item> BEDDING_PACKAGE = REGISTRY.register("bedding_package", () -> new ItemBeddingPackage(Items.stackable()));
        public static final RegistryObject<Item> SHEET = REGISTRY.register("sheet", () -> new ItemPillowSheet(Items.stackable(), ItemBedCustomization.EnumType.SHEET));
        public static final RegistryObject<Item> PILLOW = REGISTRY.register("pillow", () -> new ItemPillowSheet(Items.stackable(), ItemBedCustomization.EnumType.PILLOW));
        public static final RegistryObject<ItemBlanket> BLANKET_WHITE = REGISTRY.register("blanket_white", () -> new ItemBlanket(Items.stackable(), DyeColor.WHITE));
        public static final RegistryObject<ItemBlanket> BLANKET_ORANGE = REGISTRY.register("blanket_orange", () -> new ItemBlanket(Items.stackable(), DyeColor.ORANGE));
        public static final RegistryObject<ItemBlanket> BLANKET_MAGENTA = REGISTRY.register("blanket_magenta", () -> new ItemBlanket(Items.stackable(), DyeColor.MAGENTA));
        public static final RegistryObject<ItemBlanket> BLANKET_LIGHT_BLUE = REGISTRY.register("blanket_light_blue", () -> new ItemBlanket(Items.stackable(), DyeColor.LIGHT_BLUE));
        public static final RegistryObject<ItemBlanket> BLANKET_YELLOW = REGISTRY.register("blanket_yellow", () -> new ItemBlanket(Items.stackable(), DyeColor.YELLOW));
        public static final RegistryObject<ItemBlanket> BLANKET_LIME = REGISTRY.register("blanket_lime", () -> new ItemBlanket(Items.stackable(), DyeColor.LIME));
        public static final RegistryObject<ItemBlanket> BLANKET_PINK = REGISTRY.register("blanket_pink", () -> new ItemBlanket(Items.stackable(), DyeColor.PINK));
        public static final RegistryObject<ItemBlanket> BLANKET_GRAY = REGISTRY.register("blanket_gray", () -> new ItemBlanket(Items.stackable(), DyeColor.GRAY));
        public static final RegistryObject<ItemBlanket> BLANKET_LIGHT_GRAY = REGISTRY.register("blanket_light_gray", () -> new ItemBlanket(Items.stackable(), DyeColor.LIGHT_GRAY));
        public static final RegistryObject<ItemBlanket> BLANKET_CYAN = REGISTRY.register("blanket_cyan", () -> new ItemBlanket(Items.stackable(), DyeColor.CYAN));
        public static final RegistryObject<ItemBlanket> BLANKET_PURPLE = REGISTRY.register("blanket_purple", () -> new ItemBlanket(Items.stackable(), DyeColor.PURPLE));
        public static final RegistryObject<ItemBlanket> BLANKET_BLUE = REGISTRY.register("blanket_blue", () -> new ItemBlanket(Items.stackable(), DyeColor.BLUE));
        public static final RegistryObject<ItemBlanket> BLANKET_BROWN = REGISTRY.register("blanket_brown", () -> new ItemBlanket(Items.stackable(), DyeColor.BROWN));
        public static final RegistryObject<ItemBlanket> BLANKET_GREEN = REGISTRY.register("blanket_green", () -> new ItemBlanket(Items.stackable(), DyeColor.GREEN));
        public static final RegistryObject<ItemBlanket> BLANKET_RED = REGISTRY.register("blanket_red", () -> new ItemBlanket(Items.stackable(), DyeColor.RED));
        public static final RegistryObject<ItemBlanket> BLANKET_BLACK = REGISTRY.register("blanket_black", () -> new ItemBlanket(Items.stackable(), DyeColor.BLACK));

        private static Item.Properties stackable() {
            return new Item.Properties();
        }

        private static Item.Properties singleton() {
            return Items.stackable().m_41487_(1);
        }
    }

    public static class Recipes {
        private static final DeferredRegister<RecipeType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"multibeds");
        public static final RegistryObject<RecipeType<RecipeSpool>> SPOOLING = REGISTRY.register("spooling", () -> RecipeType.simple((ResourceLocation)new ResourceLocation("multibeds:spooling")));
    }

    public static class RecipeSerializers {
        private static final DeferredRegister<RecipeSerializer<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"multibeds");
        public static final RegistryObject<RecipeSerializer<RecipeSpool>> SPOOLING = REGISTRY.register("spooling", () -> new SimpleCraftingRecipeSerializer(RecipeSpool::new));
        public static final RegistryObject<RecipeSerializer<RecipeUncraft>> UNCRAFT = REGISTRY.register("uncraft", () -> new SimpleCraftingRecipeSerializer(RecipeUncraft::new));
    }

    public static class Containers {
        private static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"multibeds");
        public static final RegistryObject<MenuType<ContainerBuilder>> BED_KIT = REGISTRY.register("bed_kit", () -> IForgeMenuType.create((windowId, invPlayer, data) -> ContainerBuilder.Bed(windowId, invPlayer)));
        public static final RegistryObject<MenuType<ContainerBlanketLoom>> BLANKET_LOOM = REGISTRY.register("blanket_loom", () -> IForgeMenuType.create((windowId, invPlayer, data) -> new ContainerBlanketLoom(windowId, invPlayer)));
        public static final RegistryObject<MenuType<ContainerBuilder>> LADDER_KIT = REGISTRY.register("ladder_kit", () -> IForgeMenuType.create((windowId, invPlayer, data) -> ContainerBuilder.Ladder(windowId, invPlayer)));
    }

    public static class LootModifiers {
        private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> REGISTRY = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"multibeds");
        public static final RegistryObject<Codec<BannerLootHandler>> BANNER_EMBROIDERY = REGISTRY.register("banner_embroidery", () -> BannerLootHandler.CODEC);
    }
}

