/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.logging;

import com.connectivity.Connectivity;
import com.connectivity.logging.ByteBufferTypeHandler;
import com.connectivity.logging.EntityTypeHandler;
import com.connectivity.logging.GsonOptionalTypeHandler;
import com.connectivity.networkstats.INamedPacket;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ReflectionAccessFilter;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.EntityType;

public class PacketLogging {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().addReflectionAccessFilter(ReflectionAccessFilter.BLOCK_INACCESSIBLE_JAVA).registerTypeHierarchyAdapter(Optional.class, new GsonOptionalTypeHandler()).registerTypeHierarchyAdapter(EntityType.class, new EntityTypeHandler()).registerTypeHierarchyAdapter(FriendlyByteBuf.class, new ByteBufferTypeHandler()).create();

    public static void logPacket(Packet<?> packet) {
        PacketLogging.logPacket(packet, "");
    }

    public static void logPacket(Packet<?> packet, String warning) {
        String name = packet.getClass().getSimpleName();
        if (packet instanceof INamedPacket && !((INamedPacket)packet).getName().isEmpty()) {
            name = ((INamedPacket)packet).getName();
        }
        Connectivity.LOGGER.warn("Packet:" + name + " " + warning);
        try {
            Connectivity.LOGGER.warn("Packet data:\n" + GSON.toJson(packet));
        }
        catch (Throwable e) {
            Connectivity.LOGGER.warn("Failed to print data for packet", e);
        }
    }
}

