/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.support;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.support.ModSupport;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftcapes.config.MinecraftCapesConfig;
import net.minecraftcapes.player.PlayerHandler;

public class MinecraftCapesSupport
implements ModSupport {
    private MinecraftCapesRenderer render = new MinecraftCapesRenderer();

    @Override
    public boolean shouldBeUsed(AbstractClientPlayer player) {
        if (!MinecraftCapesConfig.isCapeVisible()) {
            return false;
        }
        return PlayerHandler.get((Player)player).getCapeLocation() != null;
    }

    @Override
    public CapeRenderer getRenderer() {
        return this.render;
    }

    @Override
    public boolean blockFeatureRenderer(Object feature) {
        return false;
    }

    private class MinecraftCapesRenderer
    implements CapeRenderer {
        private MinecraftCapesRenderer() {
        }

        @Override
        public void render(AbstractClientPlayer player, int part, ModelPart model, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
            PlayerHandler playerHandler = PlayerHandler.get((Player)player);
            VertexConsumer vertexConsumer = MinecraftCapesConfig.isCapeVisible() && playerHandler.getCapeLocation() != null ? ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)playerHandler.getCapeLocation()), (boolean)false, (boolean)playerHandler.getHasCapeGlint()) : ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)player.m_108561_()), (boolean)false, (boolean)false);
            model.m_104301_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_);
        }

        @Override
        public VertexConsumer getVertexConsumer(MultiBufferSource multiBufferSource, AbstractClientPlayer player) {
            PlayerHandler playerHandler = PlayerHandler.get((Player)player);
            if (MinecraftCapesConfig.isCapeVisible() && playerHandler.getCapeLocation() != null) {
                return ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)playerHandler.getCapeLocation()), (boolean)false, (boolean)playerHandler.getHasCapeGlint());
            }
            return ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)player.m_108561_()), (boolean)false, (boolean)false);
        }

        @Override
        public boolean vanillaUvValues() {
            return true;
        }
    }
}

