/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tr7zw.waveycapes.CapeMovement;
import dev.tr7zw.waveycapes.CapeStyle;
import dev.tr7zw.waveycapes.WindMode;
import dev.tr7zw.waveycapes.config.Config;
import dev.tr7zw.waveycapes.config.ConfigUpgrader;
import dev.tr7zw.waveycapes.config.CustomConfigScreen;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class WaveyCapesBase {
    public static WaveyCapesBase INSTANCE;
    public static final Logger LOGGER;
    public static Config config;
    private final File settingsFile = new File("config", "waveycapes.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void init() {
        INSTANCE = this;
        if (this.settingsFile.exists()) {
            try {
                config = (Config)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex) {
                System.out.println("Error while loading config! Creating a new one!");
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new Config();
            this.writeConfig();
        } else if (ConfigUpgrader.upgradeConfig(config)) {
            this.writeConfig();
        }
        this.initSupportHooks();
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public Screen createConfigScreen(Screen parent) {
        CustomConfigScreen screen = new CustomConfigScreen(parent, "text.wc.title"){
            private int rotationX;
            private int rotationY;
            {
                this.rotationX = 164;
                this.rotationY = 5;
            }

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getEnumOption("text.wc.setting.capestyle", CapeStyle.class, () -> WaveyCapesBase.config.capeStyle, v -> {
                    WaveyCapesBase.config.capeStyle = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.windmode", WindMode.class, () -> WaveyCapesBase.config.windMode, v -> {
                    WaveyCapesBase.config.windMode = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.capemovement", CapeMovement.class, () -> WaveyCapesBase.config.capeMovement, v -> {
                    WaveyCapesBase.config.capeMovement = v;
                }));
                options.add(this.getIntOption("text.wc.setting.gravity", 5, 32, () -> WaveyCapesBase.config.gravity, v -> {
                    WaveyCapesBase.config.gravity = v;
                }));
                options.add(this.getIntOption("text.wc.setting.heightMultiplier", 4, 16, () -> WaveyCapesBase.config.heightMultiplier, v -> {
                    WaveyCapesBase.config.heightMultiplier = v;
                }));
                this.getOptions().m_232533_(options.toArray(new OptionInstance[0]));
            }

            @Override
            public void save() {
                WaveyCapesBase.this.writeConfig();
            }

            public boolean m_7933_(int i, int j, int k) {
                if (i == 263) {
                    --this.rotationX;
                }
                if (i == 262) {
                    ++this.rotationX;
                }
                if (i == 264) {
                    --this.rotationY;
                }
                if (i == 265) {
                    ++this.rotationY;
                }
                return super.m_7933_(i, j, k);
            }

            @Override
            public void m_88315_(GuiGraphics guiGraphics, int xMouse, int yMouse, float f) {
                super.m_88315_(guiGraphics, xMouse, yMouse, f);
                if (this.f_96541_.f_91073_ != null) {
                    int x = this.f_96541_.m_91268_().m_85445_() / 2;
                    int y = this.f_96541_.m_91268_().m_85446_() - this.f_96541_.m_91268_().m_85446_() / 3;
                    int size = (int)(40.0f * ((float)this.f_96541_.m_91268_().m_85446_() / 200.0f));
                    WaveyCapesBase.this.drawEntity(x, y, size, this.rotationX, this.rotationY, (LivingEntity)this.f_96541_.f_91074_, f);
                }
            }

            @Override
            public void reset() {
                config = new Config();
                WaveyCapesBase.this.writeConfig();
            }
        };
        return screen;
    }

    private void drawEntity(int x, int y, int size, float lookX, float lookY, LivingEntity livingEntity, float delta) {
        float rotationModifyer = 3.0f;
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_(0.0, 1.0, 1000.0);
        matrixStack.m_85841_((float)size, (float)size, (float)size);
        Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf quaternion2 = Axis.f_252529_.m_252977_(lookY * rotationModifyer);
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack.m_252781_(quaternion);
        matrixStack.m_85837_(0.0, -1.0, 0.0);
        float yBodyRot = livingEntity.f_20883_;
        float yRot = livingEntity.m_146908_();
        float yRotO = livingEntity.f_19859_;
        float yBodyRotO = livingEntity.f_20884_;
        float xRot = livingEntity.m_146909_();
        float xRotO = livingEntity.f_19860_;
        float yHeadRotO = livingEntity.f_20886_;
        float yHeadRot = livingEntity.f_20885_;
        Vec3 vel = livingEntity.m_20184_();
        livingEntity.f_20883_ = 180.0f + lookX * rotationModifyer;
        livingEntity.m_146922_(180.0f + lookX * rotationModifyer);
        livingEntity.f_20884_ = livingEntity.f_20883_;
        livingEntity.f_19859_ = livingEntity.m_146908_();
        livingEntity.m_20256_(Vec3.f_82478_);
        livingEntity.m_146926_(0.0f);
        livingEntity.f_19860_ = livingEntity.m_146909_();
        livingEntity.f_20885_ = livingEntity.m_146908_();
        livingEntity.f_20886_ = livingEntity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternion2.conjugate();
        entityRenderDispatcher.m_252923_(quaternion2);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, delta, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        livingEntity.f_20883_ = yBodyRot;
        livingEntity.f_20884_ = yBodyRotO;
        livingEntity.m_146922_(yRot);
        livingEntity.f_19859_ = yRotO;
        livingEntity.m_146926_(xRot);
        livingEntity.f_19860_ = xRotO;
        livingEntity.f_20886_ = yHeadRotO;
        livingEntity.f_20885_ = yHeadRot;
        livingEntity.m_20256_(vel);
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    public abstract void initSupportHooks();

    protected static boolean doesClassExist(String name) {
        try {
            if (Class.forName(name) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static {
        LOGGER = LogManager.getLogger((String)"WaveyCapes");
    }
}

