/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import dev.tr7zw.waveycapes.CapeMovement;
import dev.tr7zw.waveycapes.WaveyCapesBase;
import dev.tr7zw.waveycapes.math.Vector3;
import dev.tr7zw.waveycapes.sim.BasicSimulation;
import dev.tr7zw.waveycapes.sim.StickSimulation;
import dev.tr7zw.waveycapes.sim.StickSimulation3d;
import dev.tr7zw.waveycapes.sim.StickSimulationDungeons;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;

public interface CapeHolder {
    public BasicSimulation getSimulation();

    public void setSimulation(BasicSimulation var1);

    default public void updateSimulation(AbstractClientPlayer abstractClientPlayer, int partCount) {
        BasicSimulation simulation = this.getSimulation();
        if (simulation == null || this.incorrectSimulation(simulation)) {
            simulation = this.createSimulation();
            this.setSimulation(simulation);
        }
        if (simulation == null) {
            return;
        }
        boolean dirty = simulation.init(partCount);
        if (dirty) {
            simulation.applyMovement(new Vector3(1.0f, 1.0f, 0.0f));
            for (int i = 0; i < 5; ++i) {
                this.simulate(abstractClientPlayer);
            }
        }
    }

    default public boolean incorrectSimulation(BasicSimulation sim) {
        CapeMovement style = WaveyCapesBase.config.capeMovement;
        if (style == CapeMovement.BASIC_SIMULATION && sim.getClass() != StickSimulation.class) {
            return true;
        }
        if (style == CapeMovement.BASIC_SIMULATION_3D && sim.getClass() != StickSimulation3d.class) {
            return true;
        }
        return style == CapeMovement.DUNGEONS && sim.getClass() != StickSimulationDungeons.class;
    }

    default public BasicSimulation createSimulation() {
        CapeMovement style = WaveyCapesBase.config.capeMovement;
        if (style == CapeMovement.BASIC_SIMULATION) {
            return new StickSimulation();
        }
        if (style == CapeMovement.BASIC_SIMULATION_3D) {
            return new StickSimulation3d();
        }
        if (style == CapeMovement.DUNGEONS) {
            return new StickSimulationDungeons();
        }
        return null;
    }

    default public void simulate(AbstractClientPlayer abstractClientPlayer) {
        BasicSimulation simulation = this.getSimulation();
        if (simulation == null || simulation.empty()) {
            return;
        }
        double d = abstractClientPlayer.f_36105_ - abstractClientPlayer.m_20185_();
        double m = abstractClientPlayer.f_36075_ - abstractClientPlayer.m_20189_();
        float n = abstractClientPlayer.f_20884_ + abstractClientPlayer.f_20883_ - abstractClientPlayer.f_20884_;
        double o = Mth.m_14031_((float)(n * ((float)Math.PI / 180)));
        double p = -Mth.m_14089_((float)(n * ((float)Math.PI / 180)));
        float heightMul = WaveyCapesBase.config.heightMultiplier;
        float straveMul = WaveyCapesBase.config.straveMultiplier;
        if (abstractClientPlayer.m_5842_()) {
            heightMul *= 2.0f;
        }
        double fallHack = Mth.m_14008_((double)((abstractClientPlayer.f_19855_ - abstractClientPlayer.m_20186_()) * 10.0), (double)0.0, (double)1.0);
        if (abstractClientPlayer.m_5842_()) {
            simulation.setGravity((float)WaveyCapesBase.config.gravity / 10.0f);
        } else {
            simulation.setGravity(WaveyCapesBase.config.gravity);
        }
        Vector3 gravity = new Vector3(0.0f, -1.0f, 0.0f);
        StickSimulation.Vector2 strave = new StickSimulation.Vector2((float)(abstractClientPlayer.m_20185_() - abstractClientPlayer.f_19854_), (float)(abstractClientPlayer.m_20189_() - abstractClientPlayer.f_19856_));
        strave.rotateDegrees(-abstractClientPlayer.m_146908_());
        double changeX = d * o + m * p + fallHack + (double)(abstractClientPlayer.m_6047_() && !simulation.isSneaking() ? 3 : 0);
        double changeY = (abstractClientPlayer.m_20186_() - abstractClientPlayer.f_19855_) * (double)heightMul + (double)(abstractClientPlayer.m_6047_() && !simulation.isSneaking() ? 1 : 0);
        double changeZ = -strave.x * straveMul;
        simulation.setSneaking(abstractClientPlayer.m_6047_());
        Vector3 change = new Vector3((float)changeX, (float)changeY, (float)changeZ);
        if (abstractClientPlayer.m_6067_()) {
            float rotation = abstractClientPlayer.m_146909_();
            gravity.rotateDegrees(rotation += 90.0f);
            change.rotateDegrees(rotation);
        }
        simulation.setGravityDirection(gravity);
        simulation.applyMovement(change);
        simulation.simulate();
    }
}

