/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;

public class RegionFileStorageExternalCache
implements AutoCloseable {
    public final RegionFileStorage storage;
    public static final int MAX_CACHE_SIZE = 16;
    public ConcurrentLinkedQueue<RegionFileCache> regionFileCache = new ConcurrentLinkedQueue();

    @Override
    public void close() throws IOException {
        RegionFileCache cache;
        while ((cache = this.regionFileCache.poll()) != null) {
            cache.file.close();
        }
    }

    public RegionFileStorageExternalCache(RegionFileStorage storage) {
        this.storage = storage;
    }

    @Nullable
    public RegionFile getRegionFile(ChunkPos pos) throws IOException {
        long posLong = ChunkPos.m_45589_((int)pos.m_45610_(), (int)pos.m_45612_());
        RegionFile rFile = null;
        int retryCount = 0;
        int maxRetryCount = 8;
        while (retryCount < maxRetryCount) {
            ++retryCount;
            try {
                rFile = (RegionFile)this.storage.f_63699_.getOrDefault(posLong, null);
                break;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (retryCount >= maxRetryCount) {
            BatchGenerationEnvironment.LOAD_LOGGER.warn("Concurrency issue detected when getting region file for chunk at " + pos + ".", new Object[0]);
        }
        if (rFile != null) {
            return rFile;
        }
        for (RegionFileCache cache : this.regionFileCache) {
            if (cache.pos != posLong) continue;
            return cache.file;
        }
        Path storageFolderPath = this.storage.f_63700_;
        if (!Files.exists(storageFolderPath, new LinkOption[0])) {
            return null;
        }
        Path regionFilePath = storageFolderPath.resolve("r." + pos.m_45610_() + "." + pos.m_45612_() + ".mca");
        rFile = new RegionFile(regionFilePath, storageFolderPath, false);
        this.regionFileCache.add(new RegionFileCache(ChunkPos.m_45589_((int)pos.m_45610_(), (int)pos.m_45612_()), rFile));
        while (this.regionFileCache.size() > 16) {
            this.regionFileCache.poll().file.close();
        }
        return rFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public CompoundTag read(ChunkPos pos) throws IOException {
        RegionFile file = this.getRegionFile(pos);
        if (file == null) {
            return null;
        }
        try (DataInputStream stream = file.m_63645_(pos);){
            if (stream == null) {
                CompoundTag compoundTag2 = null;
                return compoundTag2;
            }
            CompoundTag compoundTag = NbtIo.m_128928_((DataInput)stream);
            return compoundTag;
        }
        catch (Throwable e) {
            return null;
        }
    }

    static class RegionFileCache {
        public final long pos;
        public final RegionFile file;

        public RegionFileCache(long pos, RegionFile file) {
            this.pos = pos;
            this.file = file;
        }
    }
}

