/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IKeyedClientLevelManager;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.cache.ClientBlockDetailMap;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftClientWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientLevelWrapper
implements IClientLevelWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(ClientLevelWrapper.class.getSimpleName());
    private static final ConcurrentHashMap<ClientLevel, ClientLevelWrapper> LEVEL_WRAPPER_BY_CLIENT_LEVEL = new ConcurrentHashMap();
    private static final IKeyedClientLevelManager KEYED_CLIENT_LEVEL_MANAGER = SingletonInjector.INSTANCE.get(IKeyedClientLevelManager.class);
    private final ClientLevel level;
    private final ClientBlockDetailMap blockMap = new ClientBlockDetailMap(this);

    protected ClientLevelWrapper(ClientLevel level) {
        this.level = level;
    }

    public static IClientLevelWrapper getWrapper(ClientLevel level) {
        if (KEYED_CLIENT_LEVEL_MANAGER.getUseOverrideWrapper()) {
            return KEYED_CLIENT_LEVEL_MANAGER.getOverrideWrapper();
        }
        return ClientLevelWrapper.getWrapperIgnoringOverride(level);
    }

    public static IClientLevelWrapper getWrapperIgnoringOverride(ClientLevel level) {
        return LEVEL_WRAPPER_BY_CLIENT_LEVEL.computeIfAbsent(level, ClientLevelWrapper::new);
    }

    @Override
    @Nullable
    public IServerLevelWrapper tryGetServerSideWrapper() {
        try {
            Iterable serverLevels = MinecraftClientWrapper.INSTANCE.mc.m_91092_().m_129785_();
            ServerLevelWrapper foundLevelWrapper = null;
            for (ServerLevel serverLevel : serverLevels) {
                if (serverLevel.m_46472_() != this.level.m_46472_()) continue;
                foundLevelWrapper = ServerLevelWrapper.getWrapper(serverLevel);
                break;
            }
            return foundLevelWrapper;
        }
        catch (Exception e) {
            LOGGER.error("Failed to get server side wrapper for client level: " + this.level);
            return null;
        }
    }

    @Override
    public int computeBaseColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper blockState) {
        return this.blockMap.getColor(((BlockStateWrapper)blockState).blockState, (BiomeWrapper)biome, pos);
    }

    @Override
    public IDimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.m_6042_());
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.CLIENT_LEVEL;
    }

    public ClientLevel getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.m_6042_().f_63856_();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.m_6042_().f_223549_();
    }

    @Override
    public int getHeight() {
        return this.level.m_141928_();
    }

    @Override
    public int getMinHeight() {
        return this.level.m_141937_();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.m_7232_(pos.x, pos.z)) {
            return null;
        }
        ChunkAccess chunk = this.level.m_6522_(pos.x, pos.z, ChunkStatus.f_62314_, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, (LevelReader)this.level, this);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        ClientChunkCache source = this.level.m_7726_();
        return source.m_5563_(chunkX, chunkZ);
    }

    @Override
    public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return BlockStateWrapper.fromBlockState(this.level.m_8055_(McObjectConverter.Convert(pos)), this);
    }

    @Override
    public IBiomeWrapper getBiome(DhBlockPos pos) {
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)this.level.m_204166_(McObjectConverter.Convert(pos)), this);
    }

    public ClientLevel getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_BY_CLIENT_LEVEL.remove(this.level);
    }

    public String toString() {
        if (this.level == null) {
            return "Wrapped{null}";
        }
        return "Wrapped{" + this.level.toString() + "@" + this.getDimensionType().getDimensionName() + "}";
    }
}

