/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block;

import com.google.common.collect.ImmutableList;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.Logger;

public class BlockStateWrapper
implements IBlockStateWrapper {
    public static final String RESOURCE_LOCATION_SEPARATOR = ":";
    public static final String STATE_STRING_SEPARATOR = "_STATE_";
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final ConcurrentHashMap<BlockState, BlockStateWrapper> WRAPPER_BY_BLOCK_STATE = new ConcurrentHashMap();
    public static final String AIR_STRING = "AIR";
    public static final BlockStateWrapper AIR = new BlockStateWrapper(null, null);
    public static final String[] RENDERER_IGNORED_BLOCKS_RESOURCE_LOCATIONS = new String[]{"AIR", "minecraft:barrier", "minecraft:structure_void", "minecraft:light", "minecraft:tripwire"};
    public static HashSet<IBlockStateWrapper> rendererIgnoredBlocks = null;
    public final BlockState blockState;
    private String serialString;

    public static BlockStateWrapper fromBlockState(BlockState blockState, ILevelWrapper levelWrapper) {
        if (blockState == null || blockState.m_60795_()) {
            return AIR;
        }
        if (WRAPPER_BY_BLOCK_STATE.containsKey(blockState)) {
            return WRAPPER_BY_BLOCK_STATE.get(blockState);
        }
        BlockStateWrapper newWrapper = new BlockStateWrapper(blockState, levelWrapper);
        WRAPPER_BY_BLOCK_STATE.put(blockState, newWrapper);
        return newWrapper;
    }

    private BlockStateWrapper(BlockState blockState, ILevelWrapper levelWrapper) {
        this.blockState = blockState;
        this.serialString = this.serialize(levelWrapper);
        LOGGER.trace("Created BlockStateWrapper [" + this.serialString + "] for [" + blockState + "]");
    }

    public static HashSet<IBlockStateWrapper> getRendererIgnoredBlocks(ILevelWrapper levelWrapper) {
        if (rendererIgnoredBlocks != null) {
            return rendererIgnoredBlocks;
        }
        HashSet<BlockStateWrapper> blockStateWrappers = new HashSet<BlockStateWrapper>();
        for (String blockResourceLocation : RENDERER_IGNORED_BLOCKS_RESOURCE_LOCATIONS) {
            try {
                BlockStateWrapper DefaultBlockStateToIgnore = (BlockStateWrapper)BlockStateWrapper.deserialize(blockResourceLocation, levelWrapper);
                blockStateWrappers.add(DefaultBlockStateToIgnore);
                if (DefaultBlockStateToIgnore == AIR) continue;
                ImmutableList blockStatesToIgnore = DefaultBlockStateToIgnore.blockState.m_60734_().m_49965_().m_61056_();
                for (BlockState blockState : blockStatesToIgnore) {
                    BlockStateWrapper newBlockToIgnore = BlockStateWrapper.fromBlockState(blockState, levelWrapper);
                    blockStateWrappers.add(newBlockToIgnore);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Unable to deserialize rendererIgnoredBlock with the resource location: [" + blockResourceLocation + "]. Error: " + e.getMessage(), (Throwable)e);
            }
        }
        rendererIgnoredBlocks = blockStateWrappers;
        return rendererIgnoredBlocks;
    }

    @Override
    public int getOpacity() {
        if (this.isAir() || !this.blockState.m_60815_()) {
            return 0;
        }
        return 16;
    }

    @Override
    public int getLightEmission() {
        return this.blockState != null ? this.blockState.m_60791_() : 0;
    }

    @Override
    public String getSerialString() {
        return this.serialString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockStateWrapper that = (BlockStateWrapper)obj;
        return Objects.equals(this.getSerialString(), that.getSerialString());
    }

    public int hashCode() {
        return Objects.hash(this.getSerialString());
    }

    @Override
    public Object getWrappedMcObject() {
        return this.blockState;
    }

    @Override
    public boolean isAir() {
        return this.isAir(this.blockState);
    }

    public boolean isAir(BlockState blockState) {
        return blockState == null || blockState.m_60795_();
    }

    @Override
    public boolean isSolid() {
        return !this.blockState.m_60812_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_).m_83281_();
    }

    @Override
    public boolean isLiquid() {
        if (this.isAir()) {
            return false;
        }
        return !this.blockState.m_60819_().m_76178_();
    }

    public String toString() {
        return this.getSerialString();
    }

    private String serialize(ILevelWrapper levelWrapper) {
        if (this.blockState == null) {
            return AIR_STRING;
        }
        Level level = (Level)levelWrapper.getWrappedMcObject();
        RegistryAccess registryAccess = level.m_9598_();
        ResourceLocation resourceLocation = registryAccess.m_175515_(Registries.f_256747_).m_7981_((Object)this.blockState.m_60734_());
        if (resourceLocation == null) {
            LOGGER.warn("No ResourceLocation found, unable to serialize: " + this.blockState);
            return AIR_STRING;
        }
        this.serialString = resourceLocation.m_135827_() + RESOURCE_LOCATION_SEPARATOR + resourceLocation.m_135815_() + STATE_STRING_SEPARATOR + BlockStateWrapper.serializeBlockStateProperties(this.blockState);
        return this.serialString;
    }

    public static IBlockStateWrapper deserialize(String resourceStateString, ILevelWrapper levelWrapper) throws IOException {
        int resourceSeparatorIndex;
        if (resourceStateString.equals(AIR_STRING) || resourceStateString.equals("")) {
            return AIR;
        }
        String blockStatePropertiesString = null;
        int stateSeparatorIndex = resourceStateString.indexOf(STATE_STRING_SEPARATOR);
        if (stateSeparatorIndex != -1) {
            blockStatePropertiesString = resourceStateString.substring(stateSeparatorIndex + STATE_STRING_SEPARATOR.length());
            resourceStateString = resourceStateString.substring(0, stateSeparatorIndex);
        }
        if ((resourceSeparatorIndex = resourceStateString.indexOf(RESOURCE_LOCATION_SEPARATOR)) == -1) {
            throw new IOException("Unable to parse Resource Location out of string: [" + resourceStateString + "].");
        }
        ResourceLocation resourceLocation = new ResourceLocation(resourceStateString.substring(0, resourceSeparatorIndex), resourceStateString.substring(resourceSeparatorIndex + 1));
        try {
            Level level = levelWrapper != null ? (Level)levelWrapper.getWrappedMcObject() : null;
            level = level == null ? Minecraft.m_91087_().f_91073_ : level;
            RegistryAccess registryAccess = level.m_9598_();
            Block block = (Block)registryAccess.m_175515_(Registries.f_256747_).m_7745_(resourceLocation);
            if (block == null) {
                LOGGER.warn("Unable to find BlockState with the resourceLocation [" + resourceLocation + "] and properties: [" + blockStatePropertiesString + "]. Air will be used instead, some data may be lost.");
                return AIR;
            }
            BlockState foundState = null;
            if (blockStatePropertiesString != null) {
                ImmutableList possibleStateList = block.m_49965_().m_61056_();
                for (BlockState possibleState : possibleStateList) {
                    String possibleStatePropertiesString = BlockStateWrapper.serializeBlockStateProperties(possibleState);
                    if (!possibleStatePropertiesString.equals(blockStatePropertiesString)) continue;
                    foundState = possibleState;
                    break;
                }
            }
            if (foundState == null) {
                if (blockStatePropertiesString != null) {
                    LOGGER.warn("Unable to find BlockState for Block [" + resourceLocation + "] with properties: [" + blockStatePropertiesString + "]. Using the default block state.");
                }
                foundState = block.m_49966_();
            }
            return new BlockStateWrapper(foundState, levelWrapper);
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize the string [" + resourceStateString + "] into a BlockStateWrapper: " + e.getMessage(), e);
        }
    }

    private static String serializeBlockStateProperties(BlockState blockState) {
        Collection blockPropertyCollection = blockState.m_61147_();
        ArrayList sortedBlockPropteryList = new ArrayList(blockPropertyCollection);
        sortedBlockPropteryList.sort((a, b) -> a.m_61708_().compareTo(b.m_61708_()));
        StringBuilder stringBuilder = new StringBuilder();
        for (Property property : sortedBlockPropteryList) {
            String propertyName = property.m_61708_();
            String value = "NULL";
            if (blockState.m_61138_(property)) {
                value = blockState.m_61143_(property).toString();
            }
            stringBuilder.append("{");
            stringBuilder.append(propertyName).append(RESOURCE_LOCATION_SEPARATOR).append(value);
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }
}

