/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers;

import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import java.nio.FloatBuffer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import org.joml.Matrix4f;

public class McObjectConverter {
    static final Direction[] directions;
    static final EDhDirection[] lodDirections;

    private static int bufferIndex(int x, int y) {
        return y * 4 + x;
    }

    private static void storeMatrix(Matrix4f matrix, FloatBuffer buffer) {
        buffer.put(McObjectConverter.bufferIndex(0, 0), matrix.m00());
        buffer.put(McObjectConverter.bufferIndex(0, 1), matrix.m01());
        buffer.put(McObjectConverter.bufferIndex(0, 2), matrix.m02());
        buffer.put(McObjectConverter.bufferIndex(0, 3), matrix.m03());
        buffer.put(McObjectConverter.bufferIndex(1, 0), matrix.m10());
        buffer.put(McObjectConverter.bufferIndex(1, 1), matrix.m11());
        buffer.put(McObjectConverter.bufferIndex(1, 2), matrix.m12());
        buffer.put(McObjectConverter.bufferIndex(1, 3), matrix.m13());
        buffer.put(McObjectConverter.bufferIndex(2, 0), matrix.m20());
        buffer.put(McObjectConverter.bufferIndex(2, 1), matrix.m21());
        buffer.put(McObjectConverter.bufferIndex(2, 2), matrix.m22());
        buffer.put(McObjectConverter.bufferIndex(2, 3), matrix.m23());
        buffer.put(McObjectConverter.bufferIndex(3, 0), matrix.m30());
        buffer.put(McObjectConverter.bufferIndex(3, 1), matrix.m31());
        buffer.put(McObjectConverter.bufferIndex(3, 2), matrix.m32());
        buffer.put(McObjectConverter.bufferIndex(3, 3), matrix.m33());
    }

    public static Mat4f Convert(Matrix4f mcMatrix) {
        FloatBuffer buffer = FloatBuffer.allocate(16);
        McObjectConverter.storeMatrix(mcMatrix, buffer);
        Mat4f matrix = new Mat4f(buffer);
        return matrix;
    }

    public static BlockPos Convert(DhBlockPos wrappedPos) {
        return new BlockPos(wrappedPos.x, wrappedPos.y, wrappedPos.z);
    }

    public static ChunkPos Convert(DhChunkPos wrappedPos) {
        return new ChunkPos(wrappedPos.x, wrappedPos.z);
    }

    public static Direction Convert(EDhDirection lodDirection) {
        return directions[lodDirection.ordinal()];
    }

    public static EDhDirection Convert(Direction direction) {
        return lodDirections[direction.ordinal()];
    }

    public static void DebugCheckAllPackers() {
        BiConsumer<Integer, Integer> func = (x, z) -> DhChunkPos._DebugCheckPacker(x, z, ChunkPos.m_45589_((int)x, (int)z));
        func.accept(0, 0);
        func.accept(12345, 134);
        func.accept(-12345, -134);
        func.accept(-1875000, 1875000);
        func.accept(1875000, -1875000);
        func.accept(1875000, 1875000);
        func.accept(-1875000, -1875000);
        Consumer<BlockPos> func2 = p -> DhBlockPos._DebugCheckPacker(p.m_123341_(), p.m_123342_(), p.m_123343_(), p.m_121878_());
        func2.accept(new BlockPos(0, 0, 0));
        func2.accept(new BlockPos(12345, 134, 123));
        func2.accept(new BlockPos(-12345, -134, -80));
        func2.accept(new BlockPos(-30000000, 2047, 30000000));
        func2.accept(new BlockPos(30000000, -2048, -30000000));
        func2.accept(new BlockPos(30000000, 2047, 30000000));
        func2.accept(new BlockPos(-30000000, -2048, -30000000));
    }

    static {
        EDhDirection[] lodDirs = EDhDirection.values();
        directions = new Direction[lodDirs.length];
        lodDirections = new EDhDirection[lodDirs.length];
        for (EDhDirection lodDir : lodDirs) {
            Direction dir = switch (lodDir.name().toUpperCase()) {
                case "DOWN" -> Direction.DOWN;
                case "UP" -> Direction.UP;
                case "NORTH" -> Direction.NORTH;
                case "SOUTH" -> Direction.SOUTH;
                case "WEST" -> Direction.WEST;
                case "EAST" -> Direction.EAST;
                default -> null;
            };
            if (dir == null) {
                throw new IllegalArgumentException("Invalid direction on init mapping: " + lodDir);
            }
            McObjectConverter.directions[lodDir.ordinal()] = dir;
            McObjectConverter.lodDirections[dir.ordinal()] = lodDir;
        }
    }
}

